<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SUMPS ServiceType
 * @subpackage Services
 */
class SUMPS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SUMPSadrziOIB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SUMPSadrziOIB $parameters
     * @return \StructType\SUMPSadrziOIBResponse|bool
     */
    public function SUMPSadrziOIB(\StructType\SUMPSadrziOIB $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SUMPSadrziOIB($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SUMPSadrziMB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SUMPSadrziMB $parameters
     * @return \StructType\SUMPSadrziMBResponse|bool
     */
    public function SUMPSadrziMB(\StructType\SUMPSadrziMB $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SUMPSadrziMB($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SUMPSadrziMBResponse|\StructType\SUMPSadrziOIBResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
