<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pretrazi ServiceType
 * @subpackage Services
 */
class Pretrazi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PretraziPLOCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziPLOCount $parameters
     * @return \StructType\PretraziPLOCountResponse|bool
     */
    public function PretraziPLOCount(\StructType\PretraziPLOCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziPLOCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziPLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziPLO $parameters
     * @return \StructType\PretraziPLOResponse|bool
     */
    public function PretraziPLO(\StructType\PretraziPLO $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziPLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziTijekOtpadaCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziTijekOtpadaCount $parameters
     * @return \StructType\PretraziTijekOtpadaCountResponse|bool
     */
    public function PretraziTijekOtpadaCount(\StructType\PretraziTijekOtpadaCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziTijekOtpadaCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziTijekOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziTijekOtpada $parameters
     * @return \StructType\PretraziTijekOtpadaResponse|bool
     */
    public function PretraziTijekOtpada(\StructType\PretraziTijekOtpada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziTijekOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziTijekOtpadaPCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziTijekOtpadaPCount $parameters
     * @return \StructType\PretraziTijekOtpadaPCountResponse|bool
     */
    public function PretraziTijekOtpadaPCount(\StructType\PretraziTijekOtpadaPCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziTijekOtpadaPCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziTijekOtpadaP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziTijekOtpadaP $parameters
     * @return \StructType\PretraziTijekOtpadaPResponse|bool
     */
    public function PretraziTijekOtpadaP(\StructType\PretraziTijekOtpadaP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziTijekOtpadaP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziOntoCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziOntoCount $parameters
     * @return \StructType\PretraziOntoCountResponse|bool
     */
    public function PretraziOntoCount(\StructType\PretraziOntoCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziOntoCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziOnto $parameters
     * @return \StructType\PretraziOntoResponse|bool
     */
    public function PretraziOnto(\StructType\PretraziOnto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziLokacijeCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziLokacijeCount $parameters
     * @return \StructType\PretraziLokacijeCountResponse|bool
     */
    public function PretraziLokacijeCount(\StructType\PretraziLokacijeCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziLokacijeCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PretraziLokacije
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PretraziLokacije $parameters
     * @return \StructType\PretraziLokacijeResponse|bool
     */
    public function PretraziLokacije(\StructType\PretraziLokacije $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PretraziLokacije($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PretraziLokacijeCountResponse|\StructType\PretraziLokacijeResponse|\StructType\PretraziOntoCountResponse|\StructType\PretraziOntoResponse|\StructType\PretraziPLOCountResponse|\StructType\PretraziPLOResponse|\StructType\PretraziTijekOtpadaCountResponse|\StructType\PretraziTijekOtpadaPCountResponse|\StructType\PretraziTijekOtpadaPResponse|\StructType\PretraziTijekOtpadaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
