<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Azuriraj ServiceType
 * @subpackage Services
 */
class Azuriraj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AzurirajPLO_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajPLO_v2 $parameters
     * @return \StructType\AzurirajPLO_v2Response|bool
     */
    public function AzurirajPLO_v2(\StructType\AzurirajPLO_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AzurirajPLO_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AzurirajTijekOtpada_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajTijekOtpada_v2 $parameters
     * @return \StructType\AzurirajTijekOtpada_v2Response|bool
     */
    public function AzurirajTijekOtpada_v2(\StructType\AzurirajTijekOtpada_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AzurirajTijekOtpada_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AzurirajTijekOtpadaP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajTijekOtpadaP $parameters
     * @return \StructType\AzurirajTijekOtpadaPResponse|bool
     */
    public function AzurirajTijekOtpadaP(\StructType\AzurirajTijekOtpadaP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AzurirajTijekOtpadaP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AzurirajOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajOnto $parameters
     * @return \StructType\AzurirajOntoResponse|bool
     */
    public function AzurirajOnto(\StructType\AzurirajOnto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AzurirajOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AzurirajLokaciju
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajLokaciju $parameters
     * @return \StructType\AzurirajLokacijuResponse|bool
     */
    public function AzurirajLokaciju(\StructType\AzurirajLokaciju $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AzurirajLokaciju($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AzurirajLokacijuResponse|\StructType\AzurirajOntoResponse|\StructType\AzurirajPLO_v2Response|\StructType\AzurirajTijekOtpadaPResponse|\StructType\AzurirajTijekOtpada_v2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
