<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VrstaOntoObveznika StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VrstaOntoObveznika
 * @subpackage Structs
 */
class VrstaOntoObveznika extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The VrstaOntoObveznikaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VrstaOntoObveznikaID;
    /**
     * Constructor method for VrstaOntoObveznika
     * @uses VrstaOntoObveznika::setAktivan()
     * @uses VrstaOntoObveznika::setNaziv()
     * @uses VrstaOntoObveznika::setVrstaOntoObveznikaID()
     * @param bool $aktivan
     * @param string $naziv
     * @param int $vrstaOntoObveznikaID
     */
    public function __construct($aktivan = null, $naziv = null, $vrstaOntoObveznikaID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNaziv($naziv)
            ->setVrstaOntoObveznikaID($vrstaOntoObveznikaID);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\VrstaOntoObveznika
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\VrstaOntoObveznika
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get VrstaOntoObveznikaID value
     * @return int|null
     */
    public function getVrstaOntoObveznikaID()
    {
        return $this->VrstaOntoObveznikaID;
    }
    /**
     * Set VrstaOntoObveznikaID value
     * @param int $vrstaOntoObveznikaID
     * @return \StructType\VrstaOntoObveznika
     */
    public function setVrstaOntoObveznikaID($vrstaOntoObveznikaID = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaOntoObveznikaID) && !(is_int($vrstaOntoObveznikaID) || ctype_digit($vrstaOntoObveznikaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vrstaOntoObveznikaID, true), gettype($vrstaOntoObveznikaID)), __LINE__);
        }
        $this->VrstaOntoObveznikaID = $vrstaOntoObveznikaID;
        return $this;
    }
}
