<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipZahtjeva StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TipZahtjeva
 * @subpackage Structs
 */
class TipZahtjeva extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Zahtjev
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfZahtjev
     */
    public $Zahtjev;
    /**
     * Constructor method for TipZahtjeva
     * @uses TipZahtjeva::setID()
     * @uses TipZahtjeva::setNaziv()
     * @uses TipZahtjeva::setZahtjev()
     * @param int $iD
     * @param string $naziv
     * @param \ArrayType\ArrayOfZahtjev $zahtjev
     */
    public function __construct($iD = null, $naziv = null, \ArrayType\ArrayOfZahtjev $zahtjev = null)
    {
        $this
            ->setID($iD)
            ->setNaziv($naziv)
            ->setZahtjev($zahtjev);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TipZahtjeva
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\TipZahtjeva
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Zahtjev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfZahtjev|null
     */
    public function getZahtjev()
    {
        return isset($this->Zahtjev) ? $this->Zahtjev : null;
    }
    /**
     * Set Zahtjev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfZahtjev $zahtjev
     * @return \StructType\TipZahtjeva
     */
    public function setZahtjev(\ArrayType\ArrayOfZahtjev $zahtjev = null)
    {
        if (is_null($zahtjev) || (is_array($zahtjev) && empty($zahtjev))) {
            unset($this->Zahtjev);
        } else {
            $this->Zahtjev = $zahtjev;
        }
        return $this;
    }
}
