<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipOtpada StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TipOtpada
 * @subpackage Structs
 */
class TipOtpada extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The TipOtpadaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipOtpadaID;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The PrateciLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The Sifra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sifra;
    /**
     * The TijekOtpadaPs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpadaP
     */
    public $TijekOtpadaPs;
    /**
     * The TijekOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpada
     */
    public $TijekOtpadas;
    /**
     * Constructor method for TipOtpada
     * @uses TipOtpada::setAktivan()
     * @uses TipOtpada::setNaziv()
     * @uses TipOtpada::setTipOtpadaID()
     * @uses TipOtpada::setDatumKreiranja()
     * @uses TipOtpada::setDatumPromjene()
     * @uses TipOtpada::setKreirao()
     * @uses TipOtpada::setPrateciLists()
     * @uses TipOtpada::setPromijenio()
     * @uses TipOtpada::setSifra()
     * @uses TipOtpada::setTijekOtpadaPs()
     * @uses TipOtpada::setTijekOtpadas()
     * @param bool $aktivan
     * @param string $naziv
     * @param int $tipOtpadaID
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @param string $promijenio
     * @param string $sifra
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     */
    public function __construct($aktivan = null, $naziv = null, $tipOtpadaID = null, $datumKreiranja = null, $datumPromjene = null, $kreirao = null, \ArrayType\ArrayOfPrateciList $prateciLists = null, $promijenio = null, $sifra = null, \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null, \ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNaziv($naziv)
            ->setTipOtpadaID($tipOtpadaID)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setPrateciLists($prateciLists)
            ->setPromijenio($promijenio)
            ->setSifra($sifra)
            ->setTijekOtpadaPs($tijekOtpadaPs)
            ->setTijekOtpadas($tijekOtpadas);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\TipOtpada
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\TipOtpada
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get TipOtpadaID value
     * @return int|null
     */
    public function getTipOtpadaID()
    {
        return $this->TipOtpadaID;
    }
    /**
     * Set TipOtpadaID value
     * @param int $tipOtpadaID
     * @return \StructType\TipOtpada
     */
    public function setTipOtpadaID($tipOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($tipOtpadaID) && !(is_int($tipOtpadaID) || ctype_digit($tipOtpadaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipOtpadaID, true), gettype($tipOtpadaID)), __LINE__);
        }
        $this->TipOtpadaID = $tipOtpadaID;
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\TipOtpada
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\TipOtpada
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\TipOtpada
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get PrateciLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists()
    {
        return isset($this->PrateciLists) ? $this->PrateciLists : null;
    }
    /**
     * Set PrateciLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @return \StructType\TipOtpada
     */
    public function setPrateciLists(\ArrayType\ArrayOfPrateciList $prateciLists = null)
    {
        if (is_null($prateciLists) || (is_array($prateciLists) && empty($prateciLists))) {
            unset($this->PrateciLists);
        } else {
            $this->PrateciLists = $prateciLists;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\TipOtpada
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get Sifra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifra()
    {
        return isset($this->Sifra) ? $this->Sifra : null;
    }
    /**
     * Set Sifra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifra
     * @return \StructType\TipOtpada
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        if (is_null($sifra) || (is_array($sifra) && empty($sifra))) {
            unset($this->Sifra);
        } else {
            $this->Sifra = $sifra;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaPs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpadaP|null
     */
    public function getTijekOtpadaPs()
    {
        return isset($this->TijekOtpadaPs) ? $this->TijekOtpadaPs : null;
    }
    /**
     * Set TijekOtpadaPs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @return \StructType\TipOtpada
     */
    public function setTijekOtpadaPs(\ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null)
    {
        if (is_null($tijekOtpadaPs) || (is_array($tijekOtpadaPs) && empty($tijekOtpadaPs))) {
            unset($this->TijekOtpadaPs);
        } else {
            $this->TijekOtpadaPs = $tijekOtpadaPs;
        }
        return $this;
    }
    /**
     * Get TijekOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpada|null
     */
    public function getTijekOtpadas()
    {
        return isset($this->TijekOtpadas) ? $this->TijekOtpadas : null;
    }
    /**
     * Set TijekOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @return \StructType\TipOtpada
     */
    public function setTijekOtpadas(\ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null)
    {
        if (is_null($tijekOtpadas) || (is_array($tijekOtpadas) && empty($tijekOtpadas))) {
            unset($this->TijekOtpadas);
        } else {
            $this->TijekOtpadas = $tijekOtpadas;
        }
        return $this;
    }
}
