<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PLPravilnikResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PLPravilnikResult
 * @subpackage Structs
 */
class PLPravilnikResult extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Opis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * The PLPravilnikID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PLPravilnikID;
    /**
     * Constructor method for PLPravilnikResult
     * @uses PLPravilnikResult::setAktivan()
     * @uses PLPravilnikResult::setNaziv()
     * @uses PLPravilnikResult::setOpis()
     * @uses PLPravilnikResult::setPLPravilnikID()
     * @param bool $aktivan
     * @param string $naziv
     * @param string $opis
     * @param int $pLPravilnikID
     */
    public function __construct($aktivan = null, $naziv = null, $opis = null, $pLPravilnikID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNaziv($naziv)
            ->setOpis($opis)
            ->setPLPravilnikID($pLPravilnikID);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\PLPravilnikResult
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\PLPravilnikResult
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\PLPravilnikResult
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opis, true), gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Get PLPravilnikID value
     * @return int|null
     */
    public function getPLPravilnikID()
    {
        return $this->PLPravilnikID;
    }
    /**
     * Set PLPravilnikID value
     * @param int $pLPravilnikID
     * @return \StructType\PLPravilnikResult
     */
    public function setPLPravilnikID($pLPravilnikID = null)
    {
        // validation for constraint: int
        if (!is_null($pLPravilnikID) && !(is_int($pLPravilnikID) || ctype_digit($pLPravilnikID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pLPravilnikID, true), gettype($pLPravilnikID)), __LINE__);
        }
        $this->PLPravilnikID = $pLPravilnikID;
        return $this;
    }
}
