<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PLBrojcanik StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PLBrojcanik
 * @subpackage Structs
 */
class PLBrojcanik extends AbstractStructBase
{
    /**
     * The Broj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Broj;
    /**
     * The ONTO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ONTO
     */
    public $ONTO;
    /**
     * The ONTOID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ONTOID;
    /**
     * The RowVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowVersion;
    /**
     * Constructor method for PLBrojcanik
     * @uses PLBrojcanik::setBroj()
     * @uses PLBrojcanik::setONTO()
     * @uses PLBrojcanik::setONTOID()
     * @uses PLBrojcanik::setRowVersion()
     * @param int $broj
     * @param \StructType\ONTO $oNTO
     * @param int $oNTOID
     * @param string $rowVersion
     */
    public function __construct($broj = null, \StructType\ONTO $oNTO = null, $oNTOID = null, $rowVersion = null)
    {
        $this
            ->setBroj($broj)
            ->setONTO($oNTO)
            ->setONTOID($oNTOID)
            ->setRowVersion($rowVersion);
    }
    /**
     * Get Broj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBroj()
    {
        return isset($this->Broj) ? $this->Broj : null;
    }
    /**
     * Set Broj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $broj
     * @return \StructType\PLBrojcanik
     */
    public function setBroj($broj = null)
    {
        // validation for constraint: int
        if (!is_null($broj) && !(is_int($broj) || ctype_digit($broj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($broj, true), gettype($broj)), __LINE__);
        }
        if (is_null($broj) || (is_array($broj) && empty($broj))) {
            unset($this->Broj);
        } else {
            $this->Broj = $broj;
        }
        return $this;
    }
    /**
     * Get ONTO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ONTO|null
     */
    public function getONTO()
    {
        return isset($this->ONTO) ? $this->ONTO : null;
    }
    /**
     * Set ONTO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ONTO $oNTO
     * @return \StructType\PLBrojcanik
     */
    public function setONTO(\StructType\ONTO $oNTO = null)
    {
        if (is_null($oNTO) || (is_array($oNTO) && empty($oNTO))) {
            unset($this->ONTO);
        } else {
            $this->ONTO = $oNTO;
        }
        return $this;
    }
    /**
     * Get ONTOID value
     * @return int|null
     */
    public function getONTOID()
    {
        return $this->ONTOID;
    }
    /**
     * Set ONTOID value
     * @param int $oNTOID
     * @return \StructType\PLBrojcanik
     */
    public function setONTOID($oNTOID = null)
    {
        // validation for constraint: int
        if (!is_null($oNTOID) && !(is_int($oNTOID) || ctype_digit($oNTOID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oNTOID, true), gettype($oNTOID)), __LINE__);
        }
        $this->ONTOID = $oNTOID;
        return $this;
    }
    /**
     * Get RowVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowVersion()
    {
        return isset($this->RowVersion) ? $this->RowVersion : null;
    }
    /**
     * Set RowVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowVersion
     * @return \StructType\PLBrojcanik
     */
    public function setRowVersion($rowVersion = null)
    {
        // validation for constraint: string
        if (!is_null($rowVersion) && !is_string($rowVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowVersion, true), gettype($rowVersion)), __LINE__);
        }
        if (is_null($rowVersion) || (is_array($rowVersion) && empty($rowVersion))) {
            unset($this->RowVersion);
        } else {
            $this->RowVersion = $rowVersion;
        }
        return $this;
    }
}
