<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OznakaPK StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OznakaPK
 * @subpackage Structs
 */
class OznakaPK extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The OznakaPKID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OznakaPKID;
    /**
     * The OznakaPosebneKategorijes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOznakaPosebneKategorije
     */
    public $OznakaPosebneKategorijes;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The Sifra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sifra;
    /**
     * The VrijediDo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VrijediDo;
    /**
     * The VrijediOd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VrijediOd;
    /**
     * Constructor method for OznakaPK
     * @uses OznakaPK::setDatumKreiranja()
     * @uses OznakaPK::setDatumPromjene()
     * @uses OznakaPK::setKreirao()
     * @uses OznakaPK::setNaziv()
     * @uses OznakaPK::setOznakaPKID()
     * @uses OznakaPK::setOznakaPosebneKategorijes()
     * @uses OznakaPK::setPromijenio()
     * @uses OznakaPK::setSifra()
     * @uses OznakaPK::setVrijediDo()
     * @uses OznakaPK::setVrijediOd()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param string $naziv
     * @param int $oznakaPKID
     * @param \ArrayType\ArrayOfOznakaPosebneKategorije $oznakaPosebneKategorijes
     * @param string $promijenio
     * @param string $sifra
     * @param string $vrijediDo
     * @param string $vrijediOd
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, $kreirao = null, $naziv = null, $oznakaPKID = null, \ArrayType\ArrayOfOznakaPosebneKategorije $oznakaPosebneKategorijes = null, $promijenio = null, $sifra = null, $vrijediDo = null, $vrijediOd = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setNaziv($naziv)
            ->setOznakaPKID($oznakaPKID)
            ->setOznakaPosebneKategorijes($oznakaPosebneKategorijes)
            ->setPromijenio($promijenio)
            ->setSifra($sifra)
            ->setVrijediDo($vrijediDo)
            ->setVrijediOd($vrijediOd);
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\OznakaPK
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\OznakaPK
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\OznakaPK
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\OznakaPK
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get OznakaPKID value
     * @return int|null
     */
    public function getOznakaPKID()
    {
        return $this->OznakaPKID;
    }
    /**
     * Set OznakaPKID value
     * @param int $oznakaPKID
     * @return \StructType\OznakaPK
     */
    public function setOznakaPKID($oznakaPKID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaPKID) && !(is_int($oznakaPKID) || ctype_digit($oznakaPKID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oznakaPKID, true), gettype($oznakaPKID)), __LINE__);
        }
        $this->OznakaPKID = $oznakaPKID;
        return $this;
    }
    /**
     * Get OznakaPosebneKategorijes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOznakaPosebneKategorije|null
     */
    public function getOznakaPosebneKategorijes()
    {
        return isset($this->OznakaPosebneKategorijes) ? $this->OznakaPosebneKategorijes : null;
    }
    /**
     * Set OznakaPosebneKategorijes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOznakaPosebneKategorije $oznakaPosebneKategorijes
     * @return \StructType\OznakaPK
     */
    public function setOznakaPosebneKategorijes(\ArrayType\ArrayOfOznakaPosebneKategorije $oznakaPosebneKategorijes = null)
    {
        if (is_null($oznakaPosebneKategorijes) || (is_array($oznakaPosebneKategorijes) && empty($oznakaPosebneKategorijes))) {
            unset($this->OznakaPosebneKategorijes);
        } else {
            $this->OznakaPosebneKategorijes = $oznakaPosebneKategorijes;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\OznakaPK
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get Sifra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifra()
    {
        return isset($this->Sifra) ? $this->Sifra : null;
    }
    /**
     * Set Sifra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifra
     * @return \StructType\OznakaPK
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        if (is_null($sifra) || (is_array($sifra) && empty($sifra))) {
            unset($this->Sifra);
        } else {
            $this->Sifra = $sifra;
        }
        return $this;
    }
    /**
     * Get VrijediDo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVrijediDo()
    {
        return isset($this->VrijediDo) ? $this->VrijediDo : null;
    }
    /**
     * Set VrijediDo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vrijediDo
     * @return \StructType\OznakaPK
     */
    public function setVrijediDo($vrijediDo = null)
    {
        // validation for constraint: string
        if (!is_null($vrijediDo) && !is_string($vrijediDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijediDo, true), gettype($vrijediDo)), __LINE__);
        }
        if (is_null($vrijediDo) || (is_array($vrijediDo) && empty($vrijediDo))) {
            unset($this->VrijediDo);
        } else {
            $this->VrijediDo = $vrijediDo;
        }
        return $this;
    }
    /**
     * Get VrijediOd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVrijediOd()
    {
        return isset($this->VrijediOd) ? $this->VrijediOd : null;
    }
    /**
     * Set VrijediOd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vrijediOd
     * @return \StructType\OznakaPK
     */
    public function setVrijediOd($vrijediOd = null)
    {
        // validation for constraint: string
        if (!is_null($vrijediOd) && !is_string($vrijediOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijediOd, true), gettype($vrijediOd)), __LINE__);
        }
        if (is_null($vrijediOd) || (is_array($vrijediOd) && empty($vrijediOd))) {
            unset($this->VrijediOd);
        } else {
            $this->VrijediOd = $vrijediOd;
        }
        return $this;
    }
}
