<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Naselje StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Naselje
 * @subpackage Structs
 */
class Naselje extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The LokacijaProdavateljaOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLokacijaProdavateljaOtpada
     */
    public $LokacijaProdavateljaOtpadas;
    /**
     * The Lokacijas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLokacija
     */
    public $Lokacijas;
    /**
     * The MB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MB;
    /**
     * The NaseljeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NaseljeID;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The ObjectID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ObjectID;
    /**
     * The OpGrad
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpGrad
     */
    public $OpGrad;
    /**
     * The OpcinaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OpcinaID;
    /**
     * The OznakaOpcine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OznakaOpcine;
    /**
     * The OznakaZupanije
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OznakaZupanije;
    /**
     * The PorijekloKomunalnogOtpadaOntoPs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP
     */
    public $PorijekloKomunalnogOtpadaOntoPs;
    /**
     * The PorijekloKomunalnogOtpadaOntoes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto
     */
    public $PorijekloKomunalnogOtpadaOntoes;
    /**
     * The PorijekloKomunalnogOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPorijekloKomunalnogOtpada
     */
    public $PorijekloKomunalnogOtpadas;
    /**
     * The PravnaOsobaLokacijaNaseljes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje
     */
    public $PravnaOsobaLokacijaNaseljes;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The SUMPID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SUMPID;
    /**
     * The SUMPVrijemeIzmjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SUMPVrijemeIzmjene;
    /**
     * The SUMPVrijemeUpisa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SUMPVrijemeUpisa;
    /**
     * The SUMPZadnjiKorisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPZadnjiKorisnik;
    /**
     * The TijekOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpada
     */
    public $TijekOtpadas;
    /**
     * The UlicaTrgs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUlicaTrg
     */
    public $UlicaTrgs;
    /**
     * The Zupanija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Zupanija
     */
    public $Zupanija;
    /**
     * The ZupanijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ZupanijaID;
    /**
     * Constructor method for Naselje
     * @uses Naselje::setAktivan()
     * @uses Naselje::setDatumKreiranja()
     * @uses Naselje::setDatumPromjene()
     * @uses Naselje::setKreirao()
     * @uses Naselje::setLokacijaProdavateljaOtpadas()
     * @uses Naselje::setLokacijas()
     * @uses Naselje::setMB()
     * @uses Naselje::setNaseljeID()
     * @uses Naselje::setNaziv()
     * @uses Naselje::setObjectID()
     * @uses Naselje::setOpGrad()
     * @uses Naselje::setOpcinaID()
     * @uses Naselje::setOznakaOpcine()
     * @uses Naselje::setOznakaZupanije()
     * @uses Naselje::setPorijekloKomunalnogOtpadaOntoPs()
     * @uses Naselje::setPorijekloKomunalnogOtpadaOntoes()
     * @uses Naselje::setPorijekloKomunalnogOtpadas()
     * @uses Naselje::setPravnaOsobaLokacijaNaseljes()
     * @uses Naselje::setPromijenio()
     * @uses Naselje::setSUMPID()
     * @uses Naselje::setSUMPVrijemeIzmjene()
     * @uses Naselje::setSUMPVrijemeUpisa()
     * @uses Naselje::setSUMPZadnjiKorisnik()
     * @uses Naselje::setTijekOtpadas()
     * @uses Naselje::setUlicaTrgs()
     * @uses Naselje::setZupanija()
     * @uses Naselje::setZupanijaID()
     * @param bool $aktivan
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param \ArrayType\ArrayOfLokacijaProdavateljaOtpada $lokacijaProdavateljaOtpadas
     * @param \ArrayType\ArrayOfLokacija $lokacijas
     * @param string $mB
     * @param int $naseljeID
     * @param string $naziv
     * @param int $objectID
     * @param \StructType\OpGrad $opGrad
     * @param int $opcinaID
     * @param string $oznakaOpcine
     * @param string $oznakaZupanije
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas
     * @param \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes
     * @param string $promijenio
     * @param int $sUMPID
     * @param string $sUMPVrijemeIzmjene
     * @param string $sUMPVrijemeUpisa
     * @param string $sUMPZadnjiKorisnik
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @param \ArrayType\ArrayOfUlicaTrg $ulicaTrgs
     * @param \StructType\Zupanija $zupanija
     * @param int $zupanijaID
     */
    public function __construct($aktivan = null, $datumKreiranja = null, $datumPromjene = null, $kreirao = null, \ArrayType\ArrayOfLokacijaProdavateljaOtpada $lokacijaProdavateljaOtpadas = null, \ArrayType\ArrayOfLokacija $lokacijas = null, $mB = null, $naseljeID = null, $naziv = null, $objectID = null, \StructType\OpGrad $opGrad = null, $opcinaID = null, $oznakaOpcine = null, $oznakaZupanije = null, \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs = null, \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes = null, \ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas = null, \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes = null, $promijenio = null, $sUMPID = null, $sUMPVrijemeIzmjene = null, $sUMPVrijemeUpisa = null, $sUMPZadnjiKorisnik = null, \ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null, \ArrayType\ArrayOfUlicaTrg $ulicaTrgs = null, \StructType\Zupanija $zupanija = null, $zupanijaID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setLokacijaProdavateljaOtpadas($lokacijaProdavateljaOtpadas)
            ->setLokacijas($lokacijas)
            ->setMB($mB)
            ->setNaseljeID($naseljeID)
            ->setNaziv($naziv)
            ->setObjectID($objectID)
            ->setOpGrad($opGrad)
            ->setOpcinaID($opcinaID)
            ->setOznakaOpcine($oznakaOpcine)
            ->setOznakaZupanije($oznakaZupanije)
            ->setPorijekloKomunalnogOtpadaOntoPs($porijekloKomunalnogOtpadaOntoPs)
            ->setPorijekloKomunalnogOtpadaOntoes($porijekloKomunalnogOtpadaOntoes)
            ->setPorijekloKomunalnogOtpadas($porijekloKomunalnogOtpadas)
            ->setPravnaOsobaLokacijaNaseljes($pravnaOsobaLokacijaNaseljes)
            ->setPromijenio($promijenio)
            ->setSUMPID($sUMPID)
            ->setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene)
            ->setSUMPVrijemeUpisa($sUMPVrijemeUpisa)
            ->setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik)
            ->setTijekOtpadas($tijekOtpadas)
            ->setUlicaTrgs($ulicaTrgs)
            ->setZupanija($zupanija)
            ->setZupanijaID($zupanijaID);
    }
    /**
     * Get Aktivan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAktivan()
    {
        return isset($this->Aktivan) ? $this->Aktivan : null;
    }
    /**
     * Set Aktivan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aktivan
     * @return \StructType\Naselje
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        if (is_null($aktivan) || (is_array($aktivan) && empty($aktivan))) {
            unset($this->Aktivan);
        } else {
            $this->Aktivan = $aktivan;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\Naselje
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\Naselje
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\Naselje
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get LokacijaProdavateljaOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLokacijaProdavateljaOtpada|null
     */
    public function getLokacijaProdavateljaOtpadas()
    {
        return isset($this->LokacijaProdavateljaOtpadas) ? $this->LokacijaProdavateljaOtpadas : null;
    }
    /**
     * Set LokacijaProdavateljaOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLokacijaProdavateljaOtpada $lokacijaProdavateljaOtpadas
     * @return \StructType\Naselje
     */
    public function setLokacijaProdavateljaOtpadas(\ArrayType\ArrayOfLokacijaProdavateljaOtpada $lokacijaProdavateljaOtpadas = null)
    {
        if (is_null($lokacijaProdavateljaOtpadas) || (is_array($lokacijaProdavateljaOtpadas) && empty($lokacijaProdavateljaOtpadas))) {
            unset($this->LokacijaProdavateljaOtpadas);
        } else {
            $this->LokacijaProdavateljaOtpadas = $lokacijaProdavateljaOtpadas;
        }
        return $this;
    }
    /**
     * Get Lokacijas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLokacija|null
     */
    public function getLokacijas()
    {
        return isset($this->Lokacijas) ? $this->Lokacijas : null;
    }
    /**
     * Set Lokacijas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLokacija $lokacijas
     * @return \StructType\Naselje
     */
    public function setLokacijas(\ArrayType\ArrayOfLokacija $lokacijas = null)
    {
        if (is_null($lokacijas) || (is_array($lokacijas) && empty($lokacijas))) {
            unset($this->Lokacijas);
        } else {
            $this->Lokacijas = $lokacijas;
        }
        return $this;
    }
    /**
     * Get MB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMB()
    {
        return isset($this->MB) ? $this->MB : null;
    }
    /**
     * Set MB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mB
     * @return \StructType\Naselje
     */
    public function setMB($mB = null)
    {
        // validation for constraint: string
        if (!is_null($mB) && !is_string($mB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mB, true), gettype($mB)), __LINE__);
        }
        if (is_null($mB) || (is_array($mB) && empty($mB))) {
            unset($this->MB);
        } else {
            $this->MB = $mB;
        }
        return $this;
    }
    /**
     * Get NaseljeID value
     * @return int|null
     */
    public function getNaseljeID()
    {
        return $this->NaseljeID;
    }
    /**
     * Set NaseljeID value
     * @param int $naseljeID
     * @return \StructType\Naselje
     */
    public function setNaseljeID($naseljeID = null)
    {
        // validation for constraint: int
        if (!is_null($naseljeID) && !(is_int($naseljeID) || ctype_digit($naseljeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($naseljeID, true), gettype($naseljeID)), __LINE__);
        }
        $this->NaseljeID = $naseljeID;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\Naselje
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get ObjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getObjectID()
    {
        return isset($this->ObjectID) ? $this->ObjectID : null;
    }
    /**
     * Set ObjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $objectID
     * @return \StructType\Naselje
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        if (is_null($objectID) || (is_array($objectID) && empty($objectID))) {
            unset($this->ObjectID);
        } else {
            $this->ObjectID = $objectID;
        }
        return $this;
    }
    /**
     * Get OpGrad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpGrad|null
     */
    public function getOpGrad()
    {
        return isset($this->OpGrad) ? $this->OpGrad : null;
    }
    /**
     * Set OpGrad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OpGrad $opGrad
     * @return \StructType\Naselje
     */
    public function setOpGrad(\StructType\OpGrad $opGrad = null)
    {
        if (is_null($opGrad) || (is_array($opGrad) && empty($opGrad))) {
            unset($this->OpGrad);
        } else {
            $this->OpGrad = $opGrad;
        }
        return $this;
    }
    /**
     * Get OpcinaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOpcinaID()
    {
        return isset($this->OpcinaID) ? $this->OpcinaID : null;
    }
    /**
     * Set OpcinaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $opcinaID
     * @return \StructType\Naselje
     */
    public function setOpcinaID($opcinaID = null)
    {
        // validation for constraint: int
        if (!is_null($opcinaID) && !(is_int($opcinaID) || ctype_digit($opcinaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($opcinaID, true), gettype($opcinaID)), __LINE__);
        }
        if (is_null($opcinaID) || (is_array($opcinaID) && empty($opcinaID))) {
            unset($this->OpcinaID);
        } else {
            $this->OpcinaID = $opcinaID;
        }
        return $this;
    }
    /**
     * Get OznakaOpcine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznakaOpcine()
    {
        return isset($this->OznakaOpcine) ? $this->OznakaOpcine : null;
    }
    /**
     * Set OznakaOpcine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznakaOpcine
     * @return \StructType\Naselje
     */
    public function setOznakaOpcine($oznakaOpcine = null)
    {
        // validation for constraint: string
        if (!is_null($oznakaOpcine) && !is_string($oznakaOpcine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznakaOpcine, true), gettype($oznakaOpcine)), __LINE__);
        }
        if (is_null($oznakaOpcine) || (is_array($oznakaOpcine) && empty($oznakaOpcine))) {
            unset($this->OznakaOpcine);
        } else {
            $this->OznakaOpcine = $oznakaOpcine;
        }
        return $this;
    }
    /**
     * Get OznakaZupanije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznakaZupanije()
    {
        return isset($this->OznakaZupanije) ? $this->OznakaZupanije : null;
    }
    /**
     * Set OznakaZupanije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznakaZupanije
     * @return \StructType\Naselje
     */
    public function setOznakaZupanije($oznakaZupanije = null)
    {
        // validation for constraint: string
        if (!is_null($oznakaZupanije) && !is_string($oznakaZupanije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznakaZupanije, true), gettype($oznakaZupanije)), __LINE__);
        }
        if (is_null($oznakaZupanije) || (is_array($oznakaZupanije) && empty($oznakaZupanije))) {
            unset($this->OznakaZupanije);
        } else {
            $this->OznakaZupanije = $oznakaZupanije;
        }
        return $this;
    }
    /**
     * Get PorijekloKomunalnogOtpadaOntoPs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP|null
     */
    public function getPorijekloKomunalnogOtpadaOntoPs()
    {
        return isset($this->PorijekloKomunalnogOtpadaOntoPs) ? $this->PorijekloKomunalnogOtpadaOntoPs : null;
    }
    /**
     * Set PorijekloKomunalnogOtpadaOntoPs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs
     * @return \StructType\Naselje
     */
    public function setPorijekloKomunalnogOtpadaOntoPs(\ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs = null)
    {
        if (is_null($porijekloKomunalnogOtpadaOntoPs) || (is_array($porijekloKomunalnogOtpadaOntoPs) && empty($porijekloKomunalnogOtpadaOntoPs))) {
            unset($this->PorijekloKomunalnogOtpadaOntoPs);
        } else {
            $this->PorijekloKomunalnogOtpadaOntoPs = $porijekloKomunalnogOtpadaOntoPs;
        }
        return $this;
    }
    /**
     * Get PorijekloKomunalnogOtpadaOntoes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto|null
     */
    public function getPorijekloKomunalnogOtpadaOntoes()
    {
        return isset($this->PorijekloKomunalnogOtpadaOntoes) ? $this->PorijekloKomunalnogOtpadaOntoes : null;
    }
    /**
     * Set PorijekloKomunalnogOtpadaOntoes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes
     * @return \StructType\Naselje
     */
    public function setPorijekloKomunalnogOtpadaOntoes(\ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes = null)
    {
        if (is_null($porijekloKomunalnogOtpadaOntoes) || (is_array($porijekloKomunalnogOtpadaOntoes) && empty($porijekloKomunalnogOtpadaOntoes))) {
            unset($this->PorijekloKomunalnogOtpadaOntoes);
        } else {
            $this->PorijekloKomunalnogOtpadaOntoes = $porijekloKomunalnogOtpadaOntoes;
        }
        return $this;
    }
    /**
     * Get PorijekloKomunalnogOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPorijekloKomunalnogOtpada|null
     */
    public function getPorijekloKomunalnogOtpadas()
    {
        return isset($this->PorijekloKomunalnogOtpadas) ? $this->PorijekloKomunalnogOtpadas : null;
    }
    /**
     * Set PorijekloKomunalnogOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas
     * @return \StructType\Naselje
     */
    public function setPorijekloKomunalnogOtpadas(\ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas = null)
    {
        if (is_null($porijekloKomunalnogOtpadas) || (is_array($porijekloKomunalnogOtpadas) && empty($porijekloKomunalnogOtpadas))) {
            unset($this->PorijekloKomunalnogOtpadas);
        } else {
            $this->PorijekloKomunalnogOtpadas = $porijekloKomunalnogOtpadas;
        }
        return $this;
    }
    /**
     * Get PravnaOsobaLokacijaNaseljes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje|null
     */
    public function getPravnaOsobaLokacijaNaseljes()
    {
        return isset($this->PravnaOsobaLokacijaNaseljes) ? $this->PravnaOsobaLokacijaNaseljes : null;
    }
    /**
     * Set PravnaOsobaLokacijaNaseljes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes
     * @return \StructType\Naselje
     */
    public function setPravnaOsobaLokacijaNaseljes(\ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes = null)
    {
        if (is_null($pravnaOsobaLokacijaNaseljes) || (is_array($pravnaOsobaLokacijaNaseljes) && empty($pravnaOsobaLokacijaNaseljes))) {
            unset($this->PravnaOsobaLokacijaNaseljes);
        } else {
            $this->PravnaOsobaLokacijaNaseljes = $pravnaOsobaLokacijaNaseljes;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\Naselje
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get SUMPID value
     * @return int|null
     */
    public function getSUMPID()
    {
        return $this->SUMPID;
    }
    /**
     * Set SUMPID value
     * @param int $sUMPID
     * @return \StructType\Naselje
     */
    public function setSUMPID($sUMPID = null)
    {
        // validation for constraint: int
        if (!is_null($sUMPID) && !(is_int($sUMPID) || ctype_digit($sUMPID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sUMPID, true), gettype($sUMPID)), __LINE__);
        }
        $this->SUMPID = $sUMPID;
        return $this;
    }
    /**
     * Get SUMPVrijemeIzmjene value
     * @return string|null
     */
    public function getSUMPVrijemeIzmjene()
    {
        return $this->SUMPVrijemeIzmjene;
    }
    /**
     * Set SUMPVrijemeIzmjene value
     * @param string $sUMPVrijemeIzmjene
     * @return \StructType\Naselje
     */
    public function setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeIzmjene) && !is_string($sUMPVrijemeIzmjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeIzmjene, true), gettype($sUMPVrijemeIzmjene)), __LINE__);
        }
        $this->SUMPVrijemeIzmjene = $sUMPVrijemeIzmjene;
        return $this;
    }
    /**
     * Get SUMPVrijemeUpisa value
     * @return string|null
     */
    public function getSUMPVrijemeUpisa()
    {
        return $this->SUMPVrijemeUpisa;
    }
    /**
     * Set SUMPVrijemeUpisa value
     * @param string $sUMPVrijemeUpisa
     * @return \StructType\Naselje
     */
    public function setSUMPVrijemeUpisa($sUMPVrijemeUpisa = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeUpisa) && !is_string($sUMPVrijemeUpisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeUpisa, true), gettype($sUMPVrijemeUpisa)), __LINE__);
        }
        $this->SUMPVrijemeUpisa = $sUMPVrijemeUpisa;
        return $this;
    }
    /**
     * Get SUMPZadnjiKorisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPZadnjiKorisnik()
    {
        return isset($this->SUMPZadnjiKorisnik) ? $this->SUMPZadnjiKorisnik : null;
    }
    /**
     * Set SUMPZadnjiKorisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPZadnjiKorisnik
     * @return \StructType\Naselje
     */
    public function setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPZadnjiKorisnik) && !is_string($sUMPZadnjiKorisnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPZadnjiKorisnik, true), gettype($sUMPZadnjiKorisnik)), __LINE__);
        }
        if (is_null($sUMPZadnjiKorisnik) || (is_array($sUMPZadnjiKorisnik) && empty($sUMPZadnjiKorisnik))) {
            unset($this->SUMPZadnjiKorisnik);
        } else {
            $this->SUMPZadnjiKorisnik = $sUMPZadnjiKorisnik;
        }
        return $this;
    }
    /**
     * Get TijekOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpada|null
     */
    public function getTijekOtpadas()
    {
        return isset($this->TijekOtpadas) ? $this->TijekOtpadas : null;
    }
    /**
     * Set TijekOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @return \StructType\Naselje
     */
    public function setTijekOtpadas(\ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null)
    {
        if (is_null($tijekOtpadas) || (is_array($tijekOtpadas) && empty($tijekOtpadas))) {
            unset($this->TijekOtpadas);
        } else {
            $this->TijekOtpadas = $tijekOtpadas;
        }
        return $this;
    }
    /**
     * Get UlicaTrgs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUlicaTrg|null
     */
    public function getUlicaTrgs()
    {
        return isset($this->UlicaTrgs) ? $this->UlicaTrgs : null;
    }
    /**
     * Set UlicaTrgs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUlicaTrg $ulicaTrgs
     * @return \StructType\Naselje
     */
    public function setUlicaTrgs(\ArrayType\ArrayOfUlicaTrg $ulicaTrgs = null)
    {
        if (is_null($ulicaTrgs) || (is_array($ulicaTrgs) && empty($ulicaTrgs))) {
            unset($this->UlicaTrgs);
        } else {
            $this->UlicaTrgs = $ulicaTrgs;
        }
        return $this;
    }
    /**
     * Get Zupanija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Zupanija|null
     */
    public function getZupanija()
    {
        return isset($this->Zupanija) ? $this->Zupanija : null;
    }
    /**
     * Set Zupanija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Zupanija $zupanija
     * @return \StructType\Naselje
     */
    public function setZupanija(\StructType\Zupanija $zupanija = null)
    {
        if (is_null($zupanija) || (is_array($zupanija) && empty($zupanija))) {
            unset($this->Zupanija);
        } else {
            $this->Zupanija = $zupanija;
        }
        return $this;
    }
    /**
     * Get ZupanijaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getZupanijaID()
    {
        return isset($this->ZupanijaID) ? $this->ZupanijaID : null;
    }
    /**
     * Set ZupanijaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $zupanijaID
     * @return \StructType\Naselje
     */
    public function setZupanijaID($zupanijaID = null)
    {
        // validation for constraint: int
        if (!is_null($zupanijaID) && !(is_int($zupanijaID) || ctype_digit($zupanijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zupanijaID, true), gettype($zupanijaID)), __LINE__);
        }
        if (is_null($zupanijaID) || (is_array($zupanijaID) && empty($zupanijaID))) {
            unset($this->ZupanijaID);
        } else {
            $this->ZupanijaID = $zupanijaID;
        }
        return $this;
    }
}
