<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NKD StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NKD
 * @subpackage Structs
 */
class NKD extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Oznaka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Oznaka;
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The GodinaVazenjaPropisa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GodinaVazenjaPropisa;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The NKDID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NKDID;
    /**
     * The PomocniPodaciUnosas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPomocniPodaciUnosa
     */
    public $PomocniPodaciUnosas;
    /**
     * The PrateciLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The SUMPID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SUMPID;
    /**
     * The SUMPVrijemeIzmjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPVrijemeIzmjene;
    /**
     * The SUMPVrijemeUpisa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPVrijemeUpisa;
    /**
     * The SUMPZadnjiKorisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPZadnjiKorisnik;
    /**
     * Constructor method for NKD
     * @uses NKD::setID()
     * @uses NKD::setNaziv()
     * @uses NKD::setOznaka()
     * @uses NKD::setAktivan()
     * @uses NKD::setDatumKreiranja()
     * @uses NKD::setDatumPromjene()
     * @uses NKD::setGodinaVazenjaPropisa()
     * @uses NKD::setKreirao()
     * @uses NKD::setNKDID()
     * @uses NKD::setPomocniPodaciUnosas()
     * @uses NKD::setPrateciLists()
     * @uses NKD::setPromijenio()
     * @uses NKD::setSUMPID()
     * @uses NKD::setSUMPVrijemeIzmjene()
     * @uses NKD::setSUMPVrijemeUpisa()
     * @uses NKD::setSUMPZadnjiKorisnik()
     * @param int $iD
     * @param string $naziv
     * @param string $oznaka
     * @param bool $aktivan
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param int $godinaVazenjaPropisa
     * @param string $kreirao
     * @param int $nKDID
     * @param \ArrayType\ArrayOfPomocniPodaciUnosa $pomocniPodaciUnosas
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @param string $promijenio
     * @param int $sUMPID
     * @param string $sUMPVrijemeIzmjene
     * @param string $sUMPVrijemeUpisa
     * @param string $sUMPZadnjiKorisnik
     */
    public function __construct($iD = null, $naziv = null, $oznaka = null, $aktivan = null, $datumKreiranja = null, $datumPromjene = null, $godinaVazenjaPropisa = null, $kreirao = null, $nKDID = null, \ArrayType\ArrayOfPomocniPodaciUnosa $pomocniPodaciUnosas = null, \ArrayType\ArrayOfPrateciList $prateciLists = null, $promijenio = null, $sUMPID = null, $sUMPVrijemeIzmjene = null, $sUMPVrijemeUpisa = null, $sUMPZadnjiKorisnik = null)
    {
        $this
            ->setID($iD)
            ->setNaziv($naziv)
            ->setOznaka($oznaka)
            ->setAktivan($aktivan)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setGodinaVazenjaPropisa($godinaVazenjaPropisa)
            ->setKreirao($kreirao)
            ->setNKDID($nKDID)
            ->setPomocniPodaciUnosas($pomocniPodaciUnosas)
            ->setPrateciLists($prateciLists)
            ->setPromijenio($promijenio)
            ->setSUMPID($sUMPID)
            ->setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene)
            ->setSUMPVrijemeUpisa($sUMPVrijemeUpisa)
            ->setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\NKD
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\NKD
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Oznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznaka()
    {
        return isset($this->Oznaka) ? $this->Oznaka : null;
    }
    /**
     * Set Oznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznaka
     * @return \StructType\NKD
     */
    public function setOznaka($oznaka = null)
    {
        // validation for constraint: string
        if (!is_null($oznaka) && !is_string($oznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznaka, true), gettype($oznaka)), __LINE__);
        }
        if (is_null($oznaka) || (is_array($oznaka) && empty($oznaka))) {
            unset($this->Oznaka);
        } else {
            $this->Oznaka = $oznaka;
        }
        return $this;
    }
    /**
     * Get Aktivan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAktivan()
    {
        return isset($this->Aktivan) ? $this->Aktivan : null;
    }
    /**
     * Set Aktivan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aktivan
     * @return \StructType\NKD
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        if (is_null($aktivan) || (is_array($aktivan) && empty($aktivan))) {
            unset($this->Aktivan);
        } else {
            $this->Aktivan = $aktivan;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\NKD
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\NKD
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get GodinaVazenjaPropisa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGodinaVazenjaPropisa()
    {
        return isset($this->GodinaVazenjaPropisa) ? $this->GodinaVazenjaPropisa : null;
    }
    /**
     * Set GodinaVazenjaPropisa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $godinaVazenjaPropisa
     * @return \StructType\NKD
     */
    public function setGodinaVazenjaPropisa($godinaVazenjaPropisa = null)
    {
        // validation for constraint: int
        if (!is_null($godinaVazenjaPropisa) && !(is_int($godinaVazenjaPropisa) || ctype_digit($godinaVazenjaPropisa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($godinaVazenjaPropisa, true), gettype($godinaVazenjaPropisa)), __LINE__);
        }
        if (is_null($godinaVazenjaPropisa) || (is_array($godinaVazenjaPropisa) && empty($godinaVazenjaPropisa))) {
            unset($this->GodinaVazenjaPropisa);
        } else {
            $this->GodinaVazenjaPropisa = $godinaVazenjaPropisa;
        }
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\NKD
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get NKDID value
     * @return int|null
     */
    public function getNKDID()
    {
        return $this->NKDID;
    }
    /**
     * Set NKDID value
     * @param int $nKDID
     * @return \StructType\NKD
     */
    public function setNKDID($nKDID = null)
    {
        // validation for constraint: int
        if (!is_null($nKDID) && !(is_int($nKDID) || ctype_digit($nKDID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nKDID, true), gettype($nKDID)), __LINE__);
        }
        $this->NKDID = $nKDID;
        return $this;
    }
    /**
     * Get PomocniPodaciUnosas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPomocniPodaciUnosa|null
     */
    public function getPomocniPodaciUnosas()
    {
        return isset($this->PomocniPodaciUnosas) ? $this->PomocniPodaciUnosas : null;
    }
    /**
     * Set PomocniPodaciUnosas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPomocniPodaciUnosa $pomocniPodaciUnosas
     * @return \StructType\NKD
     */
    public function setPomocniPodaciUnosas(\ArrayType\ArrayOfPomocniPodaciUnosa $pomocniPodaciUnosas = null)
    {
        if (is_null($pomocniPodaciUnosas) || (is_array($pomocniPodaciUnosas) && empty($pomocniPodaciUnosas))) {
            unset($this->PomocniPodaciUnosas);
        } else {
            $this->PomocniPodaciUnosas = $pomocniPodaciUnosas;
        }
        return $this;
    }
    /**
     * Get PrateciLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists()
    {
        return isset($this->PrateciLists) ? $this->PrateciLists : null;
    }
    /**
     * Set PrateciLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @return \StructType\NKD
     */
    public function setPrateciLists(\ArrayType\ArrayOfPrateciList $prateciLists = null)
    {
        if (is_null($prateciLists) || (is_array($prateciLists) && empty($prateciLists))) {
            unset($this->PrateciLists);
        } else {
            $this->PrateciLists = $prateciLists;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\NKD
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get SUMPID value
     * @return int|null
     */
    public function getSUMPID()
    {
        return $this->SUMPID;
    }
    /**
     * Set SUMPID value
     * @param int $sUMPID
     * @return \StructType\NKD
     */
    public function setSUMPID($sUMPID = null)
    {
        // validation for constraint: int
        if (!is_null($sUMPID) && !(is_int($sUMPID) || ctype_digit($sUMPID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sUMPID, true), gettype($sUMPID)), __LINE__);
        }
        $this->SUMPID = $sUMPID;
        return $this;
    }
    /**
     * Get SUMPVrijemeIzmjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPVrijemeIzmjene()
    {
        return isset($this->SUMPVrijemeIzmjene) ? $this->SUMPVrijemeIzmjene : null;
    }
    /**
     * Set SUMPVrijemeIzmjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPVrijemeIzmjene
     * @return \StructType\NKD
     */
    public function setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeIzmjene) && !is_string($sUMPVrijemeIzmjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeIzmjene, true), gettype($sUMPVrijemeIzmjene)), __LINE__);
        }
        if (is_null($sUMPVrijemeIzmjene) || (is_array($sUMPVrijemeIzmjene) && empty($sUMPVrijemeIzmjene))) {
            unset($this->SUMPVrijemeIzmjene);
        } else {
            $this->SUMPVrijemeIzmjene = $sUMPVrijemeIzmjene;
        }
        return $this;
    }
    /**
     * Get SUMPVrijemeUpisa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPVrijemeUpisa()
    {
        return isset($this->SUMPVrijemeUpisa) ? $this->SUMPVrijemeUpisa : null;
    }
    /**
     * Set SUMPVrijemeUpisa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPVrijemeUpisa
     * @return \StructType\NKD
     */
    public function setSUMPVrijemeUpisa($sUMPVrijemeUpisa = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeUpisa) && !is_string($sUMPVrijemeUpisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeUpisa, true), gettype($sUMPVrijemeUpisa)), __LINE__);
        }
        if (is_null($sUMPVrijemeUpisa) || (is_array($sUMPVrijemeUpisa) && empty($sUMPVrijemeUpisa))) {
            unset($this->SUMPVrijemeUpisa);
        } else {
            $this->SUMPVrijemeUpisa = $sUMPVrijemeUpisa;
        }
        return $this;
    }
    /**
     * Get SUMPZadnjiKorisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPZadnjiKorisnik()
    {
        return isset($this->SUMPZadnjiKorisnik) ? $this->SUMPZadnjiKorisnik : null;
    }
    /**
     * Set SUMPZadnjiKorisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPZadnjiKorisnik
     * @return \StructType\NKD
     */
    public function setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPZadnjiKorisnik) && !is_string($sUMPZadnjiKorisnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPZadnjiKorisnik, true), gettype($sUMPZadnjiKorisnik)), __LINE__);
        }
        if (is_null($sUMPZadnjiKorisnik) || (is_array($sUMPZadnjiKorisnik) && empty($sUMPZadnjiKorisnik))) {
            unset($this->SUMPZadnjiKorisnik);
        } else {
            $this->SUMPZadnjiKorisnik = $sUMPZadnjiKorisnik;
        }
        return $this;
    }
}
