<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DohvatiPravnuOsobu StructType
 * @subpackage Structs
 */
class DohvatiPravnuOsobu extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * The OIBMB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIBMB;
    /**
     * Constructor method for DohvatiPravnuOsobu
     * @uses DohvatiPravnuOsobu::setUsername()
     * @uses DohvatiPravnuOsobu::setSecurityToken()
     * @uses DohvatiPravnuOsobu::setOIBMB()
     * @param string $username
     * @param string $securityToken
     * @param string $oIBMB
     */
    public function __construct($username = null, $securityToken = null, $oIBMB = null)
    {
        $this
            ->setUsername($username)
            ->setSecurityToken($securityToken)
            ->setOIBMB($oIBMB);
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\DohvatiPravnuOsobu
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\DohvatiPravnuOsobu
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
    /**
     * Get OIBMB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIBMB()
    {
        return isset($this->OIBMB) ? $this->OIBMB : null;
    }
    /**
     * Set OIBMB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIBMB
     * @return \StructType\DohvatiPravnuOsobu
     */
    public function setOIBMB($oIBMB = null)
    {
        // validation for constraint: string
        if (!is_null($oIBMB) && !is_string($oIBMB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIBMB, true), gettype($oIBMB)), __LINE__);
        }
        if (is_null($oIBMB) || (is_array($oIBMB) && empty($oIBMB))) {
            unset($this->OIBMB);
        } else {
            $this->OIBMB = $oIBMB;
        }
        return $this;
    }
}
