<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AspNetUsers StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AspNetUsers
 * @subpackage Structs
 */
class AspNetUsers extends AbstractStructBase
{
    /**
     * The AccessFailedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessFailedCount;
    /**
     * The AspNetUserClaims
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAspNetUserClaims
     */
    public $AspNetUserClaims;
    /**
     * The AspNetUserLogins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAspNetUserLogins
     */
    public $AspNetUserLogins;
    /**
     * The AspNetUserStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AspNetUserStatus
     */
    public $AspNetUserStatus;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The EmailConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EmailConfirmed;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The KorisnikId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KorisnikId;
    /**
     * The KorisnikPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KorisnikPromjene;
    /**
     * The KorisnikUnosa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KorisnikUnosa;
    /**
     * The LockoutEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LockoutEnabled;
    /**
     * The LockoutEndDateUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LockoutEndDateUtc;
    /**
     * The PasswordHash
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PasswordHash;
    /**
     * The PasswordResetToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PasswordResetToken;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The PhoneNumberConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PhoneNumberConfirmed;
    /**
     * The SecurityStamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityStamp;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Status;
    /**
     * The TwoFactorEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TwoFactorEnabled;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The VrijemePromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VrijemePromjene;
    /**
     * The VrijemeUnosa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijemeUnosa;
    /**
     * Constructor method for AspNetUsers
     * @uses AspNetUsers::setAccessFailedCount()
     * @uses AspNetUsers::setAspNetUserClaims()
     * @uses AspNetUsers::setAspNetUserLogins()
     * @uses AspNetUsers::setAspNetUserStatus()
     * @uses AspNetUsers::setEmail()
     * @uses AspNetUsers::setEmailConfirmed()
     * @uses AspNetUsers::setId()
     * @uses AspNetUsers::setKorisnik()
     * @uses AspNetUsers::setKorisnikId()
     * @uses AspNetUsers::setKorisnikPromjene()
     * @uses AspNetUsers::setKorisnikUnosa()
     * @uses AspNetUsers::setLockoutEnabled()
     * @uses AspNetUsers::setLockoutEndDateUtc()
     * @uses AspNetUsers::setPasswordHash()
     * @uses AspNetUsers::setPasswordResetToken()
     * @uses AspNetUsers::setPhoneNumber()
     * @uses AspNetUsers::setPhoneNumberConfirmed()
     * @uses AspNetUsers::setSecurityStamp()
     * @uses AspNetUsers::setStatus()
     * @uses AspNetUsers::setTwoFactorEnabled()
     * @uses AspNetUsers::setUserName()
     * @uses AspNetUsers::setVrijemePromjene()
     * @uses AspNetUsers::setVrijemeUnosa()
     * @param int $accessFailedCount
     * @param \ArrayType\ArrayOfAspNetUserClaims $aspNetUserClaims
     * @param \ArrayType\ArrayOfAspNetUserLogins $aspNetUserLogins
     * @param \StructType\AspNetUserStatus $aspNetUserStatus
     * @param string $email
     * @param bool $emailConfirmed
     * @param string $id
     * @param \StructType\Korisnik $korisnik
     * @param int $korisnikId
     * @param string $korisnikPromjene
     * @param string $korisnikUnosa
     * @param bool $lockoutEnabled
     * @param string $lockoutEndDateUtc
     * @param string $passwordHash
     * @param string $passwordResetToken
     * @param string $phoneNumber
     * @param bool $phoneNumberConfirmed
     * @param string $securityStamp
     * @param int $status
     * @param bool $twoFactorEnabled
     * @param string $userName
     * @param string $vrijemePromjene
     * @param string $vrijemeUnosa
     */
    public function __construct($accessFailedCount = null, \ArrayType\ArrayOfAspNetUserClaims $aspNetUserClaims = null, \ArrayType\ArrayOfAspNetUserLogins $aspNetUserLogins = null, \StructType\AspNetUserStatus $aspNetUserStatus = null, $email = null, $emailConfirmed = null, $id = null, \StructType\Korisnik $korisnik = null, $korisnikId = null, $korisnikPromjene = null, $korisnikUnosa = null, $lockoutEnabled = null, $lockoutEndDateUtc = null, $passwordHash = null, $passwordResetToken = null, $phoneNumber = null, $phoneNumberConfirmed = null, $securityStamp = null, $status = null, $twoFactorEnabled = null, $userName = null, $vrijemePromjene = null, $vrijemeUnosa = null)
    {
        $this
            ->setAccessFailedCount($accessFailedCount)
            ->setAspNetUserClaims($aspNetUserClaims)
            ->setAspNetUserLogins($aspNetUserLogins)
            ->setAspNetUserStatus($aspNetUserStatus)
            ->setEmail($email)
            ->setEmailConfirmed($emailConfirmed)
            ->setId($id)
            ->setKorisnik($korisnik)
            ->setKorisnikId($korisnikId)
            ->setKorisnikPromjene($korisnikPromjene)
            ->setKorisnikUnosa($korisnikUnosa)
            ->setLockoutEnabled($lockoutEnabled)
            ->setLockoutEndDateUtc($lockoutEndDateUtc)
            ->setPasswordHash($passwordHash)
            ->setPasswordResetToken($passwordResetToken)
            ->setPhoneNumber($phoneNumber)
            ->setPhoneNumberConfirmed($phoneNumberConfirmed)
            ->setSecurityStamp($securityStamp)
            ->setStatus($status)
            ->setTwoFactorEnabled($twoFactorEnabled)
            ->setUserName($userName)
            ->setVrijemePromjene($vrijemePromjene)
            ->setVrijemeUnosa($vrijemeUnosa);
    }
    /**
     * Get AccessFailedCount value
     * @return int|null
     */
    public function getAccessFailedCount()
    {
        return $this->AccessFailedCount;
    }
    /**
     * Set AccessFailedCount value
     * @param int $accessFailedCount
     * @return \StructType\AspNetUsers
     */
    public function setAccessFailedCount($accessFailedCount = null)
    {
        // validation for constraint: int
        if (!is_null($accessFailedCount) && !(is_int($accessFailedCount) || ctype_digit($accessFailedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessFailedCount, true), gettype($accessFailedCount)), __LINE__);
        }
        $this->AccessFailedCount = $accessFailedCount;
        return $this;
    }
    /**
     * Get AspNetUserClaims value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAspNetUserClaims|null
     */
    public function getAspNetUserClaims()
    {
        return isset($this->AspNetUserClaims) ? $this->AspNetUserClaims : null;
    }
    /**
     * Set AspNetUserClaims value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAspNetUserClaims $aspNetUserClaims
     * @return \StructType\AspNetUsers
     */
    public function setAspNetUserClaims(\ArrayType\ArrayOfAspNetUserClaims $aspNetUserClaims = null)
    {
        if (is_null($aspNetUserClaims) || (is_array($aspNetUserClaims) && empty($aspNetUserClaims))) {
            unset($this->AspNetUserClaims);
        } else {
            $this->AspNetUserClaims = $aspNetUserClaims;
        }
        return $this;
    }
    /**
     * Get AspNetUserLogins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAspNetUserLogins|null
     */
    public function getAspNetUserLogins()
    {
        return isset($this->AspNetUserLogins) ? $this->AspNetUserLogins : null;
    }
    /**
     * Set AspNetUserLogins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAspNetUserLogins $aspNetUserLogins
     * @return \StructType\AspNetUsers
     */
    public function setAspNetUserLogins(\ArrayType\ArrayOfAspNetUserLogins $aspNetUserLogins = null)
    {
        if (is_null($aspNetUserLogins) || (is_array($aspNetUserLogins) && empty($aspNetUserLogins))) {
            unset($this->AspNetUserLogins);
        } else {
            $this->AspNetUserLogins = $aspNetUserLogins;
        }
        return $this;
    }
    /**
     * Get AspNetUserStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AspNetUserStatus|null
     */
    public function getAspNetUserStatus()
    {
        return isset($this->AspNetUserStatus) ? $this->AspNetUserStatus : null;
    }
    /**
     * Set AspNetUserStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AspNetUserStatus $aspNetUserStatus
     * @return \StructType\AspNetUsers
     */
    public function setAspNetUserStatus(\StructType\AspNetUserStatus $aspNetUserStatus = null)
    {
        if (is_null($aspNetUserStatus) || (is_array($aspNetUserStatus) && empty($aspNetUserStatus))) {
            unset($this->AspNetUserStatus);
        } else {
            $this->AspNetUserStatus = $aspNetUserStatus;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\AspNetUsers
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get EmailConfirmed value
     * @return bool|null
     */
    public function getEmailConfirmed()
    {
        return $this->EmailConfirmed;
    }
    /**
     * Set EmailConfirmed value
     * @param bool $emailConfirmed
     * @return \StructType\AspNetUsers
     */
    public function setEmailConfirmed($emailConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailConfirmed) && !is_bool($emailConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailConfirmed, true), gettype($emailConfirmed)), __LINE__);
        }
        $this->EmailConfirmed = $emailConfirmed;
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \StructType\AspNetUsers
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\AspNetUsers
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get KorisnikId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKorisnikId()
    {
        return isset($this->KorisnikId) ? $this->KorisnikId : null;
    }
    /**
     * Set KorisnikId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $korisnikId
     * @return \StructType\AspNetUsers
     */
    public function setKorisnikId($korisnikId = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikId) && !(is_int($korisnikId) || ctype_digit($korisnikId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikId, true), gettype($korisnikId)), __LINE__);
        }
        if (is_null($korisnikId) || (is_array($korisnikId) && empty($korisnikId))) {
            unset($this->KorisnikId);
        } else {
            $this->KorisnikId = $korisnikId;
        }
        return $this;
    }
    /**
     * Get KorisnikPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKorisnikPromjene()
    {
        return isset($this->KorisnikPromjene) ? $this->KorisnikPromjene : null;
    }
    /**
     * Set KorisnikPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $korisnikPromjene
     * @return \StructType\AspNetUsers
     */
    public function setKorisnikPromjene($korisnikPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($korisnikPromjene) && !is_string($korisnikPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($korisnikPromjene, true), gettype($korisnikPromjene)), __LINE__);
        }
        if (is_null($korisnikPromjene) || (is_array($korisnikPromjene) && empty($korisnikPromjene))) {
            unset($this->KorisnikPromjene);
        } else {
            $this->KorisnikPromjene = $korisnikPromjene;
        }
        return $this;
    }
    /**
     * Get KorisnikUnosa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKorisnikUnosa()
    {
        return isset($this->KorisnikUnosa) ? $this->KorisnikUnosa : null;
    }
    /**
     * Set KorisnikUnosa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $korisnikUnosa
     * @return \StructType\AspNetUsers
     */
    public function setKorisnikUnosa($korisnikUnosa = null)
    {
        // validation for constraint: string
        if (!is_null($korisnikUnosa) && !is_string($korisnikUnosa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($korisnikUnosa, true), gettype($korisnikUnosa)), __LINE__);
        }
        if (is_null($korisnikUnosa) || (is_array($korisnikUnosa) && empty($korisnikUnosa))) {
            unset($this->KorisnikUnosa);
        } else {
            $this->KorisnikUnosa = $korisnikUnosa;
        }
        return $this;
    }
    /**
     * Get LockoutEnabled value
     * @return bool|null
     */
    public function getLockoutEnabled()
    {
        return $this->LockoutEnabled;
    }
    /**
     * Set LockoutEnabled value
     * @param bool $lockoutEnabled
     * @return \StructType\AspNetUsers
     */
    public function setLockoutEnabled($lockoutEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($lockoutEnabled) && !is_bool($lockoutEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lockoutEnabled, true), gettype($lockoutEnabled)), __LINE__);
        }
        $this->LockoutEnabled = $lockoutEnabled;
        return $this;
    }
    /**
     * Get LockoutEndDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockoutEndDateUtc()
    {
        return isset($this->LockoutEndDateUtc) ? $this->LockoutEndDateUtc : null;
    }
    /**
     * Set LockoutEndDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockoutEndDateUtc
     * @return \StructType\AspNetUsers
     */
    public function setLockoutEndDateUtc($lockoutEndDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutEndDateUtc) && !is_string($lockoutEndDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockoutEndDateUtc, true), gettype($lockoutEndDateUtc)), __LINE__);
        }
        if (is_null($lockoutEndDateUtc) || (is_array($lockoutEndDateUtc) && empty($lockoutEndDateUtc))) {
            unset($this->LockoutEndDateUtc);
        } else {
            $this->LockoutEndDateUtc = $lockoutEndDateUtc;
        }
        return $this;
    }
    /**
     * Get PasswordHash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPasswordHash()
    {
        return isset($this->PasswordHash) ? $this->PasswordHash : null;
    }
    /**
     * Set PasswordHash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passwordHash
     * @return \StructType\AspNetUsers
     */
    public function setPasswordHash($passwordHash = null)
    {
        // validation for constraint: string
        if (!is_null($passwordHash) && !is_string($passwordHash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordHash, true), gettype($passwordHash)), __LINE__);
        }
        if (is_null($passwordHash) || (is_array($passwordHash) && empty($passwordHash))) {
            unset($this->PasswordHash);
        } else {
            $this->PasswordHash = $passwordHash;
        }
        return $this;
    }
    /**
     * Get PasswordResetToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPasswordResetToken()
    {
        return isset($this->PasswordResetToken) ? $this->PasswordResetToken : null;
    }
    /**
     * Set PasswordResetToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passwordResetToken
     * @return \StructType\AspNetUsers
     */
    public function setPasswordResetToken($passwordResetToken = null)
    {
        // validation for constraint: string
        if (!is_null($passwordResetToken) && !is_string($passwordResetToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordResetToken, true), gettype($passwordResetToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($passwordResetToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $passwordResetToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($passwordResetToken, true)), __LINE__);
        }
        if (is_null($passwordResetToken) || (is_array($passwordResetToken) && empty($passwordResetToken))) {
            unset($this->PasswordResetToken);
        } else {
            $this->PasswordResetToken = $passwordResetToken;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\AspNetUsers
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get PhoneNumberConfirmed value
     * @return bool|null
     */
    public function getPhoneNumberConfirmed()
    {
        return $this->PhoneNumberConfirmed;
    }
    /**
     * Set PhoneNumberConfirmed value
     * @param bool $phoneNumberConfirmed
     * @return \StructType\AspNetUsers
     */
    public function setPhoneNumberConfirmed($phoneNumberConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneNumberConfirmed) && !is_bool($phoneNumberConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneNumberConfirmed, true), gettype($phoneNumberConfirmed)), __LINE__);
        }
        $this->PhoneNumberConfirmed = $phoneNumberConfirmed;
        return $this;
    }
    /**
     * Get SecurityStamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityStamp()
    {
        return isset($this->SecurityStamp) ? $this->SecurityStamp : null;
    }
    /**
     * Set SecurityStamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityStamp
     * @return \StructType\AspNetUsers
     */
    public function setSecurityStamp($securityStamp = null)
    {
        // validation for constraint: string
        if (!is_null($securityStamp) && !is_string($securityStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityStamp, true), gettype($securityStamp)), __LINE__);
        }
        if (is_null($securityStamp) || (is_array($securityStamp) && empty($securityStamp))) {
            unset($this->SecurityStamp);
        } else {
            $this->SecurityStamp = $securityStamp;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\AspNetUsers
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TwoFactorEnabled value
     * @return bool|null
     */
    public function getTwoFactorEnabled()
    {
        return $this->TwoFactorEnabled;
    }
    /**
     * Set TwoFactorEnabled value
     * @param bool $twoFactorEnabled
     * @return \StructType\AspNetUsers
     */
    public function setTwoFactorEnabled($twoFactorEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($twoFactorEnabled) && !is_bool($twoFactorEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($twoFactorEnabled, true), gettype($twoFactorEnabled)), __LINE__);
        }
        $this->TwoFactorEnabled = $twoFactorEnabled;
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \StructType\AspNetUsers
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get VrijemePromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVrijemePromjene()
    {
        return isset($this->VrijemePromjene) ? $this->VrijemePromjene : null;
    }
    /**
     * Set VrijemePromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vrijemePromjene
     * @return \StructType\AspNetUsers
     */
    public function setVrijemePromjene($vrijemePromjene = null)
    {
        // validation for constraint: string
        if (!is_null($vrijemePromjene) && !is_string($vrijemePromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijemePromjene, true), gettype($vrijemePromjene)), __LINE__);
        }
        if (is_null($vrijemePromjene) || (is_array($vrijemePromjene) && empty($vrijemePromjene))) {
            unset($this->VrijemePromjene);
        } else {
            $this->VrijemePromjene = $vrijemePromjene;
        }
        return $this;
    }
    /**
     * Get VrijemeUnosa value
     * @return string|null
     */
    public function getVrijemeUnosa()
    {
        return $this->VrijemeUnosa;
    }
    /**
     * Set VrijemeUnosa value
     * @param string $vrijemeUnosa
     * @return \StructType\AspNetUsers
     */
    public function setVrijemeUnosa($vrijemeUnosa = null)
    {
        // validation for constraint: string
        if (!is_null($vrijemeUnosa) && !is_string($vrijemeUnosa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijemeUnosa, true), gettype($vrijemeUnosa)), __LINE__);
        }
        $this->VrijemeUnosa = $vrijemeUnosa;
        return $this;
    }
}
