<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStatusDTO ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStatusDTO
 * @subpackage Arrays
 */
class ArrayOfStatusDTO extends AbstractStructArrayBase
{
    /**
     * The StatusDTO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StatusDTO[]
     */
    public $StatusDTO;
    /**
     * Constructor method for ArrayOfStatusDTO
     * @uses ArrayOfStatusDTO::setStatusDTO()
     * @param \StructType\StatusDTO[] $statusDTO
     */
    public function __construct(array $statusDTO = array())
    {
        $this
            ->setStatusDTO($statusDTO);
    }
    /**
     * Get StatusDTO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StatusDTO[]|null
     */
    public function getStatusDTO()
    {
        return isset($this->StatusDTO) ? $this->StatusDTO : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusDTO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusDTO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusDTOForArrayConstraintsFromSetStatusDTO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStatusDTOStatusDTOItem) {
            // validation for constraint: itemType
            if (!$arrayOfStatusDTOStatusDTOItem instanceof \StructType\StatusDTO) {
                $invalidValues[] = is_object($arrayOfStatusDTOStatusDTOItem) ? get_class($arrayOfStatusDTOStatusDTOItem) : sprintf('%s(%s)', gettype($arrayOfStatusDTOStatusDTOItem), var_export($arrayOfStatusDTOStatusDTOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatusDTO property can only contain items of type \StructType\StatusDTO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatusDTO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StatusDTO[] $statusDTO
     * @return \ArrayType\ArrayOfStatusDTO
     */
    public function setStatusDTO(array $statusDTO = array())
    {
        // validation for constraint: array
        if ('' !== ($statusDTOArrayErrorMessage = self::validateStatusDTOForArrayConstraintsFromSetStatusDTO($statusDTO))) {
            throw new \InvalidArgumentException($statusDTOArrayErrorMessage, __LINE__);
        }
        if (is_null($statusDTO) || (is_array($statusDTO) && empty($statusDTO))) {
            unset($this->StatusDTO);
        } else {
            $this->StatusDTO = $statusDTO;
        }
        return $this;
    }
    /**
     * Add item to StatusDTO value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusDTO $item
     * @return \ArrayType\ArrayOfStatusDTO
     */
    public function addToStatusDTO(\StructType\StatusDTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusDTO) {
            throw new \InvalidArgumentException(sprintf('The StatusDTO property can only contain items of type \StructType\StatusDTO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StatusDTO[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\StatusDTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\StatusDTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\StatusDTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\StatusDTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\StatusDTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StatusDTO
     */
    public function getAttributeName()
    {
        return 'StatusDTO';
    }
}
