<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zupanija StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Zupanija
 * @subpackage Structs
 */
class Zupanija extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Lokacijas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLokacija
     */
    public $Lokacijas;
    /**
     * The NUTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NUTS;
    /**
     * The Naseljes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNaselje
     */
    public $Naseljes;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The OpGrads
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOpGrad
     */
    public $OpGrads;
    /**
     * The Oznaka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Oznaka;
    /**
     * The PorijekloKomunalnogOtpadaOntoPs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP
     */
    public $PorijekloKomunalnogOtpadaOntoPs;
    /**
     * The PorijekloKomunalnogOtpadaOntoes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto
     */
    public $PorijekloKomunalnogOtpadaOntoes;
    /**
     * The PorijekloKomunalnogOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPorijekloKomunalnogOtpada
     */
    public $PorijekloKomunalnogOtpadas;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The RedniBroj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RedniBroj;
    /**
     * The SUMPID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SUMPID;
    /**
     * The SUMPVrijemeIzmjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPVrijemeIzmjene;
    /**
     * The SUMPVrijemeUpisa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SUMPVrijemeUpisa;
    /**
     * The SUMPZadnjiKorisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPZadnjiKorisnik;
    /**
     * The Sjediste
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sjediste;
    /**
     * The ZupanijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ZupanijaID;
    /**
     * Constructor method for Zupanija
     * @uses Zupanija::setAktivan()
     * @uses Zupanija::setDatumKreiranja()
     * @uses Zupanija::setDatumPromjene()
     * @uses Zupanija::setKreirao()
     * @uses Zupanija::setLokacijas()
     * @uses Zupanija::setNUTS()
     * @uses Zupanija::setNaseljes()
     * @uses Zupanija::setNaziv()
     * @uses Zupanija::setOpGrads()
     * @uses Zupanija::setOznaka()
     * @uses Zupanija::setPorijekloKomunalnogOtpadaOntoPs()
     * @uses Zupanija::setPorijekloKomunalnogOtpadaOntoes()
     * @uses Zupanija::setPorijekloKomunalnogOtpadas()
     * @uses Zupanija::setPromijenio()
     * @uses Zupanija::setRedniBroj()
     * @uses Zupanija::setSUMPID()
     * @uses Zupanija::setSUMPVrijemeIzmjene()
     * @uses Zupanija::setSUMPVrijemeUpisa()
     * @uses Zupanija::setSUMPZadnjiKorisnik()
     * @uses Zupanija::setSjediste()
     * @uses Zupanija::setZupanijaID()
     * @param bool $aktivan
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param \ArrayType\ArrayOfLokacija $lokacijas
     * @param string $nUTS
     * @param \ArrayType\ArrayOfNaselje $naseljes
     * @param string $naziv
     * @param \ArrayType\ArrayOfOpGrad $opGrads
     * @param string $oznaka
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas
     * @param string $promijenio
     * @param int $redniBroj
     * @param int $sUMPID
     * @param string $sUMPVrijemeIzmjene
     * @param string $sUMPVrijemeUpisa
     * @param string $sUMPZadnjiKorisnik
     * @param string $sjediste
     * @param int $zupanijaID
     */
    public function __construct($aktivan = null, $datumKreiranja = null, $datumPromjene = null, $kreirao = null, \ArrayType\ArrayOfLokacija $lokacijas = null, $nUTS = null, \ArrayType\ArrayOfNaselje $naseljes = null, $naziv = null, \ArrayType\ArrayOfOpGrad $opGrads = null, $oznaka = null, \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs = null, \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes = null, \ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas = null, $promijenio = null, $redniBroj = null, $sUMPID = null, $sUMPVrijemeIzmjene = null, $sUMPVrijemeUpisa = null, $sUMPZadnjiKorisnik = null, $sjediste = null, $zupanijaID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setLokacijas($lokacijas)
            ->setNUTS($nUTS)
            ->setNaseljes($naseljes)
            ->setNaziv($naziv)
            ->setOpGrads($opGrads)
            ->setOznaka($oznaka)
            ->setPorijekloKomunalnogOtpadaOntoPs($porijekloKomunalnogOtpadaOntoPs)
            ->setPorijekloKomunalnogOtpadaOntoes($porijekloKomunalnogOtpadaOntoes)
            ->setPorijekloKomunalnogOtpadas($porijekloKomunalnogOtpadas)
            ->setPromijenio($promijenio)
            ->setRedniBroj($redniBroj)
            ->setSUMPID($sUMPID)
            ->setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene)
            ->setSUMPVrijemeUpisa($sUMPVrijemeUpisa)
            ->setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik)
            ->setSjediste($sjediste)
            ->setZupanijaID($zupanijaID);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\Zupanija
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\Zupanija
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\Zupanija
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\Zupanija
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Lokacijas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLokacija|null
     */
    public function getLokacijas()
    {
        return isset($this->Lokacijas) ? $this->Lokacijas : null;
    }
    /**
     * Set Lokacijas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLokacija $lokacijas
     * @return \StructType\Zupanija
     */
    public function setLokacijas(\ArrayType\ArrayOfLokacija $lokacijas = null)
    {
        if (is_null($lokacijas) || (is_array($lokacijas) && empty($lokacijas))) {
            unset($this->Lokacijas);
        } else {
            $this->Lokacijas = $lokacijas;
        }
        return $this;
    }
    /**
     * Get NUTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNUTS()
    {
        return isset($this->NUTS) ? $this->NUTS : null;
    }
    /**
     * Set NUTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nUTS
     * @return \StructType\Zupanija
     */
    public function setNUTS($nUTS = null)
    {
        // validation for constraint: string
        if (!is_null($nUTS) && !is_string($nUTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nUTS, true), gettype($nUTS)), __LINE__);
        }
        if (is_null($nUTS) || (is_array($nUTS) && empty($nUTS))) {
            unset($this->NUTS);
        } else {
            $this->NUTS = $nUTS;
        }
        return $this;
    }
    /**
     * Get Naseljes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNaselje|null
     */
    public function getNaseljes()
    {
        return isset($this->Naseljes) ? $this->Naseljes : null;
    }
    /**
     * Set Naseljes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNaselje $naseljes
     * @return \StructType\Zupanija
     */
    public function setNaseljes(\ArrayType\ArrayOfNaselje $naseljes = null)
    {
        if (is_null($naseljes) || (is_array($naseljes) && empty($naseljes))) {
            unset($this->Naseljes);
        } else {
            $this->Naseljes = $naseljes;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\Zupanija
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get OpGrads value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOpGrad|null
     */
    public function getOpGrads()
    {
        return isset($this->OpGrads) ? $this->OpGrads : null;
    }
    /**
     * Set OpGrads value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOpGrad $opGrads
     * @return \StructType\Zupanija
     */
    public function setOpGrads(\ArrayType\ArrayOfOpGrad $opGrads = null)
    {
        if (is_null($opGrads) || (is_array($opGrads) && empty($opGrads))) {
            unset($this->OpGrads);
        } else {
            $this->OpGrads = $opGrads;
        }
        return $this;
    }
    /**
     * Get Oznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznaka()
    {
        return isset($this->Oznaka) ? $this->Oznaka : null;
    }
    /**
     * Set Oznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznaka
     * @return \StructType\Zupanija
     */
    public function setOznaka($oznaka = null)
    {
        // validation for constraint: string
        if (!is_null($oznaka) && !is_string($oznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznaka, true), gettype($oznaka)), __LINE__);
        }
        if (is_null($oznaka) || (is_array($oznaka) && empty($oznaka))) {
            unset($this->Oznaka);
        } else {
            $this->Oznaka = $oznaka;
        }
        return $this;
    }
    /**
     * Get PorijekloKomunalnogOtpadaOntoPs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP|null
     */
    public function getPorijekloKomunalnogOtpadaOntoPs()
    {
        return isset($this->PorijekloKomunalnogOtpadaOntoPs) ? $this->PorijekloKomunalnogOtpadaOntoPs : null;
    }
    /**
     * Set PorijekloKomunalnogOtpadaOntoPs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs
     * @return \StructType\Zupanija
     */
    public function setPorijekloKomunalnogOtpadaOntoPs(\ArrayType\ArrayOfPorijekloKomunalnogOtpadaOntoP $porijekloKomunalnogOtpadaOntoPs = null)
    {
        if (is_null($porijekloKomunalnogOtpadaOntoPs) || (is_array($porijekloKomunalnogOtpadaOntoPs) && empty($porijekloKomunalnogOtpadaOntoPs))) {
            unset($this->PorijekloKomunalnogOtpadaOntoPs);
        } else {
            $this->PorijekloKomunalnogOtpadaOntoPs = $porijekloKomunalnogOtpadaOntoPs;
        }
        return $this;
    }
    /**
     * Get PorijekloKomunalnogOtpadaOntoes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto|null
     */
    public function getPorijekloKomunalnogOtpadaOntoes()
    {
        return isset($this->PorijekloKomunalnogOtpadaOntoes) ? $this->PorijekloKomunalnogOtpadaOntoes : null;
    }
    /**
     * Set PorijekloKomunalnogOtpadaOntoes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes
     * @return \StructType\Zupanija
     */
    public function setPorijekloKomunalnogOtpadaOntoes(\ArrayType\ArrayOfPorijekloKomunalnogOtpadaOnto $porijekloKomunalnogOtpadaOntoes = null)
    {
        if (is_null($porijekloKomunalnogOtpadaOntoes) || (is_array($porijekloKomunalnogOtpadaOntoes) && empty($porijekloKomunalnogOtpadaOntoes))) {
            unset($this->PorijekloKomunalnogOtpadaOntoes);
        } else {
            $this->PorijekloKomunalnogOtpadaOntoes = $porijekloKomunalnogOtpadaOntoes;
        }
        return $this;
    }
    /**
     * Get PorijekloKomunalnogOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPorijekloKomunalnogOtpada|null
     */
    public function getPorijekloKomunalnogOtpadas()
    {
        return isset($this->PorijekloKomunalnogOtpadas) ? $this->PorijekloKomunalnogOtpadas : null;
    }
    /**
     * Set PorijekloKomunalnogOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas
     * @return \StructType\Zupanija
     */
    public function setPorijekloKomunalnogOtpadas(\ArrayType\ArrayOfPorijekloKomunalnogOtpada $porijekloKomunalnogOtpadas = null)
    {
        if (is_null($porijekloKomunalnogOtpadas) || (is_array($porijekloKomunalnogOtpadas) && empty($porijekloKomunalnogOtpadas))) {
            unset($this->PorijekloKomunalnogOtpadas);
        } else {
            $this->PorijekloKomunalnogOtpadas = $porijekloKomunalnogOtpadas;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\Zupanija
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get RedniBroj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRedniBroj()
    {
        return isset($this->RedniBroj) ? $this->RedniBroj : null;
    }
    /**
     * Set RedniBroj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $redniBroj
     * @return \StructType\Zupanija
     */
    public function setRedniBroj($redniBroj = null)
    {
        // validation for constraint: int
        if (!is_null($redniBroj) && !(is_int($redniBroj) || ctype_digit($redniBroj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redniBroj, true), gettype($redniBroj)), __LINE__);
        }
        if (is_null($redniBroj) || (is_array($redniBroj) && empty($redniBroj))) {
            unset($this->RedniBroj);
        } else {
            $this->RedniBroj = $redniBroj;
        }
        return $this;
    }
    /**
     * Get SUMPID value
     * @return int|null
     */
    public function getSUMPID()
    {
        return $this->SUMPID;
    }
    /**
     * Set SUMPID value
     * @param int $sUMPID
     * @return \StructType\Zupanija
     */
    public function setSUMPID($sUMPID = null)
    {
        // validation for constraint: int
        if (!is_null($sUMPID) && !(is_int($sUMPID) || ctype_digit($sUMPID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sUMPID, true), gettype($sUMPID)), __LINE__);
        }
        $this->SUMPID = $sUMPID;
        return $this;
    }
    /**
     * Get SUMPVrijemeIzmjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPVrijemeIzmjene()
    {
        return isset($this->SUMPVrijemeIzmjene) ? $this->SUMPVrijemeIzmjene : null;
    }
    /**
     * Set SUMPVrijemeIzmjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPVrijemeIzmjene
     * @return \StructType\Zupanija
     */
    public function setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeIzmjene) && !is_string($sUMPVrijemeIzmjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeIzmjene, true), gettype($sUMPVrijemeIzmjene)), __LINE__);
        }
        if (is_null($sUMPVrijemeIzmjene) || (is_array($sUMPVrijemeIzmjene) && empty($sUMPVrijemeIzmjene))) {
            unset($this->SUMPVrijemeIzmjene);
        } else {
            $this->SUMPVrijemeIzmjene = $sUMPVrijemeIzmjene;
        }
        return $this;
    }
    /**
     * Get SUMPVrijemeUpisa value
     * @return string|null
     */
    public function getSUMPVrijemeUpisa()
    {
        return $this->SUMPVrijemeUpisa;
    }
    /**
     * Set SUMPVrijemeUpisa value
     * @param string $sUMPVrijemeUpisa
     * @return \StructType\Zupanija
     */
    public function setSUMPVrijemeUpisa($sUMPVrijemeUpisa = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeUpisa) && !is_string($sUMPVrijemeUpisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeUpisa, true), gettype($sUMPVrijemeUpisa)), __LINE__);
        }
        $this->SUMPVrijemeUpisa = $sUMPVrijemeUpisa;
        return $this;
    }
    /**
     * Get SUMPZadnjiKorisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPZadnjiKorisnik()
    {
        return isset($this->SUMPZadnjiKorisnik) ? $this->SUMPZadnjiKorisnik : null;
    }
    /**
     * Set SUMPZadnjiKorisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPZadnjiKorisnik
     * @return \StructType\Zupanija
     */
    public function setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPZadnjiKorisnik) && !is_string($sUMPZadnjiKorisnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPZadnjiKorisnik, true), gettype($sUMPZadnjiKorisnik)), __LINE__);
        }
        if (is_null($sUMPZadnjiKorisnik) || (is_array($sUMPZadnjiKorisnik) && empty($sUMPZadnjiKorisnik))) {
            unset($this->SUMPZadnjiKorisnik);
        } else {
            $this->SUMPZadnjiKorisnik = $sUMPZadnjiKorisnik;
        }
        return $this;
    }
    /**
     * Get Sjediste value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSjediste()
    {
        return isset($this->Sjediste) ? $this->Sjediste : null;
    }
    /**
     * Set Sjediste value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sjediste
     * @return \StructType\Zupanija
     */
    public function setSjediste($sjediste = null)
    {
        // validation for constraint: string
        if (!is_null($sjediste) && !is_string($sjediste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sjediste, true), gettype($sjediste)), __LINE__);
        }
        if (is_null($sjediste) || (is_array($sjediste) && empty($sjediste))) {
            unset($this->Sjediste);
        } else {
            $this->Sjediste = $sjediste;
        }
        return $this;
    }
    /**
     * Get ZupanijaID value
     * @return int|null
     */
    public function getZupanijaID()
    {
        return $this->ZupanijaID;
    }
    /**
     * Set ZupanijaID value
     * @param int $zupanijaID
     * @return \StructType\Zupanija
     */
    public function setZupanijaID($zupanijaID = null)
    {
        // validation for constraint: int
        if (!is_null($zupanijaID) && !(is_int($zupanijaID) || ctype_digit($zupanijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zupanijaID, true), gettype($zupanijaID)), __LINE__);
        }
        $this->ZupanijaID = $zupanijaID;
        return $this;
    }
}
