<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrateciListUpdate StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrateciListUpdate
 * @subpackage Structs
 */
class PrateciListUpdate extends AbstractStructBase
{
    /**
     * The DatumInserta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumInserta;
    /**
     * The PrateciList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrateciList
     */
    public $PrateciList;
    /**
     * The PrateciListID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrateciListID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusPratecegLista
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StatusPratecegLista
     */
    public $StatusPratecegLista;
    /**
     * The StatusPratecegListaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StatusPratecegListaID;
    /**
     * Constructor method for PrateciListUpdate
     * @uses PrateciListUpdate::setDatumInserta()
     * @uses PrateciListUpdate::setPrateciList()
     * @uses PrateciListUpdate::setPrateciListID()
     * @uses PrateciListUpdate::setStatus()
     * @uses PrateciListUpdate::setStatusPratecegLista()
     * @uses PrateciListUpdate::setStatusPratecegListaID()
     * @param string $datumInserta
     * @param \StructType\PrateciList $prateciList
     * @param int $prateciListID
     * @param string $status
     * @param \StructType\StatusPratecegLista $statusPratecegLista
     * @param int $statusPratecegListaID
     */
    public function __construct($datumInserta = null, \StructType\PrateciList $prateciList = null, $prateciListID = null, $status = null, \StructType\StatusPratecegLista $statusPratecegLista = null, $statusPratecegListaID = null)
    {
        $this
            ->setDatumInserta($datumInserta)
            ->setPrateciList($prateciList)
            ->setPrateciListID($prateciListID)
            ->setStatus($status)
            ->setStatusPratecegLista($statusPratecegLista)
            ->setStatusPratecegListaID($statusPratecegListaID);
    }
    /**
     * Get DatumInserta value
     * @return string|null
     */
    public function getDatumInserta()
    {
        return $this->DatumInserta;
    }
    /**
     * Set DatumInserta value
     * @param string $datumInserta
     * @return \StructType\PrateciListUpdate
     */
    public function setDatumInserta($datumInserta = null)
    {
        // validation for constraint: string
        if (!is_null($datumInserta) && !is_string($datumInserta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumInserta, true), gettype($datumInserta)), __LINE__);
        }
        $this->DatumInserta = $datumInserta;
        return $this;
    }
    /**
     * Get PrateciList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrateciList|null
     */
    public function getPrateciList()
    {
        return isset($this->PrateciList) ? $this->PrateciList : null;
    }
    /**
     * Set PrateciList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PrateciList $prateciList
     * @return \StructType\PrateciListUpdate
     */
    public function setPrateciList(\StructType\PrateciList $prateciList = null)
    {
        if (is_null($prateciList) || (is_array($prateciList) && empty($prateciList))) {
            unset($this->PrateciList);
        } else {
            $this->PrateciList = $prateciList;
        }
        return $this;
    }
    /**
     * Get PrateciListID value
     * @return int|null
     */
    public function getPrateciListID()
    {
        return $this->PrateciListID;
    }
    /**
     * Set PrateciListID value
     * @param int $prateciListID
     * @return \StructType\PrateciListUpdate
     */
    public function setPrateciListID($prateciListID = null)
    {
        // validation for constraint: int
        if (!is_null($prateciListID) && !(is_int($prateciListID) || ctype_digit($prateciListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prateciListID, true), gettype($prateciListID)), __LINE__);
        }
        $this->PrateciListID = $prateciListID;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\PrateciListUpdate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusPratecegLista value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StatusPratecegLista|null
     */
    public function getStatusPratecegLista()
    {
        return isset($this->StatusPratecegLista) ? $this->StatusPratecegLista : null;
    }
    /**
     * Set StatusPratecegLista value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StatusPratecegLista $statusPratecegLista
     * @return \StructType\PrateciListUpdate
     */
    public function setStatusPratecegLista(\StructType\StatusPratecegLista $statusPratecegLista = null)
    {
        if (is_null($statusPratecegLista) || (is_array($statusPratecegLista) && empty($statusPratecegLista))) {
            unset($this->StatusPratecegLista);
        } else {
            $this->StatusPratecegLista = $statusPratecegLista;
        }
        return $this;
    }
    /**
     * Get StatusPratecegListaID value
     * @return int|null
     */
    public function getStatusPratecegListaID()
    {
        return $this->StatusPratecegListaID;
    }
    /**
     * Set StatusPratecegListaID value
     * @param int $statusPratecegListaID
     * @return \StructType\PrateciListUpdate
     */
    public function setStatusPratecegListaID($statusPratecegListaID = null)
    {
        // validation for constraint: int
        if (!is_null($statusPratecegListaID) && !(is_int($statusPratecegListaID) || ctype_digit($statusPratecegListaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusPratecegListaID, true), gettype($statusPratecegListaID)), __LINE__);
        }
        $this->StatusPratecegListaID = $statusPratecegListaID;
        return $this;
    }
}
