<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LokacijaPretragaInput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LokacijaPretragaInput
 * @subpackage Structs
 */
class LokacijaPretragaInput extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The NaseljaJLSZupanijeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNaseljeJLSZupanija
     */
    public $NaseljaJLSZupanijeList;
    /**
     * The NazivLokacije
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivLokacije;
    /**
     * The SifraLokacije
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SifraLokacije;
    /**
     * The TvrtkeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $TvrtkeList;
    /**
     * Constructor method for LokacijaPretragaInput
     * @uses LokacijaPretragaInput::setAktivan()
     * @uses LokacijaPretragaInput::setNaseljaJLSZupanijeList()
     * @uses LokacijaPretragaInput::setNazivLokacije()
     * @uses LokacijaPretragaInput::setSifraLokacije()
     * @uses LokacijaPretragaInput::setTvrtkeList()
     * @param bool $aktivan
     * @param \ArrayType\ArrayOfNaseljeJLSZupanija $naseljaJLSZupanijeList
     * @param string $nazivLokacije
     * @param string $sifraLokacije
     * @param \ArrayType\ArrayOfstring $tvrtkeList
     */
    public function __construct($aktivan = null, \ArrayType\ArrayOfNaseljeJLSZupanija $naseljaJLSZupanijeList = null, $nazivLokacije = null, $sifraLokacije = null, \ArrayType\ArrayOfstring $tvrtkeList = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNaseljaJLSZupanijeList($naseljaJLSZupanijeList)
            ->setNazivLokacije($nazivLokacije)
            ->setSifraLokacije($sifraLokacije)
            ->setTvrtkeList($tvrtkeList);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\LokacijaPretragaInput
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get NaseljaJLSZupanijeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNaseljeJLSZupanija|null
     */
    public function getNaseljaJLSZupanijeList()
    {
        return isset($this->NaseljaJLSZupanijeList) ? $this->NaseljaJLSZupanijeList : null;
    }
    /**
     * Set NaseljaJLSZupanijeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNaseljeJLSZupanija $naseljaJLSZupanijeList
     * @return \StructType\LokacijaPretragaInput
     */
    public function setNaseljaJLSZupanijeList(\ArrayType\ArrayOfNaseljeJLSZupanija $naseljaJLSZupanijeList = null)
    {
        if (is_null($naseljaJLSZupanijeList) || (is_array($naseljaJLSZupanijeList) && empty($naseljaJLSZupanijeList))) {
            unset($this->NaseljaJLSZupanijeList);
        } else {
            $this->NaseljaJLSZupanijeList = $naseljaJLSZupanijeList;
        }
        return $this;
    }
    /**
     * Get NazivLokacije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivLokacije()
    {
        return isset($this->NazivLokacije) ? $this->NazivLokacije : null;
    }
    /**
     * Set NazivLokacije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivLokacije
     * @return \StructType\LokacijaPretragaInput
     */
    public function setNazivLokacije($nazivLokacije = null)
    {
        // validation for constraint: string
        if (!is_null($nazivLokacije) && !is_string($nazivLokacije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivLokacije, true), gettype($nazivLokacije)), __LINE__);
        }
        if (is_null($nazivLokacije) || (is_array($nazivLokacije) && empty($nazivLokacije))) {
            unset($this->NazivLokacije);
        } else {
            $this->NazivLokacije = $nazivLokacije;
        }
        return $this;
    }
    /**
     * Get SifraLokacije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifraLokacije()
    {
        return isset($this->SifraLokacije) ? $this->SifraLokacije : null;
    }
    /**
     * Set SifraLokacije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifraLokacije
     * @return \StructType\LokacijaPretragaInput
     */
    public function setSifraLokacije($sifraLokacije = null)
    {
        // validation for constraint: string
        if (!is_null($sifraLokacije) && !is_string($sifraLokacije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraLokacije, true), gettype($sifraLokacije)), __LINE__);
        }
        if (is_null($sifraLokacije) || (is_array($sifraLokacije) && empty($sifraLokacije))) {
            unset($this->SifraLokacije);
        } else {
            $this->SifraLokacije = $sifraLokacije;
        }
        return $this;
    }
    /**
     * Get TvrtkeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getTvrtkeList()
    {
        return isset($this->TvrtkeList) ? $this->TvrtkeList : null;
    }
    /**
     * Set TvrtkeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $tvrtkeList
     * @return \StructType\LokacijaPretragaInput
     */
    public function setTvrtkeList(\ArrayType\ArrayOfstring $tvrtkeList = null)
    {
        if (is_null($tvrtkeList) || (is_array($tvrtkeList) && empty($tvrtkeList))) {
            unset($this->TvrtkeList);
        } else {
            $this->TvrtkeList = $tvrtkeList;
        }
        return $this;
    }
}
