<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPrateciListCollection_v2 StructType
 * @subpackage Structs
 */
class GetPrateciListCollection_v2 extends AbstractStructBase
{
    /**
     * The prateciListIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciListIdInput
     */
    public $prateciListIds;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * Constructor method for GetPrateciListCollection_v2
     * @uses GetPrateciListCollection_v2::setPrateciListIds()
     * @uses GetPrateciListCollection_v2::setUsername()
     * @uses GetPrateciListCollection_v2::setSecurityToken()
     * @param \ArrayType\ArrayOfPrateciListIdInput $prateciListIds
     * @param string $username
     * @param string $securityToken
     */
    public function __construct(\ArrayType\ArrayOfPrateciListIdInput $prateciListIds = null, $username = null, $securityToken = null)
    {
        $this
            ->setPrateciListIds($prateciListIds)
            ->setUsername($username)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get prateciListIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciListIdInput|null
     */
    public function getPrateciListIds()
    {
        return isset($this->prateciListIds) ? $this->prateciListIds : null;
    }
    /**
     * Set prateciListIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciListIdInput $prateciListIds
     * @return \StructType\GetPrateciListCollection_v2
     */
    public function setPrateciListIds(\ArrayType\ArrayOfPrateciListIdInput $prateciListIds = null)
    {
        if (is_null($prateciListIds) || (is_array($prateciListIds) && empty($prateciListIds))) {
            unset($this->prateciListIds);
        } else {
            $this->prateciListIds = $prateciListIds;
        }
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\GetPrateciListCollection_v2
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\GetPrateciListCollection_v2
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
}
