<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DozvolaDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DozvolaDTO
 * @subpackage Structs
 */
class DozvolaDTO extends AbstractStructBase
{
    /**
     * The DatumIsteka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumIsteka;
    /**
     * The DatumIzvrsnosti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumIzvrsnosti;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPravomocnosti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPravomocnosti;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPromjene;
    /**
     * The DozvolaKBs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDozvolaKBDTO
     */
    public $DozvolaKBs;
    /**
     * The DozvolaSuglasnostID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DozvolaSuglasnostID;
    /**
     * The DozvolaZabranes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDozvolaZabraneDTO
     */
    public $DozvolaZabranes;
    /**
     * The DozvoleKBRDKolicines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDozvoleKBRDKolicineDTO
     */
    public $DozvoleKBRDKolicines;
    /**
     * The DozvoleRDOznakes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDozvoleRDOznakeDTO
     */
    public $DozvoleRDOznakes;
    /**
     * The IDDozvola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDDozvola;
    /**
     * The KapacitetOdlagalistaM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $KapacitetOdlagalistaM;
    /**
     * The KlasifikacijskaOznaka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KlasifikacijskaOznaka;
    /**
     * The KolicinaNeopasnogOtpadaT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $KolicinaNeopasnogOtpadaT;
    /**
     * The KolicinaOpasnogOtpadaT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $KolicinaOpasnogOtpadaT;
    /**
     * The KolicinaOtpadaM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $KolicinaOtpadaM;
    /**
     * The KolicinaOtpadaT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $KolicinaOtpadaT;
    /**
     * The LokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaID;
    /**
     * The PFOOsobaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PFOOsobaID;
    /**
     * The RedgoDozvolaID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RedgoDozvolaID;
    /**
     * The StatusZahtjevaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StatusZahtjevaID;
    /**
     * The TipZahtjevaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TipZahtjevaID;
    /**
     * The UrudžbeniBroj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrudžbeniBroj;
    /**
     * Constructor method for DozvolaDTO
     * @uses DozvolaDTO::setDatumIsteka()
     * @uses DozvolaDTO::setDatumIzvrsnosti()
     * @uses DozvolaDTO::setDatumKreiranja()
     * @uses DozvolaDTO::setDatumPravomocnosti()
     * @uses DozvolaDTO::setDatumPromjene()
     * @uses DozvolaDTO::setDozvolaKBs()
     * @uses DozvolaDTO::setDozvolaSuglasnostID()
     * @uses DozvolaDTO::setDozvolaZabranes()
     * @uses DozvolaDTO::setDozvoleKBRDKolicines()
     * @uses DozvolaDTO::setDozvoleRDOznakes()
     * @uses DozvolaDTO::setIDDozvola()
     * @uses DozvolaDTO::setKapacitetOdlagalistaM()
     * @uses DozvolaDTO::setKlasifikacijskaOznaka()
     * @uses DozvolaDTO::setKolicinaNeopasnogOtpadaT()
     * @uses DozvolaDTO::setKolicinaOpasnogOtpadaT()
     * @uses DozvolaDTO::setKolicinaOtpadaM()
     * @uses DozvolaDTO::setKolicinaOtpadaT()
     * @uses DozvolaDTO::setLokacijaID()
     * @uses DozvolaDTO::setPFOOsobaID()
     * @uses DozvolaDTO::setRedgoDozvolaID()
     * @uses DozvolaDTO::setStatusZahtjevaID()
     * @uses DozvolaDTO::setTipZahtjevaID()
     * @uses DozvolaDTO::setUrudžbeniBroj()
     * @param string $datumIsteka
     * @param string $datumIzvrsnosti
     * @param string $datumKreiranja
     * @param string $datumPravomocnosti
     * @param string $datumPromjene
     * @param \ArrayType\ArrayOfDozvolaKBDTO $dozvolaKBs
     * @param int $dozvolaSuglasnostID
     * @param \ArrayType\ArrayOfDozvolaZabraneDTO $dozvolaZabranes
     * @param \ArrayType\ArrayOfDozvoleKBRDKolicineDTO $dozvoleKBRDKolicines
     * @param \ArrayType\ArrayOfDozvoleRDOznakeDTO $dozvoleRDOznakes
     * @param int $iDDozvola
     * @param float $kapacitetOdlagalistaM
     * @param string $klasifikacijskaOznaka
     * @param float $kolicinaNeopasnogOtpadaT
     * @param float $kolicinaOpasnogOtpadaT
     * @param float $kolicinaOtpadaM
     * @param float $kolicinaOtpadaT
     * @param int $lokacijaID
     * @param int $pFOOsobaID
     * @param string $redgoDozvolaID
     * @param int $statusZahtjevaID
     * @param int $tipZahtjevaID
     * @param string $urudžbeniBroj
     */
    public function __construct($datumIsteka = null, $datumIzvrsnosti = null, $datumKreiranja = null, $datumPravomocnosti = null, $datumPromjene = null, \ArrayType\ArrayOfDozvolaKBDTO $dozvolaKBs = null, $dozvolaSuglasnostID = null, \ArrayType\ArrayOfDozvolaZabraneDTO $dozvolaZabranes = null, \ArrayType\ArrayOfDozvoleKBRDKolicineDTO $dozvoleKBRDKolicines = null, \ArrayType\ArrayOfDozvoleRDOznakeDTO $dozvoleRDOznakes = null, $iDDozvola = null, $kapacitetOdlagalistaM = null, $klasifikacijskaOznaka = null, $kolicinaNeopasnogOtpadaT = null, $kolicinaOpasnogOtpadaT = null, $kolicinaOtpadaM = null, $kolicinaOtpadaT = null, $lokacijaID = null, $pFOOsobaID = null, $redgoDozvolaID = null, $statusZahtjevaID = null, $tipZahtjevaID = null, $urudžbeniBroj = null)
    {
        $this
            ->setDatumIsteka($datumIsteka)
            ->setDatumIzvrsnosti($datumIzvrsnosti)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPravomocnosti($datumPravomocnosti)
            ->setDatumPromjene($datumPromjene)
            ->setDozvolaKBs($dozvolaKBs)
            ->setDozvolaSuglasnostID($dozvolaSuglasnostID)
            ->setDozvolaZabranes($dozvolaZabranes)
            ->setDozvoleKBRDKolicines($dozvoleKBRDKolicines)
            ->setDozvoleRDOznakes($dozvoleRDOznakes)
            ->setIDDozvola($iDDozvola)
            ->setKapacitetOdlagalistaM($kapacitetOdlagalistaM)
            ->setKlasifikacijskaOznaka($klasifikacijskaOznaka)
            ->setKolicinaNeopasnogOtpadaT($kolicinaNeopasnogOtpadaT)
            ->setKolicinaOpasnogOtpadaT($kolicinaOpasnogOtpadaT)
            ->setKolicinaOtpadaM($kolicinaOtpadaM)
            ->setKolicinaOtpadaT($kolicinaOtpadaT)
            ->setLokacijaID($lokacijaID)
            ->setPFOOsobaID($pFOOsobaID)
            ->setRedgoDozvolaID($redgoDozvolaID)
            ->setStatusZahtjevaID($statusZahtjevaID)
            ->setTipZahtjevaID($tipZahtjevaID)
            ->setUrudžbeniBroj($urudžbeniBroj);
    }
    /**
     * Get DatumIsteka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumIsteka()
    {
        return isset($this->DatumIsteka) ? $this->DatumIsteka : null;
    }
    /**
     * Set DatumIsteka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumIsteka
     * @return \StructType\DozvolaDTO
     */
    public function setDatumIsteka($datumIsteka = null)
    {
        // validation for constraint: string
        if (!is_null($datumIsteka) && !is_string($datumIsteka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumIsteka, true), gettype($datumIsteka)), __LINE__);
        }
        if (is_null($datumIsteka) || (is_array($datumIsteka) && empty($datumIsteka))) {
            unset($this->DatumIsteka);
        } else {
            $this->DatumIsteka = $datumIsteka;
        }
        return $this;
    }
    /**
     * Get DatumIzvrsnosti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumIzvrsnosti()
    {
        return isset($this->DatumIzvrsnosti) ? $this->DatumIzvrsnosti : null;
    }
    /**
     * Set DatumIzvrsnosti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumIzvrsnosti
     * @return \StructType\DozvolaDTO
     */
    public function setDatumIzvrsnosti($datumIzvrsnosti = null)
    {
        // validation for constraint: string
        if (!is_null($datumIzvrsnosti) && !is_string($datumIzvrsnosti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumIzvrsnosti, true), gettype($datumIzvrsnosti)), __LINE__);
        }
        if (is_null($datumIzvrsnosti) || (is_array($datumIzvrsnosti) && empty($datumIzvrsnosti))) {
            unset($this->DatumIzvrsnosti);
        } else {
            $this->DatumIzvrsnosti = $datumIzvrsnosti;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return isset($this->DatumKreiranja) ? $this->DatumKreiranja : null;
    }
    /**
     * Set DatumKreiranja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumKreiranja
     * @return \StructType\DozvolaDTO
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        if (is_null($datumKreiranja) || (is_array($datumKreiranja) && empty($datumKreiranja))) {
            unset($this->DatumKreiranja);
        } else {
            $this->DatumKreiranja = $datumKreiranja;
        }
        return $this;
    }
    /**
     * Get DatumPravomocnosti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPravomocnosti()
    {
        return isset($this->DatumPravomocnosti) ? $this->DatumPravomocnosti : null;
    }
    /**
     * Set DatumPravomocnosti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPravomocnosti
     * @return \StructType\DozvolaDTO
     */
    public function setDatumPravomocnosti($datumPravomocnosti = null)
    {
        // validation for constraint: string
        if (!is_null($datumPravomocnosti) && !is_string($datumPravomocnosti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPravomocnosti, true), gettype($datumPravomocnosti)), __LINE__);
        }
        if (is_null($datumPravomocnosti) || (is_array($datumPravomocnosti) && empty($datumPravomocnosti))) {
            unset($this->DatumPravomocnosti);
        } else {
            $this->DatumPravomocnosti = $datumPravomocnosti;
        }
        return $this;
    }
    /**
     * Get DatumPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return isset($this->DatumPromjene) ? $this->DatumPromjene : null;
    }
    /**
     * Set DatumPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPromjene
     * @return \StructType\DozvolaDTO
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        if (is_null($datumPromjene) || (is_array($datumPromjene) && empty($datumPromjene))) {
            unset($this->DatumPromjene);
        } else {
            $this->DatumPromjene = $datumPromjene;
        }
        return $this;
    }
    /**
     * Get DozvolaKBs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDozvolaKBDTO|null
     */
    public function getDozvolaKBs()
    {
        return isset($this->DozvolaKBs) ? $this->DozvolaKBs : null;
    }
    /**
     * Set DozvolaKBs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDozvolaKBDTO $dozvolaKBs
     * @return \StructType\DozvolaDTO
     */
    public function setDozvolaKBs(\ArrayType\ArrayOfDozvolaKBDTO $dozvolaKBs = null)
    {
        if (is_null($dozvolaKBs) || (is_array($dozvolaKBs) && empty($dozvolaKBs))) {
            unset($this->DozvolaKBs);
        } else {
            $this->DozvolaKBs = $dozvolaKBs;
        }
        return $this;
    }
    /**
     * Get DozvolaSuglasnostID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDozvolaSuglasnostID()
    {
        return isset($this->DozvolaSuglasnostID) ? $this->DozvolaSuglasnostID : null;
    }
    /**
     * Set DozvolaSuglasnostID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dozvolaSuglasnostID
     * @return \StructType\DozvolaDTO
     */
    public function setDozvolaSuglasnostID($dozvolaSuglasnostID = null)
    {
        // validation for constraint: int
        if (!is_null($dozvolaSuglasnostID) && !(is_int($dozvolaSuglasnostID) || ctype_digit($dozvolaSuglasnostID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dozvolaSuglasnostID, true), gettype($dozvolaSuglasnostID)), __LINE__);
        }
        if (is_null($dozvolaSuglasnostID) || (is_array($dozvolaSuglasnostID) && empty($dozvolaSuglasnostID))) {
            unset($this->DozvolaSuglasnostID);
        } else {
            $this->DozvolaSuglasnostID = $dozvolaSuglasnostID;
        }
        return $this;
    }
    /**
     * Get DozvolaZabranes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDozvolaZabraneDTO|null
     */
    public function getDozvolaZabranes()
    {
        return isset($this->DozvolaZabranes) ? $this->DozvolaZabranes : null;
    }
    /**
     * Set DozvolaZabranes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDozvolaZabraneDTO $dozvolaZabranes
     * @return \StructType\DozvolaDTO
     */
    public function setDozvolaZabranes(\ArrayType\ArrayOfDozvolaZabraneDTO $dozvolaZabranes = null)
    {
        if (is_null($dozvolaZabranes) || (is_array($dozvolaZabranes) && empty($dozvolaZabranes))) {
            unset($this->DozvolaZabranes);
        } else {
            $this->DozvolaZabranes = $dozvolaZabranes;
        }
        return $this;
    }
    /**
     * Get DozvoleKBRDKolicines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDozvoleKBRDKolicineDTO|null
     */
    public function getDozvoleKBRDKolicines()
    {
        return isset($this->DozvoleKBRDKolicines) ? $this->DozvoleKBRDKolicines : null;
    }
    /**
     * Set DozvoleKBRDKolicines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDozvoleKBRDKolicineDTO $dozvoleKBRDKolicines
     * @return \StructType\DozvolaDTO
     */
    public function setDozvoleKBRDKolicines(\ArrayType\ArrayOfDozvoleKBRDKolicineDTO $dozvoleKBRDKolicines = null)
    {
        if (is_null($dozvoleKBRDKolicines) || (is_array($dozvoleKBRDKolicines) && empty($dozvoleKBRDKolicines))) {
            unset($this->DozvoleKBRDKolicines);
        } else {
            $this->DozvoleKBRDKolicines = $dozvoleKBRDKolicines;
        }
        return $this;
    }
    /**
     * Get DozvoleRDOznakes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDozvoleRDOznakeDTO|null
     */
    public function getDozvoleRDOznakes()
    {
        return isset($this->DozvoleRDOznakes) ? $this->DozvoleRDOznakes : null;
    }
    /**
     * Set DozvoleRDOznakes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDozvoleRDOznakeDTO $dozvoleRDOznakes
     * @return \StructType\DozvolaDTO
     */
    public function setDozvoleRDOznakes(\ArrayType\ArrayOfDozvoleRDOznakeDTO $dozvoleRDOznakes = null)
    {
        if (is_null($dozvoleRDOznakes) || (is_array($dozvoleRDOznakes) && empty($dozvoleRDOznakes))) {
            unset($this->DozvoleRDOznakes);
        } else {
            $this->DozvoleRDOznakes = $dozvoleRDOznakes;
        }
        return $this;
    }
    /**
     * Get IDDozvola value
     * @return int|null
     */
    public function getIDDozvola()
    {
        return $this->IDDozvola;
    }
    /**
     * Set IDDozvola value
     * @param int $iDDozvola
     * @return \StructType\DozvolaDTO
     */
    public function setIDDozvola($iDDozvola = null)
    {
        // validation for constraint: int
        if (!is_null($iDDozvola) && !(is_int($iDDozvola) || ctype_digit($iDDozvola))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDozvola, true), gettype($iDDozvola)), __LINE__);
        }
        $this->IDDozvola = $iDDozvola;
        return $this;
    }
    /**
     * Get KapacitetOdlagalistaM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKapacitetOdlagalistaM()
    {
        return isset($this->KapacitetOdlagalistaM) ? $this->KapacitetOdlagalistaM : null;
    }
    /**
     * Set KapacitetOdlagalistaM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kapacitetOdlagalistaM
     * @return \StructType\DozvolaDTO
     */
    public function setKapacitetOdlagalistaM($kapacitetOdlagalistaM = null)
    {
        // validation for constraint: float
        if (!is_null($kapacitetOdlagalistaM) && !(is_float($kapacitetOdlagalistaM) || is_numeric($kapacitetOdlagalistaM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kapacitetOdlagalistaM, true), gettype($kapacitetOdlagalistaM)), __LINE__);
        }
        if (is_null($kapacitetOdlagalistaM) || (is_array($kapacitetOdlagalistaM) && empty($kapacitetOdlagalistaM))) {
            unset($this->KapacitetOdlagalistaM);
        } else {
            $this->KapacitetOdlagalistaM = $kapacitetOdlagalistaM;
        }
        return $this;
    }
    /**
     * Get KlasifikacijskaOznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlasifikacijskaOznaka()
    {
        return isset($this->KlasifikacijskaOznaka) ? $this->KlasifikacijskaOznaka : null;
    }
    /**
     * Set KlasifikacijskaOznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klasifikacijskaOznaka
     * @return \StructType\DozvolaDTO
     */
    public function setKlasifikacijskaOznaka($klasifikacijskaOznaka = null)
    {
        // validation for constraint: string
        if (!is_null($klasifikacijskaOznaka) && !is_string($klasifikacijskaOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klasifikacijskaOznaka, true), gettype($klasifikacijskaOznaka)), __LINE__);
        }
        if (is_null($klasifikacijskaOznaka) || (is_array($klasifikacijskaOznaka) && empty($klasifikacijskaOznaka))) {
            unset($this->KlasifikacijskaOznaka);
        } else {
            $this->KlasifikacijskaOznaka = $klasifikacijskaOznaka;
        }
        return $this;
    }
    /**
     * Get KolicinaNeopasnogOtpadaT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKolicinaNeopasnogOtpadaT()
    {
        return isset($this->KolicinaNeopasnogOtpadaT) ? $this->KolicinaNeopasnogOtpadaT : null;
    }
    /**
     * Set KolicinaNeopasnogOtpadaT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kolicinaNeopasnogOtpadaT
     * @return \StructType\DozvolaDTO
     */
    public function setKolicinaNeopasnogOtpadaT($kolicinaNeopasnogOtpadaT = null)
    {
        // validation for constraint: float
        if (!is_null($kolicinaNeopasnogOtpadaT) && !(is_float($kolicinaNeopasnogOtpadaT) || is_numeric($kolicinaNeopasnogOtpadaT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kolicinaNeopasnogOtpadaT, true), gettype($kolicinaNeopasnogOtpadaT)), __LINE__);
        }
        if (is_null($kolicinaNeopasnogOtpadaT) || (is_array($kolicinaNeopasnogOtpadaT) && empty($kolicinaNeopasnogOtpadaT))) {
            unset($this->KolicinaNeopasnogOtpadaT);
        } else {
            $this->KolicinaNeopasnogOtpadaT = $kolicinaNeopasnogOtpadaT;
        }
        return $this;
    }
    /**
     * Get KolicinaOpasnogOtpadaT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKolicinaOpasnogOtpadaT()
    {
        return isset($this->KolicinaOpasnogOtpadaT) ? $this->KolicinaOpasnogOtpadaT : null;
    }
    /**
     * Set KolicinaOpasnogOtpadaT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kolicinaOpasnogOtpadaT
     * @return \StructType\DozvolaDTO
     */
    public function setKolicinaOpasnogOtpadaT($kolicinaOpasnogOtpadaT = null)
    {
        // validation for constraint: float
        if (!is_null($kolicinaOpasnogOtpadaT) && !(is_float($kolicinaOpasnogOtpadaT) || is_numeric($kolicinaOpasnogOtpadaT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kolicinaOpasnogOtpadaT, true), gettype($kolicinaOpasnogOtpadaT)), __LINE__);
        }
        if (is_null($kolicinaOpasnogOtpadaT) || (is_array($kolicinaOpasnogOtpadaT) && empty($kolicinaOpasnogOtpadaT))) {
            unset($this->KolicinaOpasnogOtpadaT);
        } else {
            $this->KolicinaOpasnogOtpadaT = $kolicinaOpasnogOtpadaT;
        }
        return $this;
    }
    /**
     * Get KolicinaOtpadaM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKolicinaOtpadaM()
    {
        return isset($this->KolicinaOtpadaM) ? $this->KolicinaOtpadaM : null;
    }
    /**
     * Set KolicinaOtpadaM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kolicinaOtpadaM
     * @return \StructType\DozvolaDTO
     */
    public function setKolicinaOtpadaM($kolicinaOtpadaM = null)
    {
        // validation for constraint: float
        if (!is_null($kolicinaOtpadaM) && !(is_float($kolicinaOtpadaM) || is_numeric($kolicinaOtpadaM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kolicinaOtpadaM, true), gettype($kolicinaOtpadaM)), __LINE__);
        }
        if (is_null($kolicinaOtpadaM) || (is_array($kolicinaOtpadaM) && empty($kolicinaOtpadaM))) {
            unset($this->KolicinaOtpadaM);
        } else {
            $this->KolicinaOtpadaM = $kolicinaOtpadaM;
        }
        return $this;
    }
    /**
     * Get KolicinaOtpadaT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKolicinaOtpadaT()
    {
        return isset($this->KolicinaOtpadaT) ? $this->KolicinaOtpadaT : null;
    }
    /**
     * Set KolicinaOtpadaT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kolicinaOtpadaT
     * @return \StructType\DozvolaDTO
     */
    public function setKolicinaOtpadaT($kolicinaOtpadaT = null)
    {
        // validation for constraint: float
        if (!is_null($kolicinaOtpadaT) && !(is_float($kolicinaOtpadaT) || is_numeric($kolicinaOtpadaT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kolicinaOtpadaT, true), gettype($kolicinaOtpadaT)), __LINE__);
        }
        if (is_null($kolicinaOtpadaT) || (is_array($kolicinaOtpadaT) && empty($kolicinaOtpadaT))) {
            unset($this->KolicinaOtpadaT);
        } else {
            $this->KolicinaOtpadaT = $kolicinaOtpadaT;
        }
        return $this;
    }
    /**
     * Get LokacijaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaID()
    {
        return isset($this->LokacijaID) ? $this->LokacijaID : null;
    }
    /**
     * Set LokacijaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaID
     * @return \StructType\DozvolaDTO
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        if (is_null($lokacijaID) || (is_array($lokacijaID) && empty($lokacijaID))) {
            unset($this->LokacijaID);
        } else {
            $this->LokacijaID = $lokacijaID;
        }
        return $this;
    }
    /**
     * Get PFOOsobaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPFOOsobaID()
    {
        return isset($this->PFOOsobaID) ? $this->PFOOsobaID : null;
    }
    /**
     * Set PFOOsobaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pFOOsobaID
     * @return \StructType\DozvolaDTO
     */
    public function setPFOOsobaID($pFOOsobaID = null)
    {
        // validation for constraint: int
        if (!is_null($pFOOsobaID) && !(is_int($pFOOsobaID) || ctype_digit($pFOOsobaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOOsobaID, true), gettype($pFOOsobaID)), __LINE__);
        }
        if (is_null($pFOOsobaID) || (is_array($pFOOsobaID) && empty($pFOOsobaID))) {
            unset($this->PFOOsobaID);
        } else {
            $this->PFOOsobaID = $pFOOsobaID;
        }
        return $this;
    }
    /**
     * Get RedgoDozvolaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRedgoDozvolaID()
    {
        return isset($this->RedgoDozvolaID) ? $this->RedgoDozvolaID : null;
    }
    /**
     * Set RedgoDozvolaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $redgoDozvolaID
     * @return \StructType\DozvolaDTO
     */
    public function setRedgoDozvolaID($redgoDozvolaID = null)
    {
        // validation for constraint: string
        if (!is_null($redgoDozvolaID) && !is_string($redgoDozvolaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redgoDozvolaID, true), gettype($redgoDozvolaID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($redgoDozvolaID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $redgoDozvolaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($redgoDozvolaID, true)), __LINE__);
        }
        if (is_null($redgoDozvolaID) || (is_array($redgoDozvolaID) && empty($redgoDozvolaID))) {
            unset($this->RedgoDozvolaID);
        } else {
            $this->RedgoDozvolaID = $redgoDozvolaID;
        }
        return $this;
    }
    /**
     * Get StatusZahtjevaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStatusZahtjevaID()
    {
        return isset($this->StatusZahtjevaID) ? $this->StatusZahtjevaID : null;
    }
    /**
     * Set StatusZahtjevaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $statusZahtjevaID
     * @return \StructType\DozvolaDTO
     */
    public function setStatusZahtjevaID($statusZahtjevaID = null)
    {
        // validation for constraint: int
        if (!is_null($statusZahtjevaID) && !(is_int($statusZahtjevaID) || ctype_digit($statusZahtjevaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusZahtjevaID, true), gettype($statusZahtjevaID)), __LINE__);
        }
        if (is_null($statusZahtjevaID) || (is_array($statusZahtjevaID) && empty($statusZahtjevaID))) {
            unset($this->StatusZahtjevaID);
        } else {
            $this->StatusZahtjevaID = $statusZahtjevaID;
        }
        return $this;
    }
    /**
     * Get TipZahtjevaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTipZahtjevaID()
    {
        return isset($this->TipZahtjevaID) ? $this->TipZahtjevaID : null;
    }
    /**
     * Set TipZahtjevaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tipZahtjevaID
     * @return \StructType\DozvolaDTO
     */
    public function setTipZahtjevaID($tipZahtjevaID = null)
    {
        // validation for constraint: int
        if (!is_null($tipZahtjevaID) && !(is_int($tipZahtjevaID) || ctype_digit($tipZahtjevaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipZahtjevaID, true), gettype($tipZahtjevaID)), __LINE__);
        }
        if (is_null($tipZahtjevaID) || (is_array($tipZahtjevaID) && empty($tipZahtjevaID))) {
            unset($this->TipZahtjevaID);
        } else {
            $this->TipZahtjevaID = $tipZahtjevaID;
        }
        return $this;
    }
    /**
     * Get UrudžbeniBroj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrudžbeniBroj()
    {
        return isset($this->UrudžbeniBroj) ? $this->UrudžbeniBroj : null;
    }
    /**
     * Set UrudžbeniBroj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urudžbeniBroj
     * @return \StructType\DozvolaDTO
     */
    public function setUrudžbeniBroj($urudžbeniBroj = null)
    {
        // validation for constraint: string
        if (!is_null($urudžbeniBroj) && !is_string($urudžbeniBroj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urudžbeniBroj, true), gettype($urudžbeniBroj)), __LINE__);
        }
        if (is_null($urudžbeniBroj) || (is_array($urudžbeniBroj) && empty($urudžbeniBroj))) {
            unset($this->UrudžbeniBroj);
        } else {
            $this->UrudžbeniBroj = $urudžbeniBroj;
        }
        return $this;
    }
}
