<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLokacija StructType
 * @subpackage Structs
 */
class GetLokacija extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * The lokacijaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lokacijaID;
    /**
     * The lokacijaProdavateljaOtpada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $lokacijaProdavateljaOtpada;
    /**
     * Constructor method for GetLokacija
     * @uses GetLokacija::setUsername()
     * @uses GetLokacija::setSecurityToken()
     * @uses GetLokacija::setLokacijaID()
     * @uses GetLokacija::setLokacijaProdavateljaOtpada()
     * @param string $username
     * @param string $securityToken
     * @param int $lokacijaID
     * @param bool $lokacijaProdavateljaOtpada
     */
    public function __construct($username = null, $securityToken = null, $lokacijaID = null, $lokacijaProdavateljaOtpada = null)
    {
        $this
            ->setUsername($username)
            ->setSecurityToken($securityToken)
            ->setLokacijaID($lokacijaID)
            ->setLokacijaProdavateljaOtpada($lokacijaProdavateljaOtpada);
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\GetLokacija
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\GetLokacija
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
    /**
     * Get lokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->lokacijaID;
    }
    /**
     * Set lokacijaID value
     * @param int $lokacijaID
     * @return \StructType\GetLokacija
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !is_numeric($lokacijaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lokacijaID)), __LINE__);
        }
        $this->lokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get lokacijaProdavateljaOtpada value
     * @return bool|null
     */
    public function getLokacijaProdavateljaOtpada()
    {
        return $this->lokacijaProdavateljaOtpada;
    }
    /**
     * Set lokacijaProdavateljaOtpada value
     * @param bool $lokacijaProdavateljaOtpada
     * @return \StructType\GetLokacija
     */
    public function setLokacijaProdavateljaOtpada($lokacijaProdavateljaOtpada = null)
    {
        // validation for constraint: boolean
        if (!is_null($lokacijaProdavateljaOtpada) && !is_bool($lokacijaProdavateljaOtpada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lokacijaProdavateljaOtpada)), __LINE__);
        }
        $this->lokacijaProdavateljaOtpada = $lokacijaProdavateljaOtpada;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLokacija
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
