<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DokumentInput StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DokumentInput
 * @subpackage Structs
 */
class DokumentInput extends AbstractStructBase
{
    /**
     * The Datoteka
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Datoteka;
    /**
     * The Datum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Datum;
    /**
     * The KategorijeDokumentaList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint_1
     */
    public $KategorijeDokumentaList;
    /**
     * The Naziv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Opis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * Constructor method for DokumentInput
     * @uses DokumentInput::setDatoteka()
     * @uses DokumentInput::setDatum()
     * @uses DokumentInput::setKategorijeDokumentaList()
     * @uses DokumentInput::setNaziv()
     * @uses DokumentInput::setOpis()
     * @param string $datoteka
     * @param string $datum
     * @param \ArrayType\ArrayOfint_1 $kategorijeDokumentaList
     * @param string $naziv
     * @param string $opis
     */
    public function __construct($datoteka = null, $datum = null, \ArrayType\ArrayOfint_1 $kategorijeDokumentaList = null, $naziv = null, $opis = null)
    {
        $this
            ->setDatoteka($datoteka)
            ->setDatum($datum)
            ->setKategorijeDokumentaList($kategorijeDokumentaList)
            ->setNaziv($naziv)
            ->setOpis($opis);
    }
    /**
     * Get Datoteka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatoteka()
    {
        return isset($this->Datoteka) ? $this->Datoteka : null;
    }
    /**
     * Set Datoteka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datoteka
     * @return \StructType\DokumentInput
     */
    public function setDatoteka($datoteka = null)
    {
        // validation for constraint: string
        if (!is_null($datoteka) && !is_string($datoteka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datoteka)), __LINE__);
        }
        if (is_null($datoteka) || (is_array($datoteka) && empty($datoteka))) {
            unset($this->Datoteka);
        } else {
            $this->Datoteka = $datoteka;
        }
        return $this;
    }
    /**
     * Get Datum value
     * @return string|null
     */
    public function getDatum()
    {
        return $this->Datum;
    }
    /**
     * Set Datum value
     * @param string $datum
     * @return \StructType\DokumentInput
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datum)), __LINE__);
        }
        $this->Datum = $datum;
        return $this;
    }
    /**
     * Get KategorijeDokumentaList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint_1|null
     */
    public function getKategorijeDokumentaList()
    {
        return isset($this->KategorijeDokumentaList) ? $this->KategorijeDokumentaList : null;
    }
    /**
     * Set KategorijeDokumentaList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint_1 $kategorijeDokumentaList
     * @return \StructType\DokumentInput
     */
    public function setKategorijeDokumentaList(\ArrayType\ArrayOfint_1 $kategorijeDokumentaList = null)
    {
        if (is_null($kategorijeDokumentaList) || (is_array($kategorijeDokumentaList) && empty($kategorijeDokumentaList))) {
            unset($this->KategorijeDokumentaList);
        } else {
            $this->KategorijeDokumentaList = $kategorijeDokumentaList;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\DokumentInput
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\DokumentInput
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DokumentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
