<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DokumentResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DokumentResult
 * @subpackage Structs
 */
class DokumentResult extends AbstractStructBase
{
    /**
     * The Datoteka
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Datoteka;
    /**
     * The DatumKreiranja
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumNastanka
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumNastanka;
    /**
     * The DokumentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DokumentID;
    /**
     * The KategorijeDokumenta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint_1
     */
    public $KategorijeDokumenta;
    /**
     * The Kreirao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The NazivDokumenta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivDokumenta;
    /**
     * The Opis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * The TipDatoteke
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipDatoteke;
    /**
     * Constructor method for DokumentResult
     * @uses DokumentResult::setDatoteka()
     * @uses DokumentResult::setDatumKreiranja()
     * @uses DokumentResult::setDatumNastanka()
     * @uses DokumentResult::setDokumentID()
     * @uses DokumentResult::setKategorijeDokumenta()
     * @uses DokumentResult::setKreirao()
     * @uses DokumentResult::setNazivDokumenta()
     * @uses DokumentResult::setOpis()
     * @uses DokumentResult::setTipDatoteke()
     * @param string $datoteka
     * @param string $datumKreiranja
     * @param string $datumNastanka
     * @param int $dokumentID
     * @param \ArrayType\ArrayOfint_1 $kategorijeDokumenta
     * @param string $kreirao
     * @param string $nazivDokumenta
     * @param string $opis
     * @param string $tipDatoteke
     */
    public function __construct($datoteka = null, $datumKreiranja = null, $datumNastanka = null, $dokumentID = null, \ArrayType\ArrayOfint_1 $kategorijeDokumenta = null, $kreirao = null, $nazivDokumenta = null, $opis = null, $tipDatoteke = null)
    {
        $this
            ->setDatoteka($datoteka)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumNastanka($datumNastanka)
            ->setDokumentID($dokumentID)
            ->setKategorijeDokumenta($kategorijeDokumenta)
            ->setKreirao($kreirao)
            ->setNazivDokumenta($nazivDokumenta)
            ->setOpis($opis)
            ->setTipDatoteke($tipDatoteke);
    }
    /**
     * Get Datoteka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatoteka()
    {
        return isset($this->Datoteka) ? $this->Datoteka : null;
    }
    /**
     * Set Datoteka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datoteka
     * @return \StructType\DokumentResult
     */
    public function setDatoteka($datoteka = null)
    {
        // validation for constraint: string
        if (!is_null($datoteka) && !is_string($datoteka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datoteka)), __LINE__);
        }
        if (is_null($datoteka) || (is_array($datoteka) && empty($datoteka))) {
            unset($this->Datoteka);
        } else {
            $this->Datoteka = $datoteka;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\DokumentResult
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumNastanka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumNastanka()
    {
        return isset($this->DatumNastanka) ? $this->DatumNastanka : null;
    }
    /**
     * Set DatumNastanka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumNastanka
     * @return \StructType\DokumentResult
     */
    public function setDatumNastanka($datumNastanka = null)
    {
        // validation for constraint: string
        if (!is_null($datumNastanka) && !is_string($datumNastanka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumNastanka)), __LINE__);
        }
        if (is_null($datumNastanka) || (is_array($datumNastanka) && empty($datumNastanka))) {
            unset($this->DatumNastanka);
        } else {
            $this->DatumNastanka = $datumNastanka;
        }
        return $this;
    }
    /**
     * Get DokumentID value
     * @return int|null
     */
    public function getDokumentID()
    {
        return $this->DokumentID;
    }
    /**
     * Set DokumentID value
     * @param int $dokumentID
     * @return \StructType\DokumentResult
     */
    public function setDokumentID($dokumentID = null)
    {
        // validation for constraint: int
        if (!is_null($dokumentID) && !is_numeric($dokumentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dokumentID)), __LINE__);
        }
        $this->DokumentID = $dokumentID;
        return $this;
    }
    /**
     * Get KategorijeDokumenta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint_1|null
     */
    public function getKategorijeDokumenta()
    {
        return isset($this->KategorijeDokumenta) ? $this->KategorijeDokumenta : null;
    }
    /**
     * Set KategorijeDokumenta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint_1 $kategorijeDokumenta
     * @return \StructType\DokumentResult
     */
    public function setKategorijeDokumenta(\ArrayType\ArrayOfint_1 $kategorijeDokumenta = null)
    {
        if (is_null($kategorijeDokumenta) || (is_array($kategorijeDokumenta) && empty($kategorijeDokumenta))) {
            unset($this->KategorijeDokumenta);
        } else {
            $this->KategorijeDokumenta = $kategorijeDokumenta;
        }
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\DokumentResult
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get NazivDokumenta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivDokumenta()
    {
        return isset($this->NazivDokumenta) ? $this->NazivDokumenta : null;
    }
    /**
     * Set NazivDokumenta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivDokumenta
     * @return \StructType\DokumentResult
     */
    public function setNazivDokumenta($nazivDokumenta = null)
    {
        // validation for constraint: string
        if (!is_null($nazivDokumenta) && !is_string($nazivDokumenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nazivDokumenta)), __LINE__);
        }
        if (is_null($nazivDokumenta) || (is_array($nazivDokumenta) && empty($nazivDokumenta))) {
            unset($this->NazivDokumenta);
        } else {
            $this->NazivDokumenta = $nazivDokumenta;
        }
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\DokumentResult
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Get TipDatoteke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipDatoteke()
    {
        return isset($this->TipDatoteke) ? $this->TipDatoteke : null;
    }
    /**
     * Set TipDatoteke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipDatoteke
     * @return \StructType\DokumentResult
     */
    public function setTipDatoteke($tipDatoteke = null)
    {
        // validation for constraint: string
        if (!is_null($tipDatoteke) && !is_string($tipDatoteke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipDatoteke)), __LINE__);
        }
        if (is_null($tipDatoteke) || (is_array($tipDatoteke) && empty($tipDatoteke))) {
            unset($this->TipDatoteke);
        } else {
            $this->TipDatoteke = $tipDatoteke;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DokumentResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
