<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrateciListInput StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PrateciListInput
 * @subpackage Structs
 */
class PrateciListInput extends AbstractStructBase
{
    /**
     * The CustomERPIDPredavatelja
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomERPIDPredavatelja;
    /**
     * The CustomERPIDPreuzimatelja
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomERPIDPreuzimatelja;
    /**
     * The CustomERPIDPrijevoznika
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomERPIDPrijevoznika;
    /**
     * The DatumPredaje
     * @var string
     */
    public $DatumPredaje;
    /**
     * The DatumPreuzimanja
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPreuzimanja;
    /**
     * The KontaktOsobaPredavatelja
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $KontaktOsobaPredavatelja;
    /**
     * The KontaktOsobaPreuzimatelja
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KontaktOsobaPreuzimatelja;
    /**
     * The KontaktOsobaPrijevoznika
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KontaktOsobaPrijevoznika;
    /**
     * The KontaktPodaciPredavatelja
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $KontaktPodaciPredavatelja;
    /**
     * The KontaktPodaciPreuzimatelja
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KontaktPodaciPreuzimatelja;
    /**
     * The KontaktPodaciPrijevoznika
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KontaktPodaciPrijevoznika;
    /**
     * The LokacijaOdredistaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaOdredistaID;
    /**
     * The LokacijaPolazistaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaPolazistaID;
    /**
     * The MRDOznakaId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MRDOznakaId;
    /**
     * The NacinPrijevozaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NacinPrijevozaID;
    /**
     * The OdgovornaOsobaPredavatelja
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OdgovornaOsobaPredavatelja;
    /**
     * The OdgovornaOsobaPreuzimatelja
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdgovornaOsobaPreuzimatelja;
    /**
     * The OvlastPreuzimanjeOtpadaUPosjed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OvlastPreuzimanjeOtpadaUPosjed;
    /**
     * The OznakaPosebneKategorijeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OznakaPosebneKategorijeID;
    /**
     * The PrateciListID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrateciListID;
    /**
     * The Predavatelj
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\PravnaOsobaObrt
     */
    public $Predavatelj;
    /**
     * The PredavateljNKDID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PredavateljNKDID;
    /**
     * The Preuzimatelj
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\PravnaOsobaObrt
     */
    public $Preuzimatelj;
    /**
     * The Prijevoznik
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\PravnaOsobaObrt
     */
    public $Prijevoznik;
    /**
     * The PrijevoznikBrojOcevidnika
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrijevoznikBrojOcevidnika;
    /**
     * The PrijevoznikPreuzeo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrijevoznikPreuzeo;
    /**
     * The RegistarskaOznaka
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistarskaOznaka;
    /**
     * The SpremniciNaJavnojPovrsini
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpremniciNaJavnojPovrsini;
    /**
     * The VrstaDjelatnostiPredavateljId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VrstaDjelatnostiPredavateljId;
    /**
     * The VrstaDjelatnostiPreuzimateljId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VrstaDjelatnostiPreuzimateljId;
    /**
     * The VrstaDjelatnostiPrijevoznikId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VrstaDjelatnostiPrijevoznikId;
    /**
     * The KljucniBrojOtpadaID
     * @var int
     */
    public $KljucniBrojOtpadaID;
    /**
     * The KolicinaOtpadaKG
     * @var float
     */
    public $KolicinaOtpadaKG;
    /**
     * The KolicinaOtpadaM3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KolicinaOtpadaM3;
    /**
     * The NacinOdredivanjaMaseID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NacinOdredivanjaMaseID;
    /**
     * The FizikalnoSvojstvoOtpadaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FizikalnoSvojstvoOtpadaID;
    /**
     * The FizikalnoSvojstvoOtpadaOstalo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FizikalnoSvojstvoOtpadaOstalo;
    /**
     * The TipOtpadaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipOtpadaID;
    /**
     * The OznakeH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint_1
     */
    public $OznakeH;
    /**
     * The PorijeklaOtpada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNaseljeJLSZupanijaPostotak
     */
    public $PorijeklaOtpada;
    /**
     * The OpisOtpada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpisOtpada;
    /**
     * The NamjenaPosiljkeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NamjenaPosiljkeID;
    /**
     * The NacinPakiranjaOtpadaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NacinPakiranjaOtpadaID;
    /**
     * The BrojPakiranja
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $BrojPakiranja;
    /**
     * The Napomena
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Napomena;
    /**
     * Constructor method for PrateciListInput
     * @uses PrateciListInput::setCustomERPIDPredavatelja()
     * @uses PrateciListInput::setCustomERPIDPreuzimatelja()
     * @uses PrateciListInput::setCustomERPIDPrijevoznika()
     * @uses PrateciListInput::setDatumPredaje()
     * @uses PrateciListInput::setDatumPreuzimanja()
     * @uses PrateciListInput::setKontaktOsobaPredavatelja()
     * @uses PrateciListInput::setKontaktOsobaPreuzimatelja()
     * @uses PrateciListInput::setKontaktOsobaPrijevoznika()
     * @uses PrateciListInput::setKontaktPodaciPredavatelja()
     * @uses PrateciListInput::setKontaktPodaciPreuzimatelja()
     * @uses PrateciListInput::setKontaktPodaciPrijevoznika()
     * @uses PrateciListInput::setLokacijaOdredistaID()
     * @uses PrateciListInput::setLokacijaPolazistaID()
     * @uses PrateciListInput::setMRDOznakaId()
     * @uses PrateciListInput::setNacinPrijevozaID()
     * @uses PrateciListInput::setOdgovornaOsobaPredavatelja()
     * @uses PrateciListInput::setOdgovornaOsobaPreuzimatelja()
     * @uses PrateciListInput::setOvlastPreuzimanjeOtpadaUPosjed()
     * @uses PrateciListInput::setOznakaPosebneKategorijeID()
     * @uses PrateciListInput::setPrateciListID()
     * @uses PrateciListInput::setPredavatelj()
     * @uses PrateciListInput::setPredavateljNKDID()
     * @uses PrateciListInput::setPreuzimatelj()
     * @uses PrateciListInput::setPrijevoznik()
     * @uses PrateciListInput::setPrijevoznikBrojOcevidnika()
     * @uses PrateciListInput::setPrijevoznikPreuzeo()
     * @uses PrateciListInput::setRegistarskaOznaka()
     * @uses PrateciListInput::setSpremniciNaJavnojPovrsini()
     * @uses PrateciListInput::setVrstaDjelatnostiPredavateljId()
     * @uses PrateciListInput::setVrstaDjelatnostiPreuzimateljId()
     * @uses PrateciListInput::setVrstaDjelatnostiPrijevoznikId()
     * @uses PrateciListInput::setKljucniBrojOtpadaID()
     * @uses PrateciListInput::setKolicinaOtpadaKG()
     * @uses PrateciListInput::setKolicinaOtpadaM3()
     * @uses PrateciListInput::setNacinOdredivanjaMaseID()
     * @uses PrateciListInput::setFizikalnoSvojstvoOtpadaID()
     * @uses PrateciListInput::setFizikalnoSvojstvoOtpadaOstalo()
     * @uses PrateciListInput::setTipOtpadaID()
     * @uses PrateciListInput::setOznakeH()
     * @uses PrateciListInput::setPorijeklaOtpada()
     * @uses PrateciListInput::setOpisOtpada()
     * @uses PrateciListInput::setNamjenaPosiljkeID()
     * @uses PrateciListInput::setNacinPakiranjaOtpadaID()
     * @uses PrateciListInput::setBrojPakiranja()
     * @uses PrateciListInput::setNapomena()
     * @param string $customERPIDPredavatelja
     * @param string $customERPIDPreuzimatelja
     * @param string $customERPIDPrijevoznika
     * @param string $datumPredaje
     * @param string $datumPreuzimanja
     * @param string $kontaktOsobaPredavatelja
     * @param string $kontaktOsobaPreuzimatelja
     * @param string $kontaktOsobaPrijevoznika
     * @param string $kontaktPodaciPredavatelja
     * @param string $kontaktPodaciPreuzimatelja
     * @param string $kontaktPodaciPrijevoznika
     * @param int $lokacijaOdredistaID
     * @param int $lokacijaPolazistaID
     * @param int $mRDOznakaId
     * @param int $nacinPrijevozaID
     * @param string $odgovornaOsobaPredavatelja
     * @param string $odgovornaOsobaPreuzimatelja
     * @param string $ovlastPreuzimanjeOtpadaUPosjed
     * @param int $oznakaPosebneKategorijeID
     * @param int $prateciListID
     * @param \StructType\PravnaOsobaObrt $predavatelj
     * @param int $predavateljNKDID
     * @param \StructType\PravnaOsobaObrt $preuzimatelj
     * @param \StructType\PravnaOsobaObrt $prijevoznik
     * @param string $prijevoznikBrojOcevidnika
     * @param string $prijevoznikPreuzeo
     * @param string $registarskaOznaka
     * @param bool $spremniciNaJavnojPovrsini
     * @param int $vrstaDjelatnostiPredavateljId
     * @param int $vrstaDjelatnostiPreuzimateljId
     * @param int $vrstaDjelatnostiPrijevoznikId
     * @param int $kljucniBrojOtpadaID
     * @param float $kolicinaOtpadaKG
     * @param float $kolicinaOtpadaM3
     * @param int $nacinOdredivanjaMaseID
     * @param int $fizikalnoSvojstvoOtpadaID
     * @param string $fizikalnoSvojstvoOtpadaOstalo
     * @param int $tipOtpadaID
     * @param \ArrayType\ArrayOfint_1 $oznakeH
     * @param \ArrayType\ArrayOfNaseljeJLSZupanijaPostotak $porijeklaOtpada
     * @param string $opisOtpada
     * @param int $namjenaPosiljkeID
     * @param int $nacinPakiranjaOtpadaID
     * @param int $brojPakiranja
     * @param string $napomena
     */
    public function __construct($customERPIDPredavatelja = null, $customERPIDPreuzimatelja = null, $customERPIDPrijevoznika = null, $datumPredaje = null, $datumPreuzimanja = null, $kontaktOsobaPredavatelja = null, $kontaktOsobaPreuzimatelja = null, $kontaktOsobaPrijevoznika = null, $kontaktPodaciPredavatelja = null, $kontaktPodaciPreuzimatelja = null, $kontaktPodaciPrijevoznika = null, $lokacijaOdredistaID = null, $lokacijaPolazistaID = null, $mRDOznakaId = null, $nacinPrijevozaID = null, $odgovornaOsobaPredavatelja = null, $odgovornaOsobaPreuzimatelja = null, $ovlastPreuzimanjeOtpadaUPosjed = null, $oznakaPosebneKategorijeID = null, $prateciListID = null, \StructType\PravnaOsobaObrt $predavatelj = null, $predavateljNKDID = null, \StructType\PravnaOsobaObrt $preuzimatelj = null, \StructType\PravnaOsobaObrt $prijevoznik = null, $prijevoznikBrojOcevidnika = null, $prijevoznikPreuzeo = null, $registarskaOznaka = null, $spremniciNaJavnojPovrsini = null, $vrstaDjelatnostiPredavateljId = null, $vrstaDjelatnostiPreuzimateljId = null, $vrstaDjelatnostiPrijevoznikId = null, $kljucniBrojOtpadaID = null, $kolicinaOtpadaKG = null, $kolicinaOtpadaM3 = null, $nacinOdredivanjaMaseID = null, $fizikalnoSvojstvoOtpadaID = null, $fizikalnoSvojstvoOtpadaOstalo = null, $tipOtpadaID = null, \ArrayType\ArrayOfint_1 $oznakeH = null, \ArrayType\ArrayOfNaseljeJLSZupanijaPostotak $porijeklaOtpada = null, $opisOtpada = null, $namjenaPosiljkeID = null, $nacinPakiranjaOtpadaID = null, $brojPakiranja = null, $napomena = null)
    {
        $this
            ->setCustomERPIDPredavatelja($customERPIDPredavatelja)
            ->setCustomERPIDPreuzimatelja($customERPIDPreuzimatelja)
            ->setCustomERPIDPrijevoznika($customERPIDPrijevoznika)
            ->setDatumPredaje($datumPredaje)
            ->setDatumPreuzimanja($datumPreuzimanja)
            ->setKontaktOsobaPredavatelja($kontaktOsobaPredavatelja)
            ->setKontaktOsobaPreuzimatelja($kontaktOsobaPreuzimatelja)
            ->setKontaktOsobaPrijevoznika($kontaktOsobaPrijevoznika)
            ->setKontaktPodaciPredavatelja($kontaktPodaciPredavatelja)
            ->setKontaktPodaciPreuzimatelja($kontaktPodaciPreuzimatelja)
            ->setKontaktPodaciPrijevoznika($kontaktPodaciPrijevoznika)
            ->setLokacijaOdredistaID($lokacijaOdredistaID)
            ->setLokacijaPolazistaID($lokacijaPolazistaID)
            ->setMRDOznakaId($mRDOznakaId)
            ->setNacinPrijevozaID($nacinPrijevozaID)
            ->setOdgovornaOsobaPredavatelja($odgovornaOsobaPredavatelja)
            ->setOdgovornaOsobaPreuzimatelja($odgovornaOsobaPreuzimatelja)
            ->setOvlastPreuzimanjeOtpadaUPosjed($ovlastPreuzimanjeOtpadaUPosjed)
            ->setOznakaPosebneKategorijeID($oznakaPosebneKategorijeID)
            ->setPrateciListID($prateciListID)
            ->setPredavatelj($predavatelj)
            ->setPredavateljNKDID($predavateljNKDID)
            ->setPreuzimatelj($preuzimatelj)
            ->setPrijevoznik($prijevoznik)
            ->setPrijevoznikBrojOcevidnika($prijevoznikBrojOcevidnika)
            ->setPrijevoznikPreuzeo($prijevoznikPreuzeo)
            ->setRegistarskaOznaka($registarskaOznaka)
            ->setSpremniciNaJavnojPovrsini($spremniciNaJavnojPovrsini)
            ->setVrstaDjelatnostiPredavateljId($vrstaDjelatnostiPredavateljId)
            ->setVrstaDjelatnostiPreuzimateljId($vrstaDjelatnostiPreuzimateljId)
            ->setVrstaDjelatnostiPrijevoznikId($vrstaDjelatnostiPrijevoznikId)
            ->setKljucniBrojOtpadaID($kljucniBrojOtpadaID)
            ->setKolicinaOtpadaKG($kolicinaOtpadaKG)
            ->setKolicinaOtpadaM3($kolicinaOtpadaM3)
            ->setNacinOdredivanjaMaseID($nacinOdredivanjaMaseID)
            ->setFizikalnoSvojstvoOtpadaID($fizikalnoSvojstvoOtpadaID)
            ->setFizikalnoSvojstvoOtpadaOstalo($fizikalnoSvojstvoOtpadaOstalo)
            ->setTipOtpadaID($tipOtpadaID)
            ->setOznakeH($oznakeH)
            ->setPorijeklaOtpada($porijeklaOtpada)
            ->setOpisOtpada($opisOtpada)
            ->setNamjenaPosiljkeID($namjenaPosiljkeID)
            ->setNacinPakiranjaOtpadaID($nacinPakiranjaOtpadaID)
            ->setBrojPakiranja($brojPakiranja)
            ->setNapomena($napomena);
    }
    /**
     * Get CustomERPIDPredavatelja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomERPIDPredavatelja()
    {
        return isset($this->CustomERPIDPredavatelja) ? $this->CustomERPIDPredavatelja : null;
    }
    /**
     * Set CustomERPIDPredavatelja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customERPIDPredavatelja
     * @return \StructType\PrateciListInput
     */
    public function setCustomERPIDPredavatelja($customERPIDPredavatelja = null)
    {
        // validation for constraint: string
        if (!is_null($customERPIDPredavatelja) && !is_string($customERPIDPredavatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customERPIDPredavatelja)), __LINE__);
        }
        if (is_null($customERPIDPredavatelja) || (is_array($customERPIDPredavatelja) && empty($customERPIDPredavatelja))) {
            unset($this->CustomERPIDPredavatelja);
        } else {
            $this->CustomERPIDPredavatelja = $customERPIDPredavatelja;
        }
        return $this;
    }
    /**
     * Get CustomERPIDPreuzimatelja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomERPIDPreuzimatelja()
    {
        return isset($this->CustomERPIDPreuzimatelja) ? $this->CustomERPIDPreuzimatelja : null;
    }
    /**
     * Set CustomERPIDPreuzimatelja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customERPIDPreuzimatelja
     * @return \StructType\PrateciListInput
     */
    public function setCustomERPIDPreuzimatelja($customERPIDPreuzimatelja = null)
    {
        // validation for constraint: string
        if (!is_null($customERPIDPreuzimatelja) && !is_string($customERPIDPreuzimatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customERPIDPreuzimatelja)), __LINE__);
        }
        if (is_null($customERPIDPreuzimatelja) || (is_array($customERPIDPreuzimatelja) && empty($customERPIDPreuzimatelja))) {
            unset($this->CustomERPIDPreuzimatelja);
        } else {
            $this->CustomERPIDPreuzimatelja = $customERPIDPreuzimatelja;
        }
        return $this;
    }
    /**
     * Get CustomERPIDPrijevoznika value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomERPIDPrijevoznika()
    {
        return isset($this->CustomERPIDPrijevoznika) ? $this->CustomERPIDPrijevoznika : null;
    }
    /**
     * Set CustomERPIDPrijevoznika value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customERPIDPrijevoznika
     * @return \StructType\PrateciListInput
     */
    public function setCustomERPIDPrijevoznika($customERPIDPrijevoznika = null)
    {
        // validation for constraint: string
        if (!is_null($customERPIDPrijevoznika) && !is_string($customERPIDPrijevoznika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customERPIDPrijevoznika)), __LINE__);
        }
        if (is_null($customERPIDPrijevoznika) || (is_array($customERPIDPrijevoznika) && empty($customERPIDPrijevoznika))) {
            unset($this->CustomERPIDPrijevoznika);
        } else {
            $this->CustomERPIDPrijevoznika = $customERPIDPrijevoznika;
        }
        return $this;
    }
    /**
     * Get DatumPredaje value
     * @return string|null
     */
    public function getDatumPredaje()
    {
        return $this->DatumPredaje;
    }
    /**
     * Set DatumPredaje value
     * @param string $datumPredaje
     * @return \StructType\PrateciListInput
     */
    public function setDatumPredaje($datumPredaje = null)
    {
        // validation for constraint: string
        if (!is_null($datumPredaje) && !is_string($datumPredaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumPredaje)), __LINE__);
        }
        $this->DatumPredaje = $datumPredaje;
        return $this;
    }
    /**
     * Get DatumPreuzimanja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPreuzimanja()
    {
        return isset($this->DatumPreuzimanja) ? $this->DatumPreuzimanja : null;
    }
    /**
     * Set DatumPreuzimanja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPreuzimanja
     * @return \StructType\PrateciListInput
     */
    public function setDatumPreuzimanja($datumPreuzimanja = null)
    {
        // validation for constraint: string
        if (!is_null($datumPreuzimanja) && !is_string($datumPreuzimanja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumPreuzimanja)), __LINE__);
        }
        if (is_null($datumPreuzimanja) || (is_array($datumPreuzimanja) && empty($datumPreuzimanja))) {
            unset($this->DatumPreuzimanja);
        } else {
            $this->DatumPreuzimanja = $datumPreuzimanja;
        }
        return $this;
    }
    /**
     * Get KontaktOsobaPredavatelja value
     * @return string|null
     */
    public function getKontaktOsobaPredavatelja()
    {
        return $this->KontaktOsobaPredavatelja;
    }
    /**
     * Set KontaktOsobaPredavatelja value
     * @param string $kontaktOsobaPredavatelja
     * @return \StructType\PrateciListInput
     */
    public function setKontaktOsobaPredavatelja($kontaktOsobaPredavatelja = null)
    {
        // validation for constraint: string
        if (!is_null($kontaktOsobaPredavatelja) && !is_string($kontaktOsobaPredavatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kontaktOsobaPredavatelja)), __LINE__);
        }
        $this->KontaktOsobaPredavatelja = $kontaktOsobaPredavatelja;
        return $this;
    }
    /**
     * Get KontaktOsobaPreuzimatelja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKontaktOsobaPreuzimatelja()
    {
        return isset($this->KontaktOsobaPreuzimatelja) ? $this->KontaktOsobaPreuzimatelja : null;
    }
    /**
     * Set KontaktOsobaPreuzimatelja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kontaktOsobaPreuzimatelja
     * @return \StructType\PrateciListInput
     */
    public function setKontaktOsobaPreuzimatelja($kontaktOsobaPreuzimatelja = null)
    {
        // validation for constraint: string
        if (!is_null($kontaktOsobaPreuzimatelja) && !is_string($kontaktOsobaPreuzimatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kontaktOsobaPreuzimatelja)), __LINE__);
        }
        if (is_null($kontaktOsobaPreuzimatelja) || (is_array($kontaktOsobaPreuzimatelja) && empty($kontaktOsobaPreuzimatelja))) {
            unset($this->KontaktOsobaPreuzimatelja);
        } else {
            $this->KontaktOsobaPreuzimatelja = $kontaktOsobaPreuzimatelja;
        }
        return $this;
    }
    /**
     * Get KontaktOsobaPrijevoznika value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKontaktOsobaPrijevoznika()
    {
        return isset($this->KontaktOsobaPrijevoznika) ? $this->KontaktOsobaPrijevoznika : null;
    }
    /**
     * Set KontaktOsobaPrijevoznika value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kontaktOsobaPrijevoznika
     * @return \StructType\PrateciListInput
     */
    public function setKontaktOsobaPrijevoznika($kontaktOsobaPrijevoznika = null)
    {
        // validation for constraint: string
        if (!is_null($kontaktOsobaPrijevoznika) && !is_string($kontaktOsobaPrijevoznika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kontaktOsobaPrijevoznika)), __LINE__);
        }
        if (is_null($kontaktOsobaPrijevoznika) || (is_array($kontaktOsobaPrijevoznika) && empty($kontaktOsobaPrijevoznika))) {
            unset($this->KontaktOsobaPrijevoznika);
        } else {
            $this->KontaktOsobaPrijevoznika = $kontaktOsobaPrijevoznika;
        }
        return $this;
    }
    /**
     * Get KontaktPodaciPredavatelja value
     * @return string|null
     */
    public function getKontaktPodaciPredavatelja()
    {
        return $this->KontaktPodaciPredavatelja;
    }
    /**
     * Set KontaktPodaciPredavatelja value
     * @param string $kontaktPodaciPredavatelja
     * @return \StructType\PrateciListInput
     */
    public function setKontaktPodaciPredavatelja($kontaktPodaciPredavatelja = null)
    {
        // validation for constraint: string
        if (!is_null($kontaktPodaciPredavatelja) && !is_string($kontaktPodaciPredavatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kontaktPodaciPredavatelja)), __LINE__);
        }
        $this->KontaktPodaciPredavatelja = $kontaktPodaciPredavatelja;
        return $this;
    }
    /**
     * Get KontaktPodaciPreuzimatelja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKontaktPodaciPreuzimatelja()
    {
        return isset($this->KontaktPodaciPreuzimatelja) ? $this->KontaktPodaciPreuzimatelja : null;
    }
    /**
     * Set KontaktPodaciPreuzimatelja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kontaktPodaciPreuzimatelja
     * @return \StructType\PrateciListInput
     */
    public function setKontaktPodaciPreuzimatelja($kontaktPodaciPreuzimatelja = null)
    {
        // validation for constraint: string
        if (!is_null($kontaktPodaciPreuzimatelja) && !is_string($kontaktPodaciPreuzimatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kontaktPodaciPreuzimatelja)), __LINE__);
        }
        if (is_null($kontaktPodaciPreuzimatelja) || (is_array($kontaktPodaciPreuzimatelja) && empty($kontaktPodaciPreuzimatelja))) {
            unset($this->KontaktPodaciPreuzimatelja);
        } else {
            $this->KontaktPodaciPreuzimatelja = $kontaktPodaciPreuzimatelja;
        }
        return $this;
    }
    /**
     * Get KontaktPodaciPrijevoznika value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKontaktPodaciPrijevoznika()
    {
        return isset($this->KontaktPodaciPrijevoznika) ? $this->KontaktPodaciPrijevoznika : null;
    }
    /**
     * Set KontaktPodaciPrijevoznika value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kontaktPodaciPrijevoznika
     * @return \StructType\PrateciListInput
     */
    public function setKontaktPodaciPrijevoznika($kontaktPodaciPrijevoznika = null)
    {
        // validation for constraint: string
        if (!is_null($kontaktPodaciPrijevoznika) && !is_string($kontaktPodaciPrijevoznika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kontaktPodaciPrijevoznika)), __LINE__);
        }
        if (is_null($kontaktPodaciPrijevoznika) || (is_array($kontaktPodaciPrijevoznika) && empty($kontaktPodaciPrijevoznika))) {
            unset($this->KontaktPodaciPrijevoznika);
        } else {
            $this->KontaktPodaciPrijevoznika = $kontaktPodaciPrijevoznika;
        }
        return $this;
    }
    /**
     * Get LokacijaOdredistaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaOdredistaID()
    {
        return isset($this->LokacijaOdredistaID) ? $this->LokacijaOdredistaID : null;
    }
    /**
     * Set LokacijaOdredistaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaOdredistaID
     * @return \StructType\PrateciListInput
     */
    public function setLokacijaOdredistaID($lokacijaOdredistaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaOdredistaID) && !is_numeric($lokacijaOdredistaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lokacijaOdredistaID)), __LINE__);
        }
        if (is_null($lokacijaOdredistaID) || (is_array($lokacijaOdredistaID) && empty($lokacijaOdredistaID))) {
            unset($this->LokacijaOdredistaID);
        } else {
            $this->LokacijaOdredistaID = $lokacijaOdredistaID;
        }
        return $this;
    }
    /**
     * Get LokacijaPolazistaID value
     * @return int|null
     */
    public function getLokacijaPolazistaID()
    {
        return $this->LokacijaPolazistaID;
    }
    /**
     * Set LokacijaPolazistaID value
     * @param int $lokacijaPolazistaID
     * @return \StructType\PrateciListInput
     */
    public function setLokacijaPolazistaID($lokacijaPolazistaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaPolazistaID) && !is_numeric($lokacijaPolazistaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lokacijaPolazistaID)), __LINE__);
        }
        $this->LokacijaPolazistaID = $lokacijaPolazistaID;
        return $this;
    }
    /**
     * Get MRDOznakaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMRDOznakaId()
    {
        return isset($this->MRDOznakaId) ? $this->MRDOznakaId : null;
    }
    /**
     * Set MRDOznakaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mRDOznakaId
     * @return \StructType\PrateciListInput
     */
    public function setMRDOznakaId($mRDOznakaId = null)
    {
        // validation for constraint: int
        if (!is_null($mRDOznakaId) && !is_numeric($mRDOznakaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mRDOznakaId)), __LINE__);
        }
        if (is_null($mRDOznakaId) || (is_array($mRDOznakaId) && empty($mRDOznakaId))) {
            unset($this->MRDOznakaId);
        } else {
            $this->MRDOznakaId = $mRDOznakaId;
        }
        return $this;
    }
    /**
     * Get NacinPrijevozaID value
     * @return int|null
     */
    public function getNacinPrijevozaID()
    {
        return $this->NacinPrijevozaID;
    }
    /**
     * Set NacinPrijevozaID value
     * @param int $nacinPrijevozaID
     * @return \StructType\PrateciListInput
     */
    public function setNacinPrijevozaID($nacinPrijevozaID = null)
    {
        // validation for constraint: int
        if (!is_null($nacinPrijevozaID) && !is_numeric($nacinPrijevozaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nacinPrijevozaID)), __LINE__);
        }
        $this->NacinPrijevozaID = $nacinPrijevozaID;
        return $this;
    }
    /**
     * Get OdgovornaOsobaPredavatelja value
     * @return string|null
     */
    public function getOdgovornaOsobaPredavatelja()
    {
        return $this->OdgovornaOsobaPredavatelja;
    }
    /**
     * Set OdgovornaOsobaPredavatelja value
     * @param string $odgovornaOsobaPredavatelja
     * @return \StructType\PrateciListInput
     */
    public function setOdgovornaOsobaPredavatelja($odgovornaOsobaPredavatelja = null)
    {
        // validation for constraint: string
        if (!is_null($odgovornaOsobaPredavatelja) && !is_string($odgovornaOsobaPredavatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($odgovornaOsobaPredavatelja)), __LINE__);
        }
        $this->OdgovornaOsobaPredavatelja = $odgovornaOsobaPredavatelja;
        return $this;
    }
    /**
     * Get OdgovornaOsobaPreuzimatelja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdgovornaOsobaPreuzimatelja()
    {
        return isset($this->OdgovornaOsobaPreuzimatelja) ? $this->OdgovornaOsobaPreuzimatelja : null;
    }
    /**
     * Set OdgovornaOsobaPreuzimatelja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odgovornaOsobaPreuzimatelja
     * @return \StructType\PrateciListInput
     */
    public function setOdgovornaOsobaPreuzimatelja($odgovornaOsobaPreuzimatelja = null)
    {
        // validation for constraint: string
        if (!is_null($odgovornaOsobaPreuzimatelja) && !is_string($odgovornaOsobaPreuzimatelja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($odgovornaOsobaPreuzimatelja)), __LINE__);
        }
        if (is_null($odgovornaOsobaPreuzimatelja) || (is_array($odgovornaOsobaPreuzimatelja) && empty($odgovornaOsobaPreuzimatelja))) {
            unset($this->OdgovornaOsobaPreuzimatelja);
        } else {
            $this->OdgovornaOsobaPreuzimatelja = $odgovornaOsobaPreuzimatelja;
        }
        return $this;
    }
    /**
     * Get OvlastPreuzimanjeOtpadaUPosjed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOvlastPreuzimanjeOtpadaUPosjed()
    {
        return isset($this->OvlastPreuzimanjeOtpadaUPosjed) ? $this->OvlastPreuzimanjeOtpadaUPosjed : null;
    }
    /**
     * Set OvlastPreuzimanjeOtpadaUPosjed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ovlastPreuzimanjeOtpadaUPosjed
     * @return \StructType\PrateciListInput
     */
    public function setOvlastPreuzimanjeOtpadaUPosjed($ovlastPreuzimanjeOtpadaUPosjed = null)
    {
        // validation for constraint: string
        if (!is_null($ovlastPreuzimanjeOtpadaUPosjed) && !is_string($ovlastPreuzimanjeOtpadaUPosjed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ovlastPreuzimanjeOtpadaUPosjed)), __LINE__);
        }
        if (is_null($ovlastPreuzimanjeOtpadaUPosjed) || (is_array($ovlastPreuzimanjeOtpadaUPosjed) && empty($ovlastPreuzimanjeOtpadaUPosjed))) {
            unset($this->OvlastPreuzimanjeOtpadaUPosjed);
        } else {
            $this->OvlastPreuzimanjeOtpadaUPosjed = $ovlastPreuzimanjeOtpadaUPosjed;
        }
        return $this;
    }
    /**
     * Get OznakaPosebneKategorijeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOznakaPosebneKategorijeID()
    {
        return isset($this->OznakaPosebneKategorijeID) ? $this->OznakaPosebneKategorijeID : null;
    }
    /**
     * Set OznakaPosebneKategorijeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oznakaPosebneKategorijeID
     * @return \StructType\PrateciListInput
     */
    public function setOznakaPosebneKategorijeID($oznakaPosebneKategorijeID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaPosebneKategorijeID) && !is_numeric($oznakaPosebneKategorijeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oznakaPosebneKategorijeID)), __LINE__);
        }
        if (is_null($oznakaPosebneKategorijeID) || (is_array($oznakaPosebneKategorijeID) && empty($oznakaPosebneKategorijeID))) {
            unset($this->OznakaPosebneKategorijeID);
        } else {
            $this->OznakaPosebneKategorijeID = $oznakaPosebneKategorijeID;
        }
        return $this;
    }
    /**
     * Get PrateciListID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrateciListID()
    {
        return isset($this->PrateciListID) ? $this->PrateciListID : null;
    }
    /**
     * Set PrateciListID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prateciListID
     * @return \StructType\PrateciListInput
     */
    public function setPrateciListID($prateciListID = null)
    {
        // validation for constraint: int
        if (!is_null($prateciListID) && !is_numeric($prateciListID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prateciListID)), __LINE__);
        }
        if (is_null($prateciListID) || (is_array($prateciListID) && empty($prateciListID))) {
            unset($this->PrateciListID);
        } else {
            $this->PrateciListID = $prateciListID;
        }
        return $this;
    }
    /**
     * Get Predavatelj value
     * @return \StructType\PravnaOsobaObrt|null
     */
    public function getPredavatelj()
    {
        return $this->Predavatelj;
    }
    /**
     * Set Predavatelj value
     * @param \StructType\PravnaOsobaObrt $predavatelj
     * @return \StructType\PrateciListInput
     */
    public function setPredavatelj(\StructType\PravnaOsobaObrt $predavatelj = null)
    {
        $this->Predavatelj = $predavatelj;
        return $this;
    }
    /**
     * Get PredavateljNKDID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPredavateljNKDID()
    {
        return isset($this->PredavateljNKDID) ? $this->PredavateljNKDID : null;
    }
    /**
     * Set PredavateljNKDID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $predavateljNKDID
     * @return \StructType\PrateciListInput
     */
    public function setPredavateljNKDID($predavateljNKDID = null)
    {
        // validation for constraint: int
        if (!is_null($predavateljNKDID) && !is_numeric($predavateljNKDID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($predavateljNKDID)), __LINE__);
        }
        if (is_null($predavateljNKDID) || (is_array($predavateljNKDID) && empty($predavateljNKDID))) {
            unset($this->PredavateljNKDID);
        } else {
            $this->PredavateljNKDID = $predavateljNKDID;
        }
        return $this;
    }
    /**
     * Get Preuzimatelj value
     * @return \StructType\PravnaOsobaObrt|null
     */
    public function getPreuzimatelj()
    {
        return $this->Preuzimatelj;
    }
    /**
     * Set Preuzimatelj value
     * @param \StructType\PravnaOsobaObrt $preuzimatelj
     * @return \StructType\PrateciListInput
     */
    public function setPreuzimatelj(\StructType\PravnaOsobaObrt $preuzimatelj = null)
    {
        $this->Preuzimatelj = $preuzimatelj;
        return $this;
    }
    /**
     * Get Prijevoznik value
     * @return \StructType\PravnaOsobaObrt|null
     */
    public function getPrijevoznik()
    {
        return $this->Prijevoznik;
    }
    /**
     * Set Prijevoznik value
     * @param \StructType\PravnaOsobaObrt $prijevoznik
     * @return \StructType\PrateciListInput
     */
    public function setPrijevoznik(\StructType\PravnaOsobaObrt $prijevoznik = null)
    {
        $this->Prijevoznik = $prijevoznik;
        return $this;
    }
    /**
     * Get PrijevoznikBrojOcevidnika value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrijevoznikBrojOcevidnika()
    {
        return isset($this->PrijevoznikBrojOcevidnika) ? $this->PrijevoznikBrojOcevidnika : null;
    }
    /**
     * Set PrijevoznikBrojOcevidnika value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prijevoznikBrojOcevidnika
     * @return \StructType\PrateciListInput
     */
    public function setPrijevoznikBrojOcevidnika($prijevoznikBrojOcevidnika = null)
    {
        // validation for constraint: string
        if (!is_null($prijevoznikBrojOcevidnika) && !is_string($prijevoznikBrojOcevidnika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prijevoznikBrojOcevidnika)), __LINE__);
        }
        if (is_null($prijevoznikBrojOcevidnika) || (is_array($prijevoznikBrojOcevidnika) && empty($prijevoznikBrojOcevidnika))) {
            unset($this->PrijevoznikBrojOcevidnika);
        } else {
            $this->PrijevoznikBrojOcevidnika = $prijevoznikBrojOcevidnika;
        }
        return $this;
    }
    /**
     * Get PrijevoznikPreuzeo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrijevoznikPreuzeo()
    {
        return isset($this->PrijevoznikPreuzeo) ? $this->PrijevoznikPreuzeo : null;
    }
    /**
     * Set PrijevoznikPreuzeo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prijevoznikPreuzeo
     * @return \StructType\PrateciListInput
     */
    public function setPrijevoznikPreuzeo($prijevoznikPreuzeo = null)
    {
        // validation for constraint: string
        if (!is_null($prijevoznikPreuzeo) && !is_string($prijevoznikPreuzeo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prijevoznikPreuzeo)), __LINE__);
        }
        if (is_null($prijevoznikPreuzeo) || (is_array($prijevoznikPreuzeo) && empty($prijevoznikPreuzeo))) {
            unset($this->PrijevoznikPreuzeo);
        } else {
            $this->PrijevoznikPreuzeo = $prijevoznikPreuzeo;
        }
        return $this;
    }
    /**
     * Get RegistarskaOznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistarskaOznaka()
    {
        return isset($this->RegistarskaOznaka) ? $this->RegistarskaOznaka : null;
    }
    /**
     * Set RegistarskaOznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registarskaOznaka
     * @return \StructType\PrateciListInput
     */
    public function setRegistarskaOznaka($registarskaOznaka = null)
    {
        // validation for constraint: string
        if (!is_null($registarskaOznaka) && !is_string($registarskaOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registarskaOznaka)), __LINE__);
        }
        if (is_null($registarskaOznaka) || (is_array($registarskaOznaka) && empty($registarskaOznaka))) {
            unset($this->RegistarskaOznaka);
        } else {
            $this->RegistarskaOznaka = $registarskaOznaka;
        }
        return $this;
    }
    /**
     * Get SpremniciNaJavnojPovrsini value
     * @return bool|null
     */
    public function getSpremniciNaJavnojPovrsini()
    {
        return $this->SpremniciNaJavnojPovrsini;
    }
    /**
     * Set SpremniciNaJavnojPovrsini value
     * @param bool $spremniciNaJavnojPovrsini
     * @return \StructType\PrateciListInput
     */
    public function setSpremniciNaJavnojPovrsini($spremniciNaJavnojPovrsini = null)
    {
        // validation for constraint: boolean
        if (!is_null($spremniciNaJavnojPovrsini) && !is_bool($spremniciNaJavnojPovrsini)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($spremniciNaJavnojPovrsini)), __LINE__);
        }
        $this->SpremniciNaJavnojPovrsini = $spremniciNaJavnojPovrsini;
        return $this;
    }
    /**
     * Get VrstaDjelatnostiPredavateljId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVrstaDjelatnostiPredavateljId()
    {
        return isset($this->VrstaDjelatnostiPredavateljId) ? $this->VrstaDjelatnostiPredavateljId : null;
    }
    /**
     * Set VrstaDjelatnostiPredavateljId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vrstaDjelatnostiPredavateljId
     * @return \StructType\PrateciListInput
     */
    public function setVrstaDjelatnostiPredavateljId($vrstaDjelatnostiPredavateljId = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaDjelatnostiPredavateljId) && !is_numeric($vrstaDjelatnostiPredavateljId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vrstaDjelatnostiPredavateljId)), __LINE__);
        }
        if (is_null($vrstaDjelatnostiPredavateljId) || (is_array($vrstaDjelatnostiPredavateljId) && empty($vrstaDjelatnostiPredavateljId))) {
            unset($this->VrstaDjelatnostiPredavateljId);
        } else {
            $this->VrstaDjelatnostiPredavateljId = $vrstaDjelatnostiPredavateljId;
        }
        return $this;
    }
    /**
     * Get VrstaDjelatnostiPreuzimateljId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVrstaDjelatnostiPreuzimateljId()
    {
        return isset($this->VrstaDjelatnostiPreuzimateljId) ? $this->VrstaDjelatnostiPreuzimateljId : null;
    }
    /**
     * Set VrstaDjelatnostiPreuzimateljId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vrstaDjelatnostiPreuzimateljId
     * @return \StructType\PrateciListInput
     */
    public function setVrstaDjelatnostiPreuzimateljId($vrstaDjelatnostiPreuzimateljId = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaDjelatnostiPreuzimateljId) && !is_numeric($vrstaDjelatnostiPreuzimateljId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vrstaDjelatnostiPreuzimateljId)), __LINE__);
        }
        if (is_null($vrstaDjelatnostiPreuzimateljId) || (is_array($vrstaDjelatnostiPreuzimateljId) && empty($vrstaDjelatnostiPreuzimateljId))) {
            unset($this->VrstaDjelatnostiPreuzimateljId);
        } else {
            $this->VrstaDjelatnostiPreuzimateljId = $vrstaDjelatnostiPreuzimateljId;
        }
        return $this;
    }
    /**
     * Get VrstaDjelatnostiPrijevoznikId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVrstaDjelatnostiPrijevoznikId()
    {
        return isset($this->VrstaDjelatnostiPrijevoznikId) ? $this->VrstaDjelatnostiPrijevoznikId : null;
    }
    /**
     * Set VrstaDjelatnostiPrijevoznikId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vrstaDjelatnostiPrijevoznikId
     * @return \StructType\PrateciListInput
     */
    public function setVrstaDjelatnostiPrijevoznikId($vrstaDjelatnostiPrijevoznikId = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaDjelatnostiPrijevoznikId) && !is_numeric($vrstaDjelatnostiPrijevoznikId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vrstaDjelatnostiPrijevoznikId)), __LINE__);
        }
        if (is_null($vrstaDjelatnostiPrijevoznikId) || (is_array($vrstaDjelatnostiPrijevoznikId) && empty($vrstaDjelatnostiPrijevoznikId))) {
            unset($this->VrstaDjelatnostiPrijevoznikId);
        } else {
            $this->VrstaDjelatnostiPrijevoznikId = $vrstaDjelatnostiPrijevoznikId;
        }
        return $this;
    }
    /**
     * Get KljucniBrojOtpadaID value
     * @return int|null
     */
    public function getKljucniBrojOtpadaID()
    {
        return $this->KljucniBrojOtpadaID;
    }
    /**
     * Set KljucniBrojOtpadaID value
     * @param int $kljucniBrojOtpadaID
     * @return \StructType\PrateciListInput
     */
    public function setKljucniBrojOtpadaID($kljucniBrojOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($kljucniBrojOtpadaID) && !is_numeric($kljucniBrojOtpadaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kljucniBrojOtpadaID)), __LINE__);
        }
        $this->KljucniBrojOtpadaID = $kljucniBrojOtpadaID;
        return $this;
    }
    /**
     * Get KolicinaOtpadaKG value
     * @return float|null
     */
    public function getKolicinaOtpadaKG()
    {
        return $this->KolicinaOtpadaKG;
    }
    /**
     * Set KolicinaOtpadaKG value
     * @param float $kolicinaOtpadaKG
     * @return \StructType\PrateciListInput
     */
    public function setKolicinaOtpadaKG($kolicinaOtpadaKG = null)
    {
        $this->KolicinaOtpadaKG = $kolicinaOtpadaKG;
        return $this;
    }
    /**
     * Get KolicinaOtpadaM3 value
     * @return float|null
     */
    public function getKolicinaOtpadaM3()
    {
        return $this->KolicinaOtpadaM3;
    }
    /**
     * Set KolicinaOtpadaM3 value
     * @param float $kolicinaOtpadaM3
     * @return \StructType\PrateciListInput
     */
    public function setKolicinaOtpadaM3($kolicinaOtpadaM3 = null)
    {
        $this->KolicinaOtpadaM3 = $kolicinaOtpadaM3;
        return $this;
    }
    /**
     * Get NacinOdredivanjaMaseID value
     * @return int|null
     */
    public function getNacinOdredivanjaMaseID()
    {
        return $this->NacinOdredivanjaMaseID;
    }
    /**
     * Set NacinOdredivanjaMaseID value
     * @param int $nacinOdredivanjaMaseID
     * @return \StructType\PrateciListInput
     */
    public function setNacinOdredivanjaMaseID($nacinOdredivanjaMaseID = null)
    {
        // validation for constraint: int
        if (!is_null($nacinOdredivanjaMaseID) && !is_numeric($nacinOdredivanjaMaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nacinOdredivanjaMaseID)), __LINE__);
        }
        $this->NacinOdredivanjaMaseID = $nacinOdredivanjaMaseID;
        return $this;
    }
    /**
     * Get FizikalnoSvojstvoOtpadaID value
     * @return int|null
     */
    public function getFizikalnoSvojstvoOtpadaID()
    {
        return $this->FizikalnoSvojstvoOtpadaID;
    }
    /**
     * Set FizikalnoSvojstvoOtpadaID value
     * @param int $fizikalnoSvojstvoOtpadaID
     * @return \StructType\PrateciListInput
     */
    public function setFizikalnoSvojstvoOtpadaID($fizikalnoSvojstvoOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($fizikalnoSvojstvoOtpadaID) && !is_numeric($fizikalnoSvojstvoOtpadaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fizikalnoSvojstvoOtpadaID)), __LINE__);
        }
        $this->FizikalnoSvojstvoOtpadaID = $fizikalnoSvojstvoOtpadaID;
        return $this;
    }
    /**
     * Get FizikalnoSvojstvoOtpadaOstalo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFizikalnoSvojstvoOtpadaOstalo()
    {
        return isset($this->FizikalnoSvojstvoOtpadaOstalo) ? $this->FizikalnoSvojstvoOtpadaOstalo : null;
    }
    /**
     * Set FizikalnoSvojstvoOtpadaOstalo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fizikalnoSvojstvoOtpadaOstalo
     * @return \StructType\PrateciListInput
     */
    public function setFizikalnoSvojstvoOtpadaOstalo($fizikalnoSvojstvoOtpadaOstalo = null)
    {
        // validation for constraint: string
        if (!is_null($fizikalnoSvojstvoOtpadaOstalo) && !is_string($fizikalnoSvojstvoOtpadaOstalo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fizikalnoSvojstvoOtpadaOstalo)), __LINE__);
        }
        if (is_null($fizikalnoSvojstvoOtpadaOstalo) || (is_array($fizikalnoSvojstvoOtpadaOstalo) && empty($fizikalnoSvojstvoOtpadaOstalo))) {
            unset($this->FizikalnoSvojstvoOtpadaOstalo);
        } else {
            $this->FizikalnoSvojstvoOtpadaOstalo = $fizikalnoSvojstvoOtpadaOstalo;
        }
        return $this;
    }
    /**
     * Get TipOtpadaID value
     * @return int|null
     */
    public function getTipOtpadaID()
    {
        return $this->TipOtpadaID;
    }
    /**
     * Set TipOtpadaID value
     * @param int $tipOtpadaID
     * @return \StructType\PrateciListInput
     */
    public function setTipOtpadaID($tipOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($tipOtpadaID) && !is_numeric($tipOtpadaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipOtpadaID)), __LINE__);
        }
        $this->TipOtpadaID = $tipOtpadaID;
        return $this;
    }
    /**
     * Get OznakeH value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint_1|null
     */
    public function getOznakeH()
    {
        return isset($this->OznakeH) ? $this->OznakeH : null;
    }
    /**
     * Set OznakeH value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint_1 $oznakeH
     * @return \StructType\PrateciListInput
     */
    public function setOznakeH(\ArrayType\ArrayOfint_1 $oznakeH = null)
    {
        if (is_null($oznakeH) || (is_array($oznakeH) && empty($oznakeH))) {
            unset($this->OznakeH);
        } else {
            $this->OznakeH = $oznakeH;
        }
        return $this;
    }
    /**
     * Get PorijeklaOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNaseljeJLSZupanijaPostotak|null
     */
    public function getPorijeklaOtpada()
    {
        return isset($this->PorijeklaOtpada) ? $this->PorijeklaOtpada : null;
    }
    /**
     * Set PorijeklaOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNaseljeJLSZupanijaPostotak $porijeklaOtpada
     * @return \StructType\PrateciListInput
     */
    public function setPorijeklaOtpada(\ArrayType\ArrayOfNaseljeJLSZupanijaPostotak $porijeklaOtpada = null)
    {
        if (is_null($porijeklaOtpada) || (is_array($porijeklaOtpada) && empty($porijeklaOtpada))) {
            unset($this->PorijeklaOtpada);
        } else {
            $this->PorijeklaOtpada = $porijeklaOtpada;
        }
        return $this;
    }
    /**
     * Get OpisOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpisOtpada()
    {
        return isset($this->OpisOtpada) ? $this->OpisOtpada : null;
    }
    /**
     * Set OpisOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opisOtpada
     * @return \StructType\PrateciListInput
     */
    public function setOpisOtpada($opisOtpada = null)
    {
        // validation for constraint: string
        if (!is_null($opisOtpada) && !is_string($opisOtpada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opisOtpada)), __LINE__);
        }
        if (is_null($opisOtpada) || (is_array($opisOtpada) && empty($opisOtpada))) {
            unset($this->OpisOtpada);
        } else {
            $this->OpisOtpada = $opisOtpada;
        }
        return $this;
    }
    /**
     * Get NamjenaPosiljkeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNamjenaPosiljkeID()
    {
        return isset($this->NamjenaPosiljkeID) ? $this->NamjenaPosiljkeID : null;
    }
    /**
     * Set NamjenaPosiljkeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $namjenaPosiljkeID
     * @return \StructType\PrateciListInput
     */
    public function setNamjenaPosiljkeID($namjenaPosiljkeID = null)
    {
        // validation for constraint: int
        if (!is_null($namjenaPosiljkeID) && !is_numeric($namjenaPosiljkeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($namjenaPosiljkeID)), __LINE__);
        }
        if (is_null($namjenaPosiljkeID) || (is_array($namjenaPosiljkeID) && empty($namjenaPosiljkeID))) {
            unset($this->NamjenaPosiljkeID);
        } else {
            $this->NamjenaPosiljkeID = $namjenaPosiljkeID;
        }
        return $this;
    }
    /**
     * Get NacinPakiranjaOtpadaID value
     * @return int|null
     */
    public function getNacinPakiranjaOtpadaID()
    {
        return $this->NacinPakiranjaOtpadaID;
    }
    /**
     * Set NacinPakiranjaOtpadaID value
     * @param int $nacinPakiranjaOtpadaID
     * @return \StructType\PrateciListInput
     */
    public function setNacinPakiranjaOtpadaID($nacinPakiranjaOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($nacinPakiranjaOtpadaID) && !is_numeric($nacinPakiranjaOtpadaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nacinPakiranjaOtpadaID)), __LINE__);
        }
        $this->NacinPakiranjaOtpadaID = $nacinPakiranjaOtpadaID;
        return $this;
    }
    /**
     * Get BrojPakiranja value
     * @return int|null
     */
    public function getBrojPakiranja()
    {
        return $this->BrojPakiranja;
    }
    /**
     * Set BrojPakiranja value
     * @param int $brojPakiranja
     * @return \StructType\PrateciListInput
     */
    public function setBrojPakiranja($brojPakiranja = null)
    {
        // validation for constraint: int
        if (!is_null($brojPakiranja) && !is_numeric($brojPakiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($brojPakiranja)), __LINE__);
        }
        $this->BrojPakiranja = $brojPakiranja;
        return $this;
    }
    /**
     * Get Napomena value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNapomena()
    {
        return isset($this->Napomena) ? $this->Napomena : null;
    }
    /**
     * Set Napomena value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $napomena
     * @return \StructType\PrateciListInput
     */
    public function setNapomena($napomena = null)
    {
        // validation for constraint: string
        if (!is_null($napomena) && !is_string($napomena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($napomena)), __LINE__);
        }
        if (is_null($napomena) || (is_array($napomena) && empty($napomena))) {
            unset($this->Napomena);
        } else {
            $this->Napomena = $napomena;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrateciListInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
