<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntoInput StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OntoInput
 * @subpackage Structs
 */
class OntoInput extends AbstractStructBase
{
    /**
     * The OdgovornaOsoba
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdgovornaOsoba;
    /**
     * The OntoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OntoID;
    /**
     * The VrijediDo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijediDo;
    /**
     * Constructor method for OntoInput
     * @uses OntoInput::setOdgovornaOsoba()
     * @uses OntoInput::setOntoID()
     * @uses OntoInput::setVrijediDo()
     * @param string $odgovornaOsoba
     * @param int $ontoID
     * @param string $vrijediDo
     */
    public function __construct($odgovornaOsoba = null, $ontoID = null, $vrijediDo = null)
    {
        $this
            ->setOdgovornaOsoba($odgovornaOsoba)
            ->setOntoID($ontoID)
            ->setVrijediDo($vrijediDo);
    }
    /**
     * Get OdgovornaOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdgovornaOsoba()
    {
        return isset($this->OdgovornaOsoba) ? $this->OdgovornaOsoba : null;
    }
    /**
     * Set OdgovornaOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odgovornaOsoba
     * @return \StructType\OntoInput
     */
    public function setOdgovornaOsoba($odgovornaOsoba = null)
    {
        // validation for constraint: string
        if (!is_null($odgovornaOsoba) && !is_string($odgovornaOsoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($odgovornaOsoba)), __LINE__);
        }
        if (is_null($odgovornaOsoba) || (is_array($odgovornaOsoba) && empty($odgovornaOsoba))) {
            unset($this->OdgovornaOsoba);
        } else {
            $this->OdgovornaOsoba = $odgovornaOsoba;
        }
        return $this;
    }
    /**
     * Get OntoID value
     * @return int|null
     */
    public function getOntoID()
    {
        return $this->OntoID;
    }
    /**
     * Set OntoID value
     * @param int $ontoID
     * @return \StructType\OntoInput
     */
    public function setOntoID($ontoID = null)
    {
        // validation for constraint: int
        if (!is_null($ontoID) && !is_numeric($ontoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ontoID)), __LINE__);
        }
        $this->OntoID = $ontoID;
        return $this;
    }
    /**
     * Get VrijediDo value
     * @return string|null
     */
    public function getVrijediDo()
    {
        return $this->VrijediDo;
    }
    /**
     * Set VrijediDo value
     * @param string $vrijediDo
     * @return \StructType\OntoInput
     */
    public function setVrijediDo($vrijediDo = null)
    {
        // validation for constraint: string
        if (!is_null($vrijediDo) && !is_string($vrijediDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vrijediDo)), __LINE__);
        }
        $this->VrijediDo = $vrijediDo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntoInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
