<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api.fm-web.co.za/webservices/AssetDataWebSvc/DriverProcessesWS.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api.fm-web.co.za/webservices/AssetDataWebSvc/DriverProcessesWS.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderTokenHeader(new \StructType\TokenHeader());
/**
 * Sample call for AddBasicDriver operation/method
 */
if ($add->AddBasicDriver(new \StructType\AddBasicDriver()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDriver operation/method
 */
if ($add->AddDriver(new \StructType\AddDriver()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderTokenHeader(new \StructType\TokenHeader());
/**
 * Sample call for UpdateDriver operation/method
 */
if ($update->UpdateDriver(new \StructType\UpdateDriver()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderTokenHeader(new \StructType\TokenHeader());
/**
 * Sample call for DeleteDriver operation/method
 */
if ($delete->DeleteDriver(new \StructType\DeleteDriver()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderTokenHeader(new \StructType\TokenHeader());
/**
 * Sample call for GetDriver operation/method
 */
if ($get->GetDriver(new \StructType\GetDriver()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDriverList operation/method
 */
if ($get->GetDriverList(new \StructType\GetDriverList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDriverListFiltered operation/method
 */
if ($get->GetDriverListFiltered(new \StructType\GetDriverListFiltered()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDriverScoresInDateRange operation/method
 */
if ($get->GetDriverScoresInDateRange(new \StructType\GetDriverScoresInDateRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDriverReportingGroupList operation/method
 */
if ($get->GetDriverReportingGroupList(new \StructType\GetDriverReportingGroupList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDriverReportingGroup operation/method
 */
if ($get->GetDriverReportingGroup(new \StructType\GetDriverReportingGroup()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Reporting ServiceType
 */
$reporting = new \ServiceType\Reporting($options);
$reporting->setSoapHeaderTokenHeader(new \StructType\TokenHeader());
/**
 * Sample call for ReportingGroupAddDriver operation/method
 */
if ($reporting->ReportingGroupAddDriver(new \StructType\ReportingGroupAddDriver()) !== false) {
    print_r($reporting->getResult());
} else {
    print_r($reporting->getLastError());
}
/**
 * Sample call for ReportingGroupRemoveDriver operation/method
 */
if ($reporting->ReportingGroupRemoveDriver(new \StructType\ReportingGroupRemoveDriver()) !== false) {
    print_r($reporting->getResult());
} else {
    print_r($reporting->getLastError());
}
