<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportingGroupAddDriver StructType
 * @subpackage Structs
 */
class ReportingGroupAddDriver extends AbstractStructBase
{
    /**
     * The GroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupID;
    /**
     * The DriverID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverID;
    /**
     * Constructor method for ReportingGroupAddDriver
     * @uses ReportingGroupAddDriver::setGroupID()
     * @uses ReportingGroupAddDriver::setDriverID()
     * @param int $groupID
     * @param int $driverID
     */
    public function __construct($groupID = null, $driverID = null)
    {
        $this
            ->setGroupID($groupID)
            ->setDriverID($driverID);
    }
    /**
     * Get GroupID value
     * @return int
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \StructType\ReportingGroupAddDriver
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !is_numeric($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get DriverID value
     * @return int
     */
    public function getDriverID()
    {
        return $this->DriverID;
    }
    /**
     * Set DriverID value
     * @param int $driverID
     * @return \StructType\ReportingGroupAddDriver
     */
    public function setDriverID($driverID = null)
    {
        // validation for constraint: int
        if (!is_null($driverID) && !is_numeric($driverID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($driverID)), __LINE__);
        }
        $this->DriverID = $driverID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportingGroupAddDriver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
