<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDriverListFiltered StructType
 * @subpackage Structs
 */
class GetDriverListFiltered extends AbstractStructBase
{
    /**
     * The searchOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $searchOption;
    /**
     * The firstRowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $firstRowNumber;
    /**
     * The searchText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $searchText;
    /**
     * Constructor method for GetDriverListFiltered
     * @uses GetDriverListFiltered::setSearchOption()
     * @uses GetDriverListFiltered::setFirstRowNumber()
     * @uses GetDriverListFiltered::setSearchText()
     * @param string $searchOption
     * @param int $firstRowNumber
     * @param string $searchText
     */
    public function __construct($searchOption = null, $firstRowNumber = null, $searchText = null)
    {
        $this
            ->setSearchOption($searchOption)
            ->setFirstRowNumber($firstRowNumber)
            ->setSearchText($searchText);
    }
    /**
     * Get searchOption value
     * @return string
     */
    public function getSearchOption()
    {
        return $this->searchOption;
    }
    /**
     * Set searchOption value
     * @uses \EnumType\DriverSearchOption::valueIsValid()
     * @uses \EnumType\DriverSearchOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchOption
     * @return \StructType\GetDriverListFiltered
     */
    public function setSearchOption($searchOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DriverSearchOption::valueIsValid($searchOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchOption, implode(', ', \EnumType\DriverSearchOption::getValidValues())), __LINE__);
        }
        $this->searchOption = $searchOption;
        return $this;
    }
    /**
     * Get firstRowNumber value
     * @return int
     */
    public function getFirstRowNumber()
    {
        return $this->firstRowNumber;
    }
    /**
     * Set firstRowNumber value
     * @param int $firstRowNumber
     * @return \StructType\GetDriverListFiltered
     */
    public function setFirstRowNumber($firstRowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($firstRowNumber) && !is_numeric($firstRowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($firstRowNumber)), __LINE__);
        }
        $this->firstRowNumber = $firstRowNumber;
        return $this;
    }
    /**
     * Get searchText value
     * @return string|null
     */
    public function getSearchText()
    {
        return $this->searchText;
    }
    /**
     * Set searchText value
     * @param string $searchText
     * @return \StructType\GetDriverListFiltered
     */
    public function setSearchText($searchText = null)
    {
        // validation for constraint: string
        if (!is_null($searchText) && !is_string($searchText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchText)), __LINE__);
        }
        $this->searchText = $searchText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDriverListFiltered
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
