<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverScore StructType
 * @subpackage Structs
 */
class DriverScore extends AbstractStructBase
{
    /**
     * The DriverID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverID;
    /**
     * The OverallScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OverallScore;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Distance;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The OverSpeedingScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OverSpeedingScore;
    /**
     * The OverRevvingScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OverRevvingScore;
    /**
     * The HarshBrakingScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $HarshBrakingScore;
    /**
     * The OutOfGreenBandDrivingScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OutOfGreenBandDrivingScore;
    /**
     * The ExcessiveIdlingScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ExcessiveIdlingScore;
    /**
     * The HarshAccelerationScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $HarshAccelerationScore;
    /**
     * Constructor method for DriverScore
     * @uses DriverScore::setDriverID()
     * @uses DriverScore::setOverallScore()
     * @uses DriverScore::setDistance()
     * @uses DriverScore::setDuration()
     * @uses DriverScore::setOverSpeedingScore()
     * @uses DriverScore::setOverRevvingScore()
     * @uses DriverScore::setHarshBrakingScore()
     * @uses DriverScore::setOutOfGreenBandDrivingScore()
     * @uses DriverScore::setExcessiveIdlingScore()
     * @uses DriverScore::setHarshAccelerationScore()
     * @param int $driverID
     * @param float $overallScore
     * @param float $distance
     * @param int $duration
     * @param float $overSpeedingScore
     * @param float $overRevvingScore
     * @param float $harshBrakingScore
     * @param float $outOfGreenBandDrivingScore
     * @param float $excessiveIdlingScore
     * @param float $harshAccelerationScore
     */
    public function __construct($driverID = null, $overallScore = null, $distance = null, $duration = null, $overSpeedingScore = null, $overRevvingScore = null, $harshBrakingScore = null, $outOfGreenBandDrivingScore = null, $excessiveIdlingScore = null, $harshAccelerationScore = null)
    {
        $this
            ->setDriverID($driverID)
            ->setOverallScore($overallScore)
            ->setDistance($distance)
            ->setDuration($duration)
            ->setOverSpeedingScore($overSpeedingScore)
            ->setOverRevvingScore($overRevvingScore)
            ->setHarshBrakingScore($harshBrakingScore)
            ->setOutOfGreenBandDrivingScore($outOfGreenBandDrivingScore)
            ->setExcessiveIdlingScore($excessiveIdlingScore)
            ->setHarshAccelerationScore($harshAccelerationScore);
    }
    /**
     * Get DriverID value
     * @return int
     */
    public function getDriverID()
    {
        return $this->DriverID;
    }
    /**
     * Set DriverID value
     * @param int $driverID
     * @return \StructType\DriverScore
     */
    public function setDriverID($driverID = null)
    {
        // validation for constraint: int
        if (!is_null($driverID) && !is_numeric($driverID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($driverID)), __LINE__);
        }
        $this->DriverID = $driverID;
        return $this;
    }
    /**
     * Get OverallScore value
     * @return float
     */
    public function getOverallScore()
    {
        return $this->OverallScore;
    }
    /**
     * Set OverallScore value
     * @param float $overallScore
     * @return \StructType\DriverScore
     */
    public function setOverallScore($overallScore = null)
    {
        $this->OverallScore = $overallScore;
        return $this;
    }
    /**
     * Get Distance value
     * @return float
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\DriverScore
     */
    public function setDistance($distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\DriverScore
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get OverSpeedingScore value
     * @return float
     */
    public function getOverSpeedingScore()
    {
        return $this->OverSpeedingScore;
    }
    /**
     * Set OverSpeedingScore value
     * @param float $overSpeedingScore
     * @return \StructType\DriverScore
     */
    public function setOverSpeedingScore($overSpeedingScore = null)
    {
        $this->OverSpeedingScore = $overSpeedingScore;
        return $this;
    }
    /**
     * Get OverRevvingScore value
     * @return float
     */
    public function getOverRevvingScore()
    {
        return $this->OverRevvingScore;
    }
    /**
     * Set OverRevvingScore value
     * @param float $overRevvingScore
     * @return \StructType\DriverScore
     */
    public function setOverRevvingScore($overRevvingScore = null)
    {
        $this->OverRevvingScore = $overRevvingScore;
        return $this;
    }
    /**
     * Get HarshBrakingScore value
     * @return float
     */
    public function getHarshBrakingScore()
    {
        return $this->HarshBrakingScore;
    }
    /**
     * Set HarshBrakingScore value
     * @param float $harshBrakingScore
     * @return \StructType\DriverScore
     */
    public function setHarshBrakingScore($harshBrakingScore = null)
    {
        $this->HarshBrakingScore = $harshBrakingScore;
        return $this;
    }
    /**
     * Get OutOfGreenBandDrivingScore value
     * @return float
     */
    public function getOutOfGreenBandDrivingScore()
    {
        return $this->OutOfGreenBandDrivingScore;
    }
    /**
     * Set OutOfGreenBandDrivingScore value
     * @param float $outOfGreenBandDrivingScore
     * @return \StructType\DriverScore
     */
    public function setOutOfGreenBandDrivingScore($outOfGreenBandDrivingScore = null)
    {
        $this->OutOfGreenBandDrivingScore = $outOfGreenBandDrivingScore;
        return $this;
    }
    /**
     * Get ExcessiveIdlingScore value
     * @return float
     */
    public function getExcessiveIdlingScore()
    {
        return $this->ExcessiveIdlingScore;
    }
    /**
     * Set ExcessiveIdlingScore value
     * @param float $excessiveIdlingScore
     * @return \StructType\DriverScore
     */
    public function setExcessiveIdlingScore($excessiveIdlingScore = null)
    {
        $this->ExcessiveIdlingScore = $excessiveIdlingScore;
        return $this;
    }
    /**
     * Get HarshAccelerationScore value
     * @return float
     */
    public function getHarshAccelerationScore()
    {
        return $this->HarshAccelerationScore;
    }
    /**
     * Set HarshAccelerationScore value
     * @param float $harshAccelerationScore
     * @return \StructType\DriverScore
     */
    public function setHarshAccelerationScore($harshAccelerationScore = null)
    {
        $this->HarshAccelerationScore = $harshAccelerationScore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DriverScore
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
