<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Driver StructType
 * @subpackage Structs
 */
class Driver extends EntityBase
{
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SiteID;
    /**
     * The GroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupID;
    /**
     * The DefaultAllowVehicleAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DefaultAllowVehicleAccess;
    /**
     * The License
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $License;
    /**
     * The LastLicense
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastLicense;
    /**
     * The NextLicense
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NextLicense;
    /**
     * The LicenseInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LicenseInterval;
    /**
     * The LicenseRemind
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LicenseRemind;
    /**
     * The LicenseRemind2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LicenseRemind2;
    /**
     * The DistanceChecked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DistanceChecked;
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Created;
    /**
     * The Updated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Updated;
    /**
     * The EmployeeNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmployeeNumber;
    /**
     * The ExtendedID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtendedID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Driver
     * @uses Driver::setSiteID()
     * @uses Driver::setGroupID()
     * @uses Driver::setDefaultAllowVehicleAccess()
     * @uses Driver::setLicense()
     * @uses Driver::setLastLicense()
     * @uses Driver::setNextLicense()
     * @uses Driver::setLicenseInterval()
     * @uses Driver::setLicenseRemind()
     * @uses Driver::setLicenseRemind2()
     * @uses Driver::setDistanceChecked()
     * @uses Driver::setCreated()
     * @uses Driver::setUpdated()
     * @uses Driver::setEmployeeNumber()
     * @uses Driver::setExtendedID()
     * @uses Driver::setName()
     * @param int $siteID
     * @param int $groupID
     * @param bool $defaultAllowVehicleAccess
     * @param bool $license
     * @param string $lastLicense
     * @param string $nextLicense
     * @param string $licenseInterval
     * @param string $licenseRemind
     * @param string $licenseRemind2
     * @param string $distanceChecked
     * @param string $created
     * @param string $updated
     * @param string $employeeNumber
     * @param string $extendedID
     * @param string $name
     */
    public function __construct($siteID = null, $groupID = null, $defaultAllowVehicleAccess = null, $license = null, $lastLicense = null, $nextLicense = null, $licenseInterval = null, $licenseRemind = null, $licenseRemind2 = null, $distanceChecked = null, $created = null, $updated = null, $employeeNumber = null, $extendedID = null, $name = null)
    {
        $this
            ->setSiteID($siteID)
            ->setGroupID($groupID)
            ->setDefaultAllowVehicleAccess($defaultAllowVehicleAccess)
            ->setLicense($license)
            ->setLastLicense($lastLicense)
            ->setNextLicense($nextLicense)
            ->setLicenseInterval($licenseInterval)
            ->setLicenseRemind($licenseRemind)
            ->setLicenseRemind2($licenseRemind2)
            ->setDistanceChecked($distanceChecked)
            ->setCreated($created)
            ->setUpdated($updated)
            ->setEmployeeNumber($employeeNumber)
            ->setExtendedID($extendedID)
            ->setName($name);
    }
    /**
     * Get SiteID value
     * @return int
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param int $siteID
     * @return \StructType\Driver
     */
    public function setSiteID($siteID = null)
    {
        // validation for constraint: int
        if (!is_null($siteID) && !is_numeric($siteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siteID)), __LINE__);
        }
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get GroupID value
     * @return int
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \StructType\Driver
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !is_numeric($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get DefaultAllowVehicleAccess value
     * @return bool
     */
    public function getDefaultAllowVehicleAccess()
    {
        return $this->DefaultAllowVehicleAccess;
    }
    /**
     * Set DefaultAllowVehicleAccess value
     * @param bool $defaultAllowVehicleAccess
     * @return \StructType\Driver
     */
    public function setDefaultAllowVehicleAccess($defaultAllowVehicleAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultAllowVehicleAccess) && !is_bool($defaultAllowVehicleAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultAllowVehicleAccess)), __LINE__);
        }
        $this->DefaultAllowVehicleAccess = $defaultAllowVehicleAccess;
        return $this;
    }
    /**
     * Get License value
     * @return bool
     */
    public function getLicense()
    {
        return $this->License;
    }
    /**
     * Set License value
     * @param bool $license
     * @return \StructType\Driver
     */
    public function setLicense($license = null)
    {
        // validation for constraint: boolean
        if (!is_null($license) && !is_bool($license)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($license)), __LINE__);
        }
        $this->License = $license;
        return $this;
    }
    /**
     * Get LastLicense value
     * @return string
     */
    public function getLastLicense()
    {
        return $this->LastLicense;
    }
    /**
     * Set LastLicense value
     * @param string $lastLicense
     * @return \StructType\Driver
     */
    public function setLastLicense($lastLicense = null)
    {
        // validation for constraint: string
        if (!is_null($lastLicense) && !is_string($lastLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastLicense)), __LINE__);
        }
        $this->LastLicense = $lastLicense;
        return $this;
    }
    /**
     * Get NextLicense value
     * @return string
     */
    public function getNextLicense()
    {
        return $this->NextLicense;
    }
    /**
     * Set NextLicense value
     * @param string $nextLicense
     * @return \StructType\Driver
     */
    public function setNextLicense($nextLicense = null)
    {
        // validation for constraint: string
        if (!is_null($nextLicense) && !is_string($nextLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextLicense)), __LINE__);
        }
        $this->NextLicense = $nextLicense;
        return $this;
    }
    /**
     * Get LicenseInterval value
     * @return string
     */
    public function getLicenseInterval()
    {
        return $this->LicenseInterval;
    }
    /**
     * Set LicenseInterval value
     * @param string $licenseInterval
     * @return \StructType\Driver
     */
    public function setLicenseInterval($licenseInterval = null)
    {
        // validation for constraint: string
        if (!is_null($licenseInterval) && !is_string($licenseInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseInterval)), __LINE__);
        }
        $this->LicenseInterval = $licenseInterval;
        return $this;
    }
    /**
     * Get LicenseRemind value
     * @return string
     */
    public function getLicenseRemind()
    {
        return $this->LicenseRemind;
    }
    /**
     * Set LicenseRemind value
     * @param string $licenseRemind
     * @return \StructType\Driver
     */
    public function setLicenseRemind($licenseRemind = null)
    {
        // validation for constraint: string
        if (!is_null($licenseRemind) && !is_string($licenseRemind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseRemind)), __LINE__);
        }
        $this->LicenseRemind = $licenseRemind;
        return $this;
    }
    /**
     * Get LicenseRemind2 value
     * @return string
     */
    public function getLicenseRemind2()
    {
        return $this->LicenseRemind2;
    }
    /**
     * Set LicenseRemind2 value
     * @param string $licenseRemind2
     * @return \StructType\Driver
     */
    public function setLicenseRemind2($licenseRemind2 = null)
    {
        // validation for constraint: string
        if (!is_null($licenseRemind2) && !is_string($licenseRemind2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseRemind2)), __LINE__);
        }
        $this->LicenseRemind2 = $licenseRemind2;
        return $this;
    }
    /**
     * Get DistanceChecked value
     * @return string
     */
    public function getDistanceChecked()
    {
        return $this->DistanceChecked;
    }
    /**
     * Set DistanceChecked value
     * @param string $distanceChecked
     * @return \StructType\Driver
     */
    public function setDistanceChecked($distanceChecked = null)
    {
        // validation for constraint: string
        if (!is_null($distanceChecked) && !is_string($distanceChecked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceChecked)), __LINE__);
        }
        $this->DistanceChecked = $distanceChecked;
        return $this;
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\Driver
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Updated value
     * @return string
     */
    public function getUpdated()
    {
        return $this->Updated;
    }
    /**
     * Set Updated value
     * @param string $updated
     * @return \StructType\Driver
     */
    public function setUpdated($updated = null)
    {
        // validation for constraint: string
        if (!is_null($updated) && !is_string($updated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated)), __LINE__);
        }
        $this->Updated = $updated;
        return $this;
    }
    /**
     * Get EmployeeNumber value
     * @return string|null
     */
    public function getEmployeeNumber()
    {
        return $this->EmployeeNumber;
    }
    /**
     * Set EmployeeNumber value
     * @param string $employeeNumber
     * @return \StructType\Driver
     */
    public function setEmployeeNumber($employeeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($employeeNumber) && !is_string($employeeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($employeeNumber)), __LINE__);
        }
        $this->EmployeeNumber = $employeeNumber;
        return $this;
    }
    /**
     * Get ExtendedID value
     * @return string|null
     */
    public function getExtendedID()
    {
        return $this->ExtendedID;
    }
    /**
     * Set ExtendedID value
     * @param string $extendedID
     * @return \StructType\Driver
     */
    public function setExtendedID($extendedID = null)
    {
        // validation for constraint: string
        if (!is_null($extendedID) && !is_string($extendedID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extendedID)), __LINE__);
        }
        $this->ExtendedID = $extendedID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Driver
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Driver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
