<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBasicDriver StructType
 * @subpackage Structs
 */
class AddBasicDriver extends AbstractStructBase
{
    /**
     * The DriverID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverID;
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SiteID;
    /**
     * The GroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupID;
    /**
     * The EmployeeNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmployeeNumber;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for AddBasicDriver
     * @uses AddBasicDriver::setDriverID()
     * @uses AddBasicDriver::setSiteID()
     * @uses AddBasicDriver::setGroupID()
     * @uses AddBasicDriver::setEmployeeNumber()
     * @uses AddBasicDriver::setName()
     * @param int $driverID
     * @param int $siteID
     * @param int $groupID
     * @param string $employeeNumber
     * @param string $name
     */
    public function __construct($driverID = null, $siteID = null, $groupID = null, $employeeNumber = null, $name = null)
    {
        $this
            ->setDriverID($driverID)
            ->setSiteID($siteID)
            ->setGroupID($groupID)
            ->setEmployeeNumber($employeeNumber)
            ->setName($name);
    }
    /**
     * Get DriverID value
     * @return int
     */
    public function getDriverID()
    {
        return $this->DriverID;
    }
    /**
     * Set DriverID value
     * @param int $driverID
     * @return \StructType\AddBasicDriver
     */
    public function setDriverID($driverID = null)
    {
        // validation for constraint: int
        if (!is_null($driverID) && !is_numeric($driverID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($driverID)), __LINE__);
        }
        $this->DriverID = $driverID;
        return $this;
    }
    /**
     * Get SiteID value
     * @return int
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param int $siteID
     * @return \StructType\AddBasicDriver
     */
    public function setSiteID($siteID = null)
    {
        // validation for constraint: int
        if (!is_null($siteID) && !is_numeric($siteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siteID)), __LINE__);
        }
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get GroupID value
     * @return int
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \StructType\AddBasicDriver
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !is_numeric($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get EmployeeNumber value
     * @return string|null
     */
    public function getEmployeeNumber()
    {
        return $this->EmployeeNumber;
    }
    /**
     * Set EmployeeNumber value
     * @param string $employeeNumber
     * @return \StructType\AddBasicDriver
     */
    public function setEmployeeNumber($employeeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($employeeNumber) && !is_string($employeeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($employeeNumber)), __LINE__);
        }
        $this->EmployeeNumber = $employeeNumber;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AddBasicDriver
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddBasicDriver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
