<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reporting ServiceType
 * @subpackage Services
 */
class Reporting extends AbstractSoapClientBase
{
    /**
     * Sets the TokenHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenHeader $tokenHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenHeader(\StructType\TokenHeader $tokenHeader, $nameSpace = 'http://www.omnibridge.com/SDKWebServices/AssetData', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TokenHeader', $tokenHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReportingGroupAddDriver
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * - documentation: Adds the specified driver to the specified driver reporting group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportingGroupAddDriver $parameters
     * @return \StructType\ReportingGroupAddDriverResponse|bool
     */
    public function ReportingGroupAddDriver(\StructType\ReportingGroupAddDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportingGroupAddDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportingGroupRemoveDriver
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * - documentation: Removes the specified driver from the specified driver reporting group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReportingGroupRemoveDriver $parameters
     * @return \StructType\ReportingGroupRemoveDriverResponse|bool
     */
    public function ReportingGroupRemoveDriver(\StructType\ReportingGroupRemoveDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportingGroupRemoveDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReportingGroupAddDriverResponse|\StructType\ReportingGroupRemoveDriverResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
