<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the TokenHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenHeader $tokenHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenHeader(\StructType\TokenHeader $tokenHeader, $nameSpace = 'http://www.omnibridge.com/SDKWebServices/AssetData', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TokenHeader', $tokenHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetDriver
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriver $parameters
     * @return \StructType\GetDriverResponse|bool
     */
    public function GetDriver(\StructType\GetDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverList $parameters
     * @return \StructType\GetDriverListResponse|bool
     */
    public function GetDriverList(\StructType\GetDriverList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverListFiltered
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverListFiltered $parameters
     * @return \StructType\GetDriverListFilteredResponse|bool
     */
    public function GetDriverListFiltered(\StructType\GetDriverListFiltered $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverListFiltered($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverScoresInDateRange
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverScoresInDateRange $parameters
     * @return \StructType\GetDriverScoresInDateRangeResponse|bool
     */
    public function GetDriverScoresInDateRange(\StructType\GetDriverScoresInDateRange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverScoresInDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverReportingGroupList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * - documentation: Returns a list of the driver reporting groups defined in the organisation. Group members are not included in the output.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverReportingGroupList $parameters
     * @return \StructType\GetDriverReportingGroupListResponse|bool
     */
    public function GetDriverReportingGroupList(\StructType\GetDriverReportingGroupList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverReportingGroupList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverReportingGroup
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * - documentation: Returns details, including a list of members, of the driver reporting group having the specified group ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverReportingGroup $parameters
     * @return \StructType\GetDriverReportingGroupResponse|bool
     */
    public function GetDriverReportingGroup(\StructType\GetDriverReportingGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverReportingGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDriverListFilteredResponse|\StructType\GetDriverListResponse|\StructType\GetDriverReportingGroupListResponse|\StructType\GetDriverReportingGroupResponse|\StructType\GetDriverResponse|\StructType\GetDriverScoresInDateRangeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
