<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the TokenHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenHeader $tokenHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenHeader(\StructType\TokenHeader $tokenHeader, $nameSpace = 'http://www.omnibridge.com/SDKWebServices/AssetData', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TokenHeader', $tokenHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddBasicDriver
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * - documentation: Add a new Driver using the minimal set of supplied properties.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddBasicDriver $parameters
     * @return \StructType\AddBasicDriverResponse|bool
     */
    public function AddBasicDriver(\StructType\AddBasicDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddBasicDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDriver
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * - documentation: Add a new Driver using the supplied entity.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDriver $parameters
     * @return \StructType\AddDriverResponse|bool
     */
    public function AddDriver(\StructType\AddDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddBasicDriverResponse|\StructType\AddDriverResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
