<?php

namespace EnumType;

/**
 * This class stands for DriverSearchOption EnumType
 * @subpackage Enumerations
 */
class DriverSearchOption
{
    /**
     * Constant for value 'DriverId'
     * @return string 'DriverId'
     */
    const VALUE_DRIVER_ID = 'DriverId';
    /**
     * Constant for value 'EmployeeNumber'
     * @return string 'EmployeeNumber'
     */
    const VALUE_EMPLOYEE_NUMBER = 'EmployeeNumber';
    /**
     * Constant for value 'Name'
     * @return string 'Name'
     */
    const VALUE_NAME = 'Name';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DRIVER_ID
     * @uses self::VALUE_EMPLOYEE_NUMBER
     * @uses self::VALUE_NAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DRIVER_ID,
            self::VALUE_EMPLOYEE_NUMBER,
            self::VALUE_NAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
