<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDriverScoresInDateRange StructType
 * @subpackage Structs
 */
class GetDriverScoresInDateRange extends AbstractStructBase
{
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToDate;
    /**
     * The DriverIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverIDs;
    /**
     * Constructor method for GetDriverScoresInDateRange
     * @uses GetDriverScoresInDateRange::setFromDate()
     * @uses GetDriverScoresInDateRange::setToDate()
     * @uses GetDriverScoresInDateRange::setDriverIDs()
     * @param string $fromDate
     * @param string $toDate
     * @param string $driverIDs
     */
    public function __construct($fromDate = null, $toDate = null, $driverIDs = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setDriverIDs($driverIDs);
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \StructType\GetDriverScoresInDateRange
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \StructType\GetDriverScoresInDateRange
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get DriverIDs value
     * @return string|null
     */
    public function getDriverIDs()
    {
        return $this->DriverIDs;
    }
    /**
     * Set DriverIDs value
     * @param string $driverIDs
     * @return \StructType\GetDriverScoresInDateRange
     */
    public function setDriverIDs($driverIDs = null)
    {
        // validation for constraint: string
        if (!is_null($driverIDs) && !is_string($driverIDs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverIDs)), __LINE__);
        }
        $this->DriverIDs = $driverIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDriverScoresInDateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
