<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDriver StructType
 * @subpackage Structs
 */
class GetDriver extends AbstractStructBase
{
    /**
     * The DriverID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverID;
    /**
     * Constructor method for GetDriver
     * @uses GetDriver::setDriverID()
     * @param int $driverID
     */
    public function __construct($driverID = null)
    {
        $this
            ->setDriverID($driverID);
    }
    /**
     * Get DriverID value
     * @return int
     */
    public function getDriverID()
    {
        return $this->DriverID;
    }
    /**
     * Set DriverID value
     * @param int $driverID
     * @return \StructType\GetDriver
     */
    public function setDriverID($driverID = null)
    {
        // validation for constraint: int
        if (!is_null($driverID) && !is_numeric($driverID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($driverID)), __LINE__);
        }
        $this->DriverID = $driverID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDriver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
