<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverReportingGroup StructType
 * @subpackage Structs
 */
class DriverReportingGroup extends AbstractStructBase
{
    /**
     * The GroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupID;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfReportingGroupMember
     */
    public $Drivers;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for DriverReportingGroup
     * @uses DriverReportingGroup::setGroupID()
     * @uses DriverReportingGroup::setDrivers()
     * @uses DriverReportingGroup::setName()
     * @uses DriverReportingGroup::setNotes()
     * @param int $groupID
     * @param \ArrayType\ArrayOfReportingGroupMember $drivers
     * @param string $name
     * @param string $notes
     */
    public function __construct($groupID = null, \ArrayType\ArrayOfReportingGroupMember $drivers = null, $name = null, $notes = null)
    {
        $this
            ->setGroupID($groupID)
            ->setDrivers($drivers)
            ->setName($name)
            ->setNotes($notes);
    }
    /**
     * Get GroupID value
     * @return int
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \StructType\DriverReportingGroup
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !is_numeric($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfReportingGroupMember|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfReportingGroupMember $drivers
     * @return \StructType\DriverReportingGroup
     */
    public function setDrivers(\ArrayType\ArrayOfReportingGroupMember $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\DriverReportingGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\DriverReportingGroup
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DriverReportingGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
