<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the TokenHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenHeader $tokenHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenHeader(\StructType\TokenHeader $tokenHeader, $nameSpace = 'http://www.omnibridge.com/SDKWebServices/AssetData', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TokenHeader', $tokenHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named DeleteDriver
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: TokenHeader
     * - SOAPHeaderNamespaces: http://www.omnibridge.com/SDKWebServices/AssetData
     * - SOAPHeaderTypes: \StructType\TokenHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteDriver $parameters
     * @return \StructType\DeleteDriverResponse|bool
     */
    public function DeleteDriver(\StructType\DeleteDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteDriverResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
