<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Informations ServiceType
 * @subpackage Services
 */
class Informations extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InformationsLicencie
     * Meta informations extracted from the WSDL
     * - documentation: Retourne les informations du licencié identifié par son numéro de licence
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $licenceCode
     * @return \StructType\InformationsLicencieResponse|bool
     */
    public function InformationsLicencie($licenceCode)
    {
        try {
            $this->setResult(self::getSoapClient()->InformationsLicencie($licenceCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InformationsLicencieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
