<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationsLicencieResponse StructType
 * @subpackage Structs
 */
class InformationsLicencieResponse extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The codeAdherent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codeAdherent;
    /**
     * The civilite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $civilite;
    /**
     * The prenom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prenom;
    /**
     * The nom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nom;
    /**
     * The dateNaissance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateNaissance;
    /**
     * The sexe
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sexe;
    /**
     * The etat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $etat;
    /**
     * The codeNationalite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codeNationalite;
    /**
     * The libelleNationalite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $libelleNationalite;
    /**
     * The ancienneteLicences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ancienneteLicences;
    /**
     * The adresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArrayAdresse[]
     */
    public $adresse;
    /**
     * The licences
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArrayLicences[]
     */
    public $licences;
    /**
     * The diplomes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArrayDiplomes[]
     */
    public $diplomes;
    /**
     * Constructor method for InformationsLicencieResponse
     * @uses InformationsLicencieResponse::setId()
     * @uses InformationsLicencieResponse::setCodeAdherent()
     * @uses InformationsLicencieResponse::setCivilite()
     * @uses InformationsLicencieResponse::setPrenom()
     * @uses InformationsLicencieResponse::setNom()
     * @uses InformationsLicencieResponse::setDateNaissance()
     * @uses InformationsLicencieResponse::setSexe()
     * @uses InformationsLicencieResponse::setEtat()
     * @uses InformationsLicencieResponse::setCodeNationalite()
     * @uses InformationsLicencieResponse::setLibelleNationalite()
     * @uses InformationsLicencieResponse::setAncienneteLicences()
     * @uses InformationsLicencieResponse::setAdresse()
     * @uses InformationsLicencieResponse::setLicences()
     * @uses InformationsLicencieResponse::setDiplomes()
     * @param string $id
     * @param string $codeAdherent
     * @param string $civilite
     * @param string $prenom
     * @param string $nom
     * @param string $dateNaissance
     * @param string $sexe
     * @param string $etat
     * @param string $codeNationalite
     * @param string $libelleNationalite
     * @param string $ancienneteLicences
     * @param \StructType\ArrayAdresse[] $adresse
     * @param \StructType\ArrayLicences[] $licences
     * @param \StructType\ArrayDiplomes[] $diplomes
     */
    public function __construct($id = null, $codeAdherent = null, $civilite = null, $prenom = null, $nom = null, $dateNaissance = null, $sexe = null, $etat = null, $codeNationalite = null, $libelleNationalite = null, $ancienneteLicences = null, array $adresse = array(), array $licences = array(), array $diplomes = array())
    {
        $this
            ->setId($id)
            ->setCodeAdherent($codeAdherent)
            ->setCivilite($civilite)
            ->setPrenom($prenom)
            ->setNom($nom)
            ->setDateNaissance($dateNaissance)
            ->setSexe($sexe)
            ->setEtat($etat)
            ->setCodeNationalite($codeNationalite)
            ->setLibelleNationalite($libelleNationalite)
            ->setAncienneteLicences($ancienneteLicences)
            ->setAdresse($adresse)
            ->setLicences($licences)
            ->setDiplomes($diplomes);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\InformationsLicencieResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get codeAdherent value
     * @return string|null
     */
    public function getCodeAdherent()
    {
        return $this->codeAdherent;
    }
    /**
     * Set codeAdherent value
     * @param string $codeAdherent
     * @return \StructType\InformationsLicencieResponse
     */
    public function setCodeAdherent($codeAdherent = null)
    {
        // validation for constraint: string
        if (!is_null($codeAdherent) && !is_string($codeAdherent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeAdherent)), __LINE__);
        }
        $this->codeAdherent = $codeAdherent;
        return $this;
    }
    /**
     * Get civilite value
     * @return string|null
     */
    public function getCivilite()
    {
        return $this->civilite;
    }
    /**
     * Set civilite value
     * @param string $civilite
     * @return \StructType\InformationsLicencieResponse
     */
    public function setCivilite($civilite = null)
    {
        // validation for constraint: string
        if (!is_null($civilite) && !is_string($civilite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($civilite)), __LINE__);
        }
        $this->civilite = $civilite;
        return $this;
    }
    /**
     * Get prenom value
     * @return string|null
     */
    public function getPrenom()
    {
        return $this->prenom;
    }
    /**
     * Set prenom value
     * @param string $prenom
     * @return \StructType\InformationsLicencieResponse
     */
    public function setPrenom($prenom = null)
    {
        // validation for constraint: string
        if (!is_null($prenom) && !is_string($prenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prenom)), __LINE__);
        }
        $this->prenom = $prenom;
        return $this;
    }
    /**
     * Get nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->nom;
    }
    /**
     * Set nom value
     * @param string $nom
     * @return \StructType\InformationsLicencieResponse
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nom)), __LINE__);
        }
        $this->nom = $nom;
        return $this;
    }
    /**
     * Get dateNaissance value
     * @return string|null
     */
    public function getDateNaissance()
    {
        return $this->dateNaissance;
    }
    /**
     * Set dateNaissance value
     * @param string $dateNaissance
     * @return \StructType\InformationsLicencieResponse
     */
    public function setDateNaissance($dateNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($dateNaissance) && !is_string($dateNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateNaissance)), __LINE__);
        }
        $this->dateNaissance = $dateNaissance;
        return $this;
    }
    /**
     * Get sexe value
     * @return string|null
     */
    public function getSexe()
    {
        return $this->sexe;
    }
    /**
     * Set sexe value
     * @param string $sexe
     * @return \StructType\InformationsLicencieResponse
     */
    public function setSexe($sexe = null)
    {
        // validation for constraint: string
        if (!is_null($sexe) && !is_string($sexe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sexe)), __LINE__);
        }
        $this->sexe = $sexe;
        return $this;
    }
    /**
     * Get etat value
     * @return string|null
     */
    public function getEtat()
    {
        return $this->etat;
    }
    /**
     * Set etat value
     * @param string $etat
     * @return \StructType\InformationsLicencieResponse
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: string
        if (!is_null($etat) && !is_string($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($etat)), __LINE__);
        }
        $this->etat = $etat;
        return $this;
    }
    /**
     * Get codeNationalite value
     * @return string|null
     */
    public function getCodeNationalite()
    {
        return $this->codeNationalite;
    }
    /**
     * Set codeNationalite value
     * @param string $codeNationalite
     * @return \StructType\InformationsLicencieResponse
     */
    public function setCodeNationalite($codeNationalite = null)
    {
        // validation for constraint: string
        if (!is_null($codeNationalite) && !is_string($codeNationalite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeNationalite)), __LINE__);
        }
        $this->codeNationalite = $codeNationalite;
        return $this;
    }
    /**
     * Get libelleNationalite value
     * @return string|null
     */
    public function getLibelleNationalite()
    {
        return $this->libelleNationalite;
    }
    /**
     * Set libelleNationalite value
     * @param string $libelleNationalite
     * @return \StructType\InformationsLicencieResponse
     */
    public function setLibelleNationalite($libelleNationalite = null)
    {
        // validation for constraint: string
        if (!is_null($libelleNationalite) && !is_string($libelleNationalite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleNationalite)), __LINE__);
        }
        $this->libelleNationalite = $libelleNationalite;
        return $this;
    }
    /**
     * Get ancienneteLicences value
     * @return string|null
     */
    public function getAncienneteLicences()
    {
        return $this->ancienneteLicences;
    }
    /**
     * Set ancienneteLicences value
     * @param string $ancienneteLicences
     * @return \StructType\InformationsLicencieResponse
     */
    public function setAncienneteLicences($ancienneteLicences = null)
    {
        // validation for constraint: string
        if (!is_null($ancienneteLicences) && !is_string($ancienneteLicences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ancienneteLicences)), __LINE__);
        }
        $this->ancienneteLicences = $ancienneteLicences;
        return $this;
    }
    /**
     * Get adresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArrayAdresse[]|null
     */
    public function getAdresse()
    {
        return isset($this->adresse) ? $this->adresse : null;
    }
    /**
     * Set adresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArrayAdresse[] $adresse
     * @return \StructType\InformationsLicencieResponse
     */
    public function setAdresse(array $adresse = array())
    {
        foreach ($adresse as $informationsLicencieResponseAdresseItem) {
            // validation for constraint: itemType
            if (!$informationsLicencieResponseAdresseItem instanceof \StructType\ArrayAdresse) {
                throw new \InvalidArgumentException(sprintf('The adresse property can only contain items of \StructType\ArrayAdresse, "%s" given', is_object($informationsLicencieResponseAdresseItem) ? get_class($informationsLicencieResponseAdresseItem) : gettype($informationsLicencieResponseAdresseItem)), __LINE__);
            }
        }
        if (is_null($adresse) || (is_array($adresse) && empty($adresse))) {
            unset($this->adresse);
        } else {
            $this->adresse = $adresse;
        }
        return $this;
    }
    /**
     * Add item to adresse value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrayAdresse $item
     * @return \StructType\InformationsLicencieResponse
     */
    public function addToAdresse(\StructType\ArrayAdresse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArrayAdresse) {
            throw new \InvalidArgumentException(sprintf('The adresse property can only contain items of \StructType\ArrayAdresse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->adresse[] = $item;
        return $this;
    }
    /**
     * Get licences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArrayLicences[]|null
     */
    public function getLicences()
    {
        return isset($this->licences) ? $this->licences : null;
    }
    /**
     * Set licences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArrayLicences[] $licences
     * @return \StructType\InformationsLicencieResponse
     */
    public function setLicences(array $licences = array())
    {
        foreach ($licences as $informationsLicencieResponseLicencesItem) {
            // validation for constraint: itemType
            if (!$informationsLicencieResponseLicencesItem instanceof \StructType\ArrayLicences) {
                throw new \InvalidArgumentException(sprintf('The licences property can only contain items of \StructType\ArrayLicences, "%s" given', is_object($informationsLicencieResponseLicencesItem) ? get_class($informationsLicencieResponseLicencesItem) : gettype($informationsLicencieResponseLicencesItem)), __LINE__);
            }
        }
        if (is_null($licences) || (is_array($licences) && empty($licences))) {
            unset($this->licences);
        } else {
            $this->licences = $licences;
        }
        return $this;
    }
    /**
     * Add item to licences value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrayLicences $item
     * @return \StructType\InformationsLicencieResponse
     */
    public function addToLicences(\StructType\ArrayLicences $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArrayLicences) {
            throw new \InvalidArgumentException(sprintf('The licences property can only contain items of \StructType\ArrayLicences, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->licences[] = $item;
        return $this;
    }
    /**
     * Get diplomes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArrayDiplomes[]|null
     */
    public function getDiplomes()
    {
        return isset($this->diplomes) ? $this->diplomes : null;
    }
    /**
     * Set diplomes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArrayDiplomes[] $diplomes
     * @return \StructType\InformationsLicencieResponse
     */
    public function setDiplomes(array $diplomes = array())
    {
        foreach ($diplomes as $informationsLicencieResponseDiplomesItem) {
            // validation for constraint: itemType
            if (!$informationsLicencieResponseDiplomesItem instanceof \StructType\ArrayDiplomes) {
                throw new \InvalidArgumentException(sprintf('The diplomes property can only contain items of \StructType\ArrayDiplomes, "%s" given', is_object($informationsLicencieResponseDiplomesItem) ? get_class($informationsLicencieResponseDiplomesItem) : gettype($informationsLicencieResponseDiplomesItem)), __LINE__);
            }
        }
        if (is_null($diplomes) || (is_array($diplomes) && empty($diplomes))) {
            unset($this->diplomes);
        } else {
            $this->diplomes = $diplomes;
        }
        return $this;
    }
    /**
     * Add item to diplomes value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrayDiplomes $item
     * @return \StructType\InformationsLicencieResponse
     */
    public function addToDiplomes(\StructType\ArrayDiplomes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArrayDiplomes) {
            throw new \InvalidArgumentException(sprintf('The diplomes property can only contain items of \StructType\ArrayDiplomes, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->diplomes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InformationsLicencieResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
