<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SendInvoiceRequest
 * @subpackage Structs
 */
class SendInvoiceRequest extends REQUEST
{
    /**
     * The SENDER
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SENDER
     */
    public $SENDER;
    /**
     * The RECEIVER
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RECEIVER
     */
    public $RECEIVER;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * Constructor method for SendInvoiceRequest
     * @uses SendInvoiceRequest::setSENDER()
     * @uses SendInvoiceRequest::setRECEIVER()
     * @uses SendInvoiceRequest::setINVOICE()
     * @param \StructType\SENDER $sENDER
     * @param \StructType\RECEIVER $rECEIVER
     * @param \StructType\INVOICE[] $iNVOICE
     */
    public function __construct(\StructType\SENDER $sENDER = null, \StructType\RECEIVER $rECEIVER = null, array $iNVOICE = array())
    {
        $this
            ->setSENDER($sENDER)
            ->setRECEIVER($rECEIVER)
            ->setINVOICE($iNVOICE);
    }
    /**
     * Get SENDER value
     * @return \StructType\SENDER|null
     */
    public function getSENDER()
    {
        return $this->SENDER;
    }
    /**
     * Set SENDER value
     * @param \StructType\SENDER $sENDER
     * @return \StructType\SendInvoiceRequest
     */
    public function setSENDER(\StructType\SENDER $sENDER = null)
    {
        $this->SENDER = $sENDER;
        return $this;
    }
    /**
     * Get RECEIVER value
     * @return \StructType\RECEIVER|null
     */
    public function getRECEIVER()
    {
        return $this->RECEIVER;
    }
    /**
     * Set RECEIVER value
     * @param \StructType\RECEIVER $rECEIVER
     * @return \StructType\SendInvoiceRequest
     */
    public function setRECEIVER(\StructType\RECEIVER $rECEIVER = null)
    {
        $this->RECEIVER = $rECEIVER;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\SendInvoiceRequest
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $sendInvoiceRequestINVOICEItem) {
            // validation for constraint: itemType
            if (!$sendInvoiceRequestINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($sendInvoiceRequestINVOICEItem) ? get_class($sendInvoiceRequestINVOICEItem) : gettype($sendInvoiceRequestINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\SendInvoiceRequest
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
