<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareInvoiceResponseRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PrepareInvoiceResponseRequest
 * @subpackage Structs
 */
class PrepareInvoiceResponseRequest extends REQUEST
{
    /**
     * The STATUS
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $STATUS;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The DESCRIPTION
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DESCRIPTION;
    /**
     * Constructor method for PrepareInvoiceResponseRequest
     * @uses PrepareInvoiceResponseRequest::setSTATUS()
     * @uses PrepareInvoiceResponseRequest::setINVOICE()
     * @uses PrepareInvoiceResponseRequest::setDESCRIPTION()
     * @param string $sTATUS
     * @param \StructType\INVOICE[] $iNVOICE
     * @param string[] $dESCRIPTION
     */
    public function __construct($sTATUS = null, array $iNVOICE = array(), array $dESCRIPTION = array())
    {
        $this
            ->setSTATUS($sTATUS)
            ->setINVOICE($iNVOICE)
            ->setDESCRIPTION($dESCRIPTION);
    }
    /**
     * Get STATUS value
     * @return string|null
     */
    public function getSTATUS()
    {
        return $this->STATUS;
    }
    /**
     * Set STATUS value
     * @param string $sTATUS
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function setSTATUS($sTATUS = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS) && !is_string($sTATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTATUS)), __LINE__);
        }
        $this->STATUS = $sTATUS;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $prepareInvoiceResponseRequestINVOICEItem) {
            // validation for constraint: itemType
            if (!$prepareInvoiceResponseRequestINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($prepareInvoiceResponseRequestINVOICEItem) ? get_class($prepareInvoiceResponseRequestINVOICEItem) : gettype($prepareInvoiceResponseRequestINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get DESCRIPTION value
     * @return string[]|null
     */
    public function getDESCRIPTION()
    {
        return $this->DESCRIPTION;
    }
    /**
     * Set DESCRIPTION value
     * @throws \InvalidArgumentException
     * @param string[] $dESCRIPTION
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function setDESCRIPTION(array $dESCRIPTION = array())
    {
        foreach ($dESCRIPTION as $prepareInvoiceResponseRequestDESCRIPTIONItem) {
            // validation for constraint: itemType
            if (!is_string($prepareInvoiceResponseRequestDESCRIPTIONItem)) {
                throw new \InvalidArgumentException(sprintf('The DESCRIPTION property can only contain items of string, "%s" given', is_object($prepareInvoiceResponseRequestDESCRIPTIONItem) ? get_class($prepareInvoiceResponseRequestDESCRIPTIONItem) : gettype($prepareInvoiceResponseRequestDESCRIPTIONItem)), __LINE__);
            }
        }
        $this->DESCRIPTION = $dESCRIPTION;
        return $this;
    }
    /**
     * Add item to DESCRIPTION value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public function addToDESCRIPTION($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DESCRIPTION property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DESCRIPTION[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepareInvoiceResponseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
