<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetInvoiceRequest
 * @subpackage Structs
 */
class GetInvoiceRequest extends REQUEST
{
    /**
     * The INVOICE_CONTENT_TYPE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $INVOICE_CONTENT_TYPE;
    /**
     * The INVOICE_SEARCH_KEY
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\INVOICE_SEARCH_KEY
     */
    public $INVOICE_SEARCH_KEY;
    /**
     * The HEADER_ONLY
     * Meta informations extracted from the WSDL
     * - default: N
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HEADER_ONLY;
    /**
     * Constructor method for GetInvoiceRequest
     * @uses GetInvoiceRequest::setINVOICE_CONTENT_TYPE()
     * @uses GetInvoiceRequest::setINVOICE_SEARCH_KEY()
     * @uses GetInvoiceRequest::setHEADER_ONLY()
     * @param string $iNVOICE_CONTENT_TYPE
     * @param \StructType\INVOICE_SEARCH_KEY $iNVOICE_SEARCH_KEY
     * @param string $hEADER_ONLY
     */
    public function __construct($iNVOICE_CONTENT_TYPE = null, \StructType\INVOICE_SEARCH_KEY $iNVOICE_SEARCH_KEY = null, $hEADER_ONLY = 'N')
    {
        $this
            ->setINVOICE_CONTENT_TYPE($iNVOICE_CONTENT_TYPE)
            ->setINVOICE_SEARCH_KEY($iNVOICE_SEARCH_KEY)
            ->setHEADER_ONLY($hEADER_ONLY);
    }
    /**
     * Get INVOICE_CONTENT_TYPE value
     * @return string
     */
    public function getINVOICE_CONTENT_TYPE()
    {
        return $this->INVOICE_CONTENT_TYPE;
    }
    /**
     * Set INVOICE_CONTENT_TYPE value
     * @uses \EnumType\INVOICE_CONTENT_TYPE::valueIsValid()
     * @uses \EnumType\INVOICE_CONTENT_TYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iNVOICE_CONTENT_TYPE
     * @return \StructType\GetInvoiceRequest
     */
    public function setINVOICE_CONTENT_TYPE($iNVOICE_CONTENT_TYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\INVOICE_CONTENT_TYPE::valueIsValid($iNVOICE_CONTENT_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iNVOICE_CONTENT_TYPE, implode(', ', \EnumType\INVOICE_CONTENT_TYPE::getValidValues())), __LINE__);
        }
        $this->INVOICE_CONTENT_TYPE = $iNVOICE_CONTENT_TYPE;
        return $this;
    }
    /**
     * Get INVOICE_SEARCH_KEY value
     * @return \StructType\INVOICE_SEARCH_KEY|null
     */
    public function getINVOICE_SEARCH_KEY()
    {
        return $this->INVOICE_SEARCH_KEY;
    }
    /**
     * Set INVOICE_SEARCH_KEY value
     * @param \StructType\INVOICE_SEARCH_KEY $iNVOICE_SEARCH_KEY
     * @return \StructType\GetInvoiceRequest
     */
    public function setINVOICE_SEARCH_KEY(\StructType\INVOICE_SEARCH_KEY $iNVOICE_SEARCH_KEY = null)
    {
        $this->INVOICE_SEARCH_KEY = $iNVOICE_SEARCH_KEY;
        return $this;
    }
    /**
     * Get HEADER_ONLY value
     * @return string|null
     */
    public function getHEADER_ONLY()
    {
        return $this->HEADER_ONLY;
    }
    /**
     * Set HEADER_ONLY value
     * @param string $hEADER_ONLY
     * @return \StructType\GetInvoiceRequest
     */
    public function setHEADER_ONLY($hEADER_ONLY = 'N')
    {
        // validation for constraint: string
        if (!is_null($hEADER_ONLY) && !is_string($hEADER_ONLY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hEADER_ONLY)), __LINE__);
        }
        $this->HEADER_ONLY = $hEADER_ONLY;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
