<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:EmailInvoiceRequest
 * @subpackage Structs
 */
class EmailInvoiceRequest extends REQUEST
{
    /**
     * The INVOICE_CONTENT_TYPE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $INVOICE_CONTENT_TYPE;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The EMAILS
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMAILS;
    /**
     * Constructor method for EmailInvoiceRequest
     * @uses EmailInvoiceRequest::setINVOICE_CONTENT_TYPE()
     * @uses EmailInvoiceRequest::setINVOICE()
     * @uses EmailInvoiceRequest::setEMAILS()
     * @param string $iNVOICE_CONTENT_TYPE
     * @param \StructType\INVOICE[] $iNVOICE
     * @param string $eMAILS
     */
    public function __construct($iNVOICE_CONTENT_TYPE = null, array $iNVOICE = array(), $eMAILS = null)
    {
        $this
            ->setINVOICE_CONTENT_TYPE($iNVOICE_CONTENT_TYPE)
            ->setINVOICE($iNVOICE)
            ->setEMAILS($eMAILS);
    }
    /**
     * Get INVOICE_CONTENT_TYPE value
     * @return string
     */
    public function getINVOICE_CONTENT_TYPE()
    {
        return $this->INVOICE_CONTENT_TYPE;
    }
    /**
     * Set INVOICE_CONTENT_TYPE value
     * @uses \EnumType\INVOICE_CONTENT_TYPE::valueIsValid()
     * @uses \EnumType\INVOICE_CONTENT_TYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iNVOICE_CONTENT_TYPE
     * @return \StructType\EmailInvoiceRequest
     */
    public function setINVOICE_CONTENT_TYPE($iNVOICE_CONTENT_TYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\INVOICE_CONTENT_TYPE::valueIsValid($iNVOICE_CONTENT_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iNVOICE_CONTENT_TYPE, implode(', ', \EnumType\INVOICE_CONTENT_TYPE::getValidValues())), __LINE__);
        }
        $this->INVOICE_CONTENT_TYPE = $iNVOICE_CONTENT_TYPE;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\EmailInvoiceRequest
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $emailInvoiceRequestINVOICEItem) {
            // validation for constraint: itemType
            if (!$emailInvoiceRequestINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($emailInvoiceRequestINVOICEItem) ? get_class($emailInvoiceRequestINVOICEItem) : gettype($emailInvoiceRequestINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\EmailInvoiceRequest
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get EMAILS value
     * @return string|null
     */
    public function getEMAILS()
    {
        return $this->EMAILS;
    }
    /**
     * Set EMAILS value
     * @param string $eMAILS
     * @return \StructType\EmailInvoiceRequest
     */
    public function setEMAILS($eMAILS = null)
    {
        // validation for constraint: string
        if (!is_null($eMAILS) && !is_string($eMAILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMAILS)), __LINE__);
        }
        $this->EMAILS = $eMAILS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmailInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
