<?php

namespace EnumType;

/**
 * This class stands for INVOICE_CONTENT_TYPE EnumType
 * @subpackage Enumerations
 */
class INVOICE_CONTENT_TYPE
{
    /**
     * Constant for value 'XML'
     * @return string 'XML'
     */
    const VALUE_XML = 'XML';
    /**
     * Constant for value 'PDF'
     * @return string 'PDF'
     */
    const VALUE_PDF = 'PDF';
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_XML
     * @uses self::VALUE_PDF
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_XML,
            self::VALUE_PDF,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
