<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for REQUEST_HEADERType StructType
 * @subpackage Structs
 */
class REQUEST_HEADERType extends AbstractStructBase
{
    /**
     * The SESSION_ID
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SESSION_ID;
    /**
     * The CLIENT_TXN_ID
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CLIENT_TXN_ID;
    /**
     * The INTL_TXN_ID
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $INTL_TXN_ID;
    /**
     * The INTL_PARENT_TXN_ID
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $INTL_PARENT_TXN_ID;
    /**
     * The ACTION_DATE
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ACTION_DATE;
    /**
     * The CHANGE_INFO
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CHANGE_INFOType
     */
    public $CHANGE_INFO;
    /**
     * The REASON
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $REASON;
    /**
     * The APPLICATION_NAME
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APPLICATION_NAME;
    /**
     * The HOSTNAME
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HOSTNAME;
    /**
     * The CHANNEL_NAME
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CHANNEL_NAME;
    /**
     * The SIMULATION_FLAG
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SIMULATION_FLAG;
    /**
     * The COMPRESSED
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COMPRESSED;
    /**
     * The ATTRIBUTES
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ATTRIBUTESTYPE[]
     */
    public $ATTRIBUTES;
    /**
     * Constructor method for REQUEST_HEADERType
     * @uses REQUEST_HEADERType::setSESSION_ID()
     * @uses REQUEST_HEADERType::setCLIENT_TXN_ID()
     * @uses REQUEST_HEADERType::setINTL_TXN_ID()
     * @uses REQUEST_HEADERType::setINTL_PARENT_TXN_ID()
     * @uses REQUEST_HEADERType::setACTION_DATE()
     * @uses REQUEST_HEADERType::setCHANGE_INFO()
     * @uses REQUEST_HEADERType::setREASON()
     * @uses REQUEST_HEADERType::setAPPLICATION_NAME()
     * @uses REQUEST_HEADERType::setHOSTNAME()
     * @uses REQUEST_HEADERType::setCHANNEL_NAME()
     * @uses REQUEST_HEADERType::setSIMULATION_FLAG()
     * @uses REQUEST_HEADERType::setCOMPRESSED()
     * @uses REQUEST_HEADERType::setATTRIBUTES()
     * @param string $sESSION_ID
     * @param string $cLIENT_TXN_ID
     * @param int $iNTL_TXN_ID
     * @param int $iNTL_PARENT_TXN_ID
     * @param string $aCTION_DATE
     * @param \StructType\CHANGE_INFOType $cHANGE_INFO
     * @param string $rEASON
     * @param string $aPPLICATION_NAME
     * @param string $hOSTNAME
     * @param string $cHANNEL_NAME
     * @param string $sIMULATION_FLAG
     * @param string $cOMPRESSED
     * @param \StructType\ATTRIBUTESTYPE[] $aTTRIBUTES
     */
    public function __construct($sESSION_ID = null, $cLIENT_TXN_ID = null, $iNTL_TXN_ID = null, $iNTL_PARENT_TXN_ID = null, $aCTION_DATE = null, \StructType\CHANGE_INFOType $cHANGE_INFO = null, $rEASON = null, $aPPLICATION_NAME = null, $hOSTNAME = null, $cHANNEL_NAME = null, $sIMULATION_FLAG = null, $cOMPRESSED = null, array $aTTRIBUTES = array())
    {
        $this
            ->setSESSION_ID($sESSION_ID)
            ->setCLIENT_TXN_ID($cLIENT_TXN_ID)
            ->setINTL_TXN_ID($iNTL_TXN_ID)
            ->setINTL_PARENT_TXN_ID($iNTL_PARENT_TXN_ID)
            ->setACTION_DATE($aCTION_DATE)
            ->setCHANGE_INFO($cHANGE_INFO)
            ->setREASON($rEASON)
            ->setAPPLICATION_NAME($aPPLICATION_NAME)
            ->setHOSTNAME($hOSTNAME)
            ->setCHANNEL_NAME($cHANNEL_NAME)
            ->setSIMULATION_FLAG($sIMULATION_FLAG)
            ->setCOMPRESSED($cOMPRESSED)
            ->setATTRIBUTES($aTTRIBUTES);
    }
    /**
     * Get SESSION_ID value
     * @return string|null
     */
    public function getSESSION_ID()
    {
        return $this->SESSION_ID;
    }
    /**
     * Set SESSION_ID value
     * @param string $sESSION_ID
     * @return \StructType\REQUEST_HEADERType
     */
    public function setSESSION_ID($sESSION_ID = null)
    {
        // validation for constraint: string
        if (!is_null($sESSION_ID) && !is_string($sESSION_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sESSION_ID)), __LINE__);
        }
        $this->SESSION_ID = $sESSION_ID;
        return $this;
    }
    /**
     * Get CLIENT_TXN_ID value
     * @return string|null
     */
    public function getCLIENT_TXN_ID()
    {
        return $this->CLIENT_TXN_ID;
    }
    /**
     * Set CLIENT_TXN_ID value
     * @param string $cLIENT_TXN_ID
     * @return \StructType\REQUEST_HEADERType
     */
    public function setCLIENT_TXN_ID($cLIENT_TXN_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cLIENT_TXN_ID) && !is_string($cLIENT_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLIENT_TXN_ID)), __LINE__);
        }
        $this->CLIENT_TXN_ID = $cLIENT_TXN_ID;
        return $this;
    }
    /**
     * Get INTL_TXN_ID value
     * @return int|null
     */
    public function getINTL_TXN_ID()
    {
        return $this->INTL_TXN_ID;
    }
    /**
     * Set INTL_TXN_ID value
     * @param int $iNTL_TXN_ID
     * @return \StructType\REQUEST_HEADERType
     */
    public function setINTL_TXN_ID($iNTL_TXN_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iNTL_TXN_ID) && !is_numeric($iNTL_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iNTL_TXN_ID)), __LINE__);
        }
        $this->INTL_TXN_ID = $iNTL_TXN_ID;
        return $this;
    }
    /**
     * Get INTL_PARENT_TXN_ID value
     * @return int|null
     */
    public function getINTL_PARENT_TXN_ID()
    {
        return $this->INTL_PARENT_TXN_ID;
    }
    /**
     * Set INTL_PARENT_TXN_ID value
     * @param int $iNTL_PARENT_TXN_ID
     * @return \StructType\REQUEST_HEADERType
     */
    public function setINTL_PARENT_TXN_ID($iNTL_PARENT_TXN_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iNTL_PARENT_TXN_ID) && !is_numeric($iNTL_PARENT_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iNTL_PARENT_TXN_ID)), __LINE__);
        }
        $this->INTL_PARENT_TXN_ID = $iNTL_PARENT_TXN_ID;
        return $this;
    }
    /**
     * Get ACTION_DATE value
     * @return string|null
     */
    public function getACTION_DATE()
    {
        return $this->ACTION_DATE;
    }
    /**
     * Set ACTION_DATE value
     * @param string $aCTION_DATE
     * @return \StructType\REQUEST_HEADERType
     */
    public function setACTION_DATE($aCTION_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aCTION_DATE) && !is_string($aCTION_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCTION_DATE)), __LINE__);
        }
        $this->ACTION_DATE = $aCTION_DATE;
        return $this;
    }
    /**
     * Get CHANGE_INFO value
     * @return \StructType\CHANGE_INFOType|null
     */
    public function getCHANGE_INFO()
    {
        return $this->CHANGE_INFO;
    }
    /**
     * Set CHANGE_INFO value
     * @param \StructType\CHANGE_INFOType $cHANGE_INFO
     * @return \StructType\REQUEST_HEADERType
     */
    public function setCHANGE_INFO(\StructType\CHANGE_INFOType $cHANGE_INFO = null)
    {
        $this->CHANGE_INFO = $cHANGE_INFO;
        return $this;
    }
    /**
     * Get REASON value
     * @return string|null
     */
    public function getREASON()
    {
        return $this->REASON;
    }
    /**
     * Set REASON value
     * @param string $rEASON
     * @return \StructType\REQUEST_HEADERType
     */
    public function setREASON($rEASON = null)
    {
        // validation for constraint: string
        if (!is_null($rEASON) && !is_string($rEASON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rEASON)), __LINE__);
        }
        $this->REASON = $rEASON;
        return $this;
    }
    /**
     * Get APPLICATION_NAME value
     * @return string|null
     */
    public function getAPPLICATION_NAME()
    {
        return $this->APPLICATION_NAME;
    }
    /**
     * Set APPLICATION_NAME value
     * @param string $aPPLICATION_NAME
     * @return \StructType\REQUEST_HEADERType
     */
    public function setAPPLICATION_NAME($aPPLICATION_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($aPPLICATION_NAME) && !is_string($aPPLICATION_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPPLICATION_NAME)), __LINE__);
        }
        $this->APPLICATION_NAME = $aPPLICATION_NAME;
        return $this;
    }
    /**
     * Get HOSTNAME value
     * @return string|null
     */
    public function getHOSTNAME()
    {
        return $this->HOSTNAME;
    }
    /**
     * Set HOSTNAME value
     * @param string $hOSTNAME
     * @return \StructType\REQUEST_HEADERType
     */
    public function setHOSTNAME($hOSTNAME = null)
    {
        // validation for constraint: string
        if (!is_null($hOSTNAME) && !is_string($hOSTNAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hOSTNAME)), __LINE__);
        }
        $this->HOSTNAME = $hOSTNAME;
        return $this;
    }
    /**
     * Get CHANNEL_NAME value
     * @return string|null
     */
    public function getCHANNEL_NAME()
    {
        return $this->CHANNEL_NAME;
    }
    /**
     * Set CHANNEL_NAME value
     * @param string $cHANNEL_NAME
     * @return \StructType\REQUEST_HEADERType
     */
    public function setCHANNEL_NAME($cHANNEL_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($cHANNEL_NAME) && !is_string($cHANNEL_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cHANNEL_NAME)), __LINE__);
        }
        $this->CHANNEL_NAME = $cHANNEL_NAME;
        return $this;
    }
    /**
     * Get SIMULATION_FLAG value
     * @return string|null
     */
    public function getSIMULATION_FLAG()
    {
        return $this->SIMULATION_FLAG;
    }
    /**
     * Set SIMULATION_FLAG value
     * @param string $sIMULATION_FLAG
     * @return \StructType\REQUEST_HEADERType
     */
    public function setSIMULATION_FLAG($sIMULATION_FLAG = null)
    {
        // validation for constraint: string
        if (!is_null($sIMULATION_FLAG) && !is_string($sIMULATION_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIMULATION_FLAG)), __LINE__);
        }
        $this->SIMULATION_FLAG = $sIMULATION_FLAG;
        return $this;
    }
    /**
     * Get COMPRESSED value
     * @return string|null
     */
    public function getCOMPRESSED()
    {
        return $this->COMPRESSED;
    }
    /**
     * Set COMPRESSED value
     * @param string $cOMPRESSED
     * @return \StructType\REQUEST_HEADERType
     */
    public function setCOMPRESSED($cOMPRESSED = null)
    {
        // validation for constraint: string
        if (!is_null($cOMPRESSED) && !is_string($cOMPRESSED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPRESSED)), __LINE__);
        }
        $this->COMPRESSED = $cOMPRESSED;
        return $this;
    }
    /**
     * Get ATTRIBUTES value
     * @return \StructType\ATTRIBUTESTYPE[]|null
     */
    public function getATTRIBUTES()
    {
        return $this->ATTRIBUTES;
    }
    /**
     * Set ATTRIBUTES value
     * @throws \InvalidArgumentException
     * @param \StructType\ATTRIBUTESTYPE[] $aTTRIBUTES
     * @return \StructType\REQUEST_HEADERType
     */
    public function setATTRIBUTES(array $aTTRIBUTES = array())
    {
        foreach ($aTTRIBUTES as $rEQUEST_HEADERTypeATTRIBUTESItem) {
            // validation for constraint: itemType
            if (!$rEQUEST_HEADERTypeATTRIBUTESItem instanceof \StructType\ATTRIBUTESTYPE) {
                throw new \InvalidArgumentException(sprintf('The ATTRIBUTES property can only contain items of \StructType\ATTRIBUTESTYPE, "%s" given', is_object($rEQUEST_HEADERTypeATTRIBUTESItem) ? get_class($rEQUEST_HEADERTypeATTRIBUTESItem) : gettype($rEQUEST_HEADERTypeATTRIBUTESItem)), __LINE__);
            }
        }
        $this->ATTRIBUTES = $aTTRIBUTES;
        return $this;
    }
    /**
     * Add item to ATTRIBUTES value
     * @throws \InvalidArgumentException
     * @param \StructType\ATTRIBUTESTYPE $item
     * @return \StructType\REQUEST_HEADERType
     */
    public function addToATTRIBUTES(\StructType\ATTRIBUTESTYPE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ATTRIBUTESTYPE) {
            throw new \InvalidArgumentException(sprintf('The ATTRIBUTES property can only contain items of \StructType\ATTRIBUTESTYPE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ATTRIBUTES[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\REQUEST_HEADERType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
