<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICE StructType
 * @subpackage Structs
 */
class INVOICE extends AbstractStructBase
{
    /**
     * The TRXID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TRXID;
    /**
     * The HEADER
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HEADER
     */
    public $HEADER;
    /**
     * The CONTENT
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Base64Binary
     */
    public $CONTENT;
    /**
     * The UUID
     * @var string
     */
    public $UUID;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for INVOICE
     * @uses INVOICE::setTRXID()
     * @uses INVOICE::setHEADER()
     * @uses INVOICE::setCONTENT()
     * @uses INVOICE::setUUID()
     * @uses INVOICE::setID()
     * @param int $tRXID
     * @param \StructType\HEADER $hEADER
     * @param \StructType\Base64Binary $cONTENT
     * @param string $uUID
     * @param string $iD
     */
    public function __construct($tRXID = null, \StructType\HEADER $hEADER = null, \StructType\Base64Binary $cONTENT = null, $uUID = null, $iD = null)
    {
        $this
            ->setTRXID($tRXID)
            ->setHEADER($hEADER)
            ->setCONTENT($cONTENT)
            ->setUUID($uUID)
            ->setID($iD);
    }
    /**
     * Get TRXID value
     * @return int
     */
    public function getTRXID()
    {
        return $this->TRXID;
    }
    /**
     * Set TRXID value
     * @param int $tRXID
     * @return \StructType\INVOICE
     */
    public function setTRXID($tRXID = null)
    {
        // validation for constraint: int
        if (!is_null($tRXID) && !is_numeric($tRXID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tRXID)), __LINE__);
        }
        $this->TRXID = $tRXID;
        return $this;
    }
    /**
     * Get HEADER value
     * @return \StructType\HEADER|null
     */
    public function getHEADER()
    {
        return $this->HEADER;
    }
    /**
     * Set HEADER value
     * @param \StructType\HEADER $hEADER
     * @return \StructType\INVOICE
     */
    public function setHEADER(\StructType\HEADER $hEADER = null)
    {
        $this->HEADER = $hEADER;
        return $this;
    }
    /**
     * Get CONTENT value
     * @return \StructType\Base64Binary|null
     */
    public function getCONTENT()
    {
        return $this->CONTENT;
    }
    /**
     * Set CONTENT value
     * @param \StructType\Base64Binary $cONTENT
     * @return \StructType\INVOICE
     */
    public function setCONTENT(\StructType\Base64Binary $cONTENT = null)
    {
        $this->CONTENT = $cONTENT;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\INVOICE
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\INVOICE
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\INVOICE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
