<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MarkInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkInvoiceRequest $markInvoiceRequest
     * @return \StructType\MarkInvoiceResponse|bool
     */
    public function MarkInvoice(\StructType\MarkInvoiceRequest $markInvoiceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->MarkInvoice($markInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkEnvelopeRequest $markEnvelopeRequest
     * @return \StructType\MarkEnvelopeResponse|bool
     */
    public function MarkEnvelope(\StructType\MarkEnvelopeRequest $markEnvelopeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->MarkEnvelope($markEnvelopeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MarkEnvelopeResponse|\StructType\MarkInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
