<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceRequest $getInvoiceRequest
     * @return \ArrayType\ArrayOfINVOICE|bool
     */
    public function GetInvoice(\StructType\GetInvoiceRequest $getInvoiceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoice($getInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserListRequest $getUserListRequest
     * @return \StructType\GetUserListResponse|bool
     */
    public function GetUserList(\StructType\GetUserListRequest $getUserListRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserList($getUserListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserListBinary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserListBinaryRequest $getUserListBinaryRequest
     * @return \StructType\GetUserListBinaryResponse|bool
     */
    public function GetUserListBinary(\StructType\GetUserListBinaryRequest $getUserListBinaryRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserListBinary($getUserListBinaryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceStatusRequest $getInvoiceStatusRequest
     * @return \StructType\GetInvoiceStatusResponse|bool
     */
    public function GetInvoiceStatus(\StructType\GetInvoiceStatusRequest $getInvoiceStatusRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoiceStatus($getInvoiceStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeRequest $getEnvelopeRequest
     * @return \ArrayType\ArrayOfENVELOPE|bool
     */
    public function GetEnvelope(\StructType\GetEnvelopeRequest $getEnvelopeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEnvelope($getEnvelopeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEnvelopeStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeStatusRequest $getEnvelopeStatusRequest
     * @return \ArrayType\ArrayOfENVELOPE|bool
     */
    public function GetEnvelopeStatus(\StructType\GetEnvelopeStatusRequest $getEnvelopeStatusRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEnvelopeStatus($getEnvelopeStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAppRespRequestType $getAppRespRequest
     * @return \StructType\GetAppRespResponseType|bool
     */
    public function getApplicationResponse(\StructType\GetAppRespRequestType $getAppRespRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->getApplicationResponse($getAppRespRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSessionInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionInfoRequest $getSessionInfoRequest
     * @return \StructType\GetSessionInfoResponse|bool
     */
    public function GetSessionInfo(\StructType\GetSessionInfoRequest $getSessionInfoRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSessionInfo($getSessionInfoRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ArrayType\ArrayOfENVELOPE|\ArrayType\ArrayOfINVOICE|\StructType\GetAppRespResponseType|\StructType\GetInvoiceStatusResponse|\StructType\GetSessionInfoResponse|\StructType\GetUserListBinaryResponse|\StructType\GetUserListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
