<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for USERCONTENT StructType
 * @subpackage Structs
 */
class USERCONTENT extends Base64Binary
{
    /**
     * The _
     * @var \StructType\Base64Binary
     */
    public $_;
    /**
     * The USERID
     * @var string
     */
    public $USERID;
    /**
     * The USERTYPE
     * Meta informations extracted from the WSDL
     * - default: USER
     * @var string
     */
    public $USERTYPE;
    /**
     * The SIGNTYPE
     * @var string
     */
    public $SIGNTYPE;
    /**
     * The TYPE
     * @var string
     */
    public $TYPE;
    /**
     * Constructor method for USERCONTENT
     * @uses USERCONTENT::set_()
     * @uses USERCONTENT::setUSERID()
     * @uses USERCONTENT::setUSERTYPE()
     * @uses USERCONTENT::setSIGNTYPE()
     * @uses USERCONTENT::setTYPE()
     * @param \StructType\Base64Binary $_
     * @param string $uSERID
     * @param string $uSERTYPE
     * @param string $sIGNTYPE
     * @param string $tYPE
     */
    public function __construct(\StructType\Base64Binary $_ = null, $uSERID = null, $uSERTYPE = 'USER', $sIGNTYPE = null, $tYPE = null)
    {
        $this
            ->set_($_)
            ->setUSERID($uSERID)
            ->setUSERTYPE($uSERTYPE)
            ->setSIGNTYPE($sIGNTYPE)
            ->setTYPE($tYPE);
    }
    /**
     * Get _ value
     * @return \StructType\Base64Binary|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\Base64Binary $_
     * @return \StructType\USERCONTENT
     */
    public function set_(\StructType\Base64Binary $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get USERID value
     * @return string|null
     */
    public function getUSERID()
    {
        return $this->USERID;
    }
    /**
     * Set USERID value
     * @param string $uSERID
     * @return \StructType\USERCONTENT
     */
    public function setUSERID($uSERID = null)
    {
        // validation for constraint: string
        if (!is_null($uSERID) && !is_string($uSERID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uSERID)), __LINE__);
        }
        $this->USERID = $uSERID;
        return $this;
    }
    /**
     * Get USERTYPE value
     * @return string|null
     */
    public function getUSERTYPE()
    {
        return $this->USERTYPE;
    }
    /**
     * Set USERTYPE value
     * @uses \EnumType\USERTYPE::valueIsValid()
     * @uses \EnumType\USERTYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uSERTYPE
     * @return \StructType\USERCONTENT
     */
    public function setUSERTYPE($uSERTYPE = 'USER')
    {
        // validation for constraint: enumeration
        if (!\EnumType\USERTYPE::valueIsValid($uSERTYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $uSERTYPE, implode(', ', \EnumType\USERTYPE::getValidValues())), __LINE__);
        }
        $this->USERTYPE = $uSERTYPE;
        return $this;
    }
    /**
     * Get SIGNTYPE value
     * @return string|null
     */
    public function getSIGNTYPE()
    {
        return $this->SIGNTYPE;
    }
    /**
     * Set SIGNTYPE value
     * @uses \EnumType\SIGNTYPE::valueIsValid()
     * @uses \EnumType\SIGNTYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sIGNTYPE
     * @return \StructType\USERCONTENT
     */
    public function setSIGNTYPE($sIGNTYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SIGNTYPE::valueIsValid($sIGNTYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sIGNTYPE, implode(', ', \EnumType\SIGNTYPE::getValidValues())), __LINE__);
        }
        $this->SIGNTYPE = $sIGNTYPE;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @uses \EnumType\USERCONTENTTYPE::valueIsValid()
     * @uses \EnumType\USERCONTENTTYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tYPE
     * @return \StructType\USERCONTENT
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\USERCONTENTTYPE::valueIsValid($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tYPE, implode(', ', \EnumType\USERCONTENTTYPE::getValidValues())), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\USERCONTENT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
